---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：45-範囲指定カット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **VapourSynthでのstd.Splice使用**：根拠不足（VapourSynthスクリプト生成コードの詳細未確認）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` 104行目 - Ranges As List(Of Range)
- E-02: `Source/General/Misc.vb` 1760行目 - parts-frames複数範囲生成
- E-03: `Source/General/Macro.vb` 522-531行目 - sel_マクロ展開
- E-04: `Source/General/Audio.vb` 36, 247-265行目 - 音声カット処理
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 46行目 - 機能No.45定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Rangesはlist(Of Range)で複数範囲を管理 | E-01 | ○ |
| C-02 | mkvmergeはparts-frames:R1,+R2形式で複数範囲指定 | E-02 | ○ |
| C-03 | Ranges.Select().Join(",+")で形式生成 | E-02 | ○ |
| C-04 | %sel_start%はRanges(0).Startを返す | E-03 (525行目) | ○ |
| C-05 | %sel_end%はRanges(0).Endを返す | E-03 (529行目) | ○ |
| C-06 | Ranges.Count > 0でカット有無判定 | E-03 (523行目), E-04 | ○ |
| C-07 | AviSynthでTrim ++ Trim形式で結合 | E-02 (推測可能) | ○ |
| C-08 | 音声カットはCuttingModeで分岐 | E-04 | ○ |
| C-09 | 字幕カットはmkvmergeで実行 | E-02 | ○ |
| C-10 | 範囲は開始フレーム昇順でソート推奨 | E-02 (Join順序より推測) | ○ |
| C-11 | CutFrameCountは全範囲の合計 | E-01 (関連定義より推測) | ○ |
| C-12 | 機能一覧での機能名は「範囲指定カット」 | E-05 | ○ |
| C-13 | No.44フレームカットの拡張版 | E-01, E-02 | ○ |
| C-14 | VapourSynthではstd.Spliceで結合 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- VapourSynthでの複数範囲結合処理（std.Splice）の実装詳細
  - 候補：GlobalClass.vbのVapourSynth用Trim生成コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Rangesリスト管理は正確
- 0: 低リスク - mkvmergeの複数範囲形式は正確
- 1: 中リスク - VapourSynthのstd.Splice使用は確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vbのRanges定義（104行目）を確認
- [ ] Misc.vbのparts-frames複数範囲生成（1760行目）を確認
- [ ] Macro.vbの%sel_start%/%sel_end%展開（522-531行目）を確認
- [ ] GlobalClass.vbでVapourSynthのTrim結合処理を確認
