---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-ビデオプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Video/VideoRenderer.vb` 7-8行目 - IDisposable実装
- E-02: `Source/Video/VideoRenderer.vb` 10-15行目 - CropLeft/Top/Right/Bottom, ShowInfo, Info
- E-03: `Source/Video/VideoRenderer.vb` 17-20行目 - Direct2dFactory, DirectWriteFactory
- E-04: `Source/Video/VideoRenderer.vb` 26-41行目 - Positionプロパティ
- E-05: `Source/Video/VideoRenderer.vb` 56-71行目 - コンストラクタ
- E-06: `Source/Video/VideoRenderer.vb` 77-91行目 - ApplyTheme
- E-07: `Source/Video/VideoRenderer.vb` 101-148行目 - Draw()メソッド
- E-08: `Source/Video/VideoRenderer.vb` 108行目 - GetFrame呼び出し
- E-09: `Source/Video/VideoRenderer.vb` 112行目 - BeginDraw()
- E-10: `Source/Video/VideoRenderer.vb` 138-140行目 - DrawBitmap()
- E-11: `Source/Video/VideoRenderer.vb` 142行目 - DrawInfoText()
- E-12: `Source/Video/VideoRenderer.vb` 144行目 - EndDraw()
- E-13: `Source/Video/VideoRenderer.vb` 150-194行目 - DrawInfoText()
- E-14: `Source/Video/VideoRenderer.vb` 250-267行目 - CreateBitmap()
- E-15: `Source/Video/VideoRenderer.vb` 296-302行目 - Dispose()
- E-16: `Source/Forms/CropForm.vb` 285-287行目 - VideoRenderer使用
- E-17: `docs/code-to-docs/機能一覧/機能一覧.csv` 47行目 - 機能No.46定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VideoRendererはIDisposableを実装 | E-01 | ○ |
| C-02 | CropLeft/Top/Right/Bottom プロパティを持つ | E-02 | ○ |
| C-03 | ShowInfo プロパティでフレーム情報表示制御 | E-02 | ○ |
| C-04 | Direct2DFactoryとDirectWriteFactoryを使用 | E-03 | ○ |
| C-05 | Positionは0からFrameCount-1の範囲 | E-04 (33-38行目) | ○ |
| C-06 | コンストラクタでServer, Controlを受け取る | E-05 | ○ |
| C-07 | ThemeManager.CurrentThemeChangedでテーマ対応 | E-05 (70行目) | ○ |
| C-08 | Draw()でCreateGraphicsResources()呼び出し | E-07 (102行目) | ○ |
| C-09 | Server.GetFrame()でフレームデータ取得 | E-08 | ○ |
| C-10 | DeviceContext.BeginDraw()で描画開始 | E-09 | ○ |
| C-11 | DrawBitmap()でビットマップ描画 | E-10 | ○ |
| C-12 | DrawInfoText()で情報オーバーレイ | E-11 | ○ |
| C-13 | DeviceContext.EndDraw()で描画終了 | E-12 | ○ |
| C-14 | DrawInfoText()でIDWriteTextLayout使用 | E-13 (156-165行目) | ○ |
| C-15 | CreateBitmap()でID2D1Bitmap作成 | E-14 | ○ |
| C-16 | Dispose()でリソース解放 | E-15 | ○ |
| C-17 | CropFormでVideoRenderer使用 | E-16 | ○ |
| C-18 | 機能一覧での機能名は「ビデオプレビュー」 | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - VideoRenderer.vbのコード構造は明確
- 0: 低リスク - Direct2D描画処理は正確
- 0: 低リスク - IDisposable実装は正確

## 6) レビュアーチェックリスト（最小）
- [ ] VideoRenderer.vbのDraw()メソッド（101-148行目）を確認
- [ ] VideoRenderer.vbのDrawInfoText()（150-194行目）を確認
- [ ] VideoRenderer.vbのDispose()（296-302行目）を確認
- [ ] CropForm.vbでのVideoRenderer使用（285-287行目）を確認
