---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-クロップ調整UI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/CropForm.vb` 142-147行目 - フィールド定義
- E-02: `Source/Forms/CropForm.vb` 149-151行目 - Color プロパティ
- E-03: `Source/Forms/CropForm.vb` 380-404行目 - GetSide()メソッド
- E-04: `Source/Forms/CropForm.vb` 406-427行目 - MouseCrop()メソッド
- E-05: `Source/Forms/CropForm.vb` 429-448行目 - SelectBorder()メソッド
- E-06: `Source/Forms/CropForm.vb` 459-465行目 - FixMod()メソッド
- E-07: `Source/Forms/CropForm.vb` 467-515行目 - UpdateAll()メソッド
- E-08: `Source/Forms/CropForm.vb` 517-523行目 - pVideo_MouseMove
- E-09: `Source/Forms/CropForm.vb` 525-530行目 - pVideo_MouseDown
- E-10: `Source/Forms/CropForm.vb` 637-653行目 - RunAutoCrop()
- E-11: `Source/Forms/CropForm.vb` 656-659行目 - RunSmartCrop()
- E-12: `Source/Forms/CropForm.vb` 734-741行目 - OnMouseWheel
- E-13: `Source/General/Project.vb` 233-275行目 - CropLeft/Top/Right/Bottom
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` 48行目 - 機能No.47定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CropFormにFrameServer, Renderer, Side, ActiveCropSide フィールド | E-01 | ○ |
| C-02 | BorderColor, BorderSelectedColor プロパティ | E-02 | ○ |
| C-03 | GetSide()でマウス位置から最寄りの辺を判定 | E-03 | ○ |
| C-04 | マウス位置から各辺への距離を計算して最小を選択 | E-03 (389-400行目) | ○ |
| C-05 | MouseCrop()でクロップ値を計算 | E-04 | ○ |
| C-06 | ActiveCropSideに応じてp.CropXXXを更新 | E-04 (415-424行目) | ○ |
| C-07 | SelectBorder()でアクティブ辺をハイライト | E-05 | ○ |
| C-08 | FixMod()で偶数補正 | E-06 | ○ |
| C-09 | AutoCorrectCropValues有効時のみ補正 | E-06 (460行目) | ○ |
| C-10 | UpdateAll()で表示更新 | E-07 | ○ |
| C-11 | 最大クロップは元サイズの80%以下 | E-07 (468-469行目) | ○ |
| C-12 | pVideo_MouseMoveでドラッグ判定 | E-08 | ○ |
| C-13 | ドラッグ中はMouseCrop()、それ以外はMouseSelectBorder() | E-08 (518-522行目) | ○ |
| C-14 | pVideo_MouseDownでActiveCropSide設定 | E-09 | ○ |
| C-15 | RunAutoCrop()でg.RunAutoCrop()呼び出し | E-10 (645行目) | ○ |
| C-16 | RunSmartCrop()でg.SmartCrop()呼び出し | E-11 | ○ |
| C-17 | マウスホイールでもクロップ調整可能 | E-12 | ○ |
| C-18 | Ctrl押下で両辺同時調整 | E-12 (740行目) | ○ |
| C-19 | p.CropLeft/Top/Right/Bottomでクロップ値保持 | E-13 | ○ |
| C-20 | 機能一覧での機能名は「クロップ調整UI」 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CropForm.vbのマウス操作処理は正確
- 0: 低リスク - GetSide()の辺判定ロジックは正確
- 0: 低リスク - FixMod()の偶数補正は正確

## 6) レビュアーチェックリスト（最小）
- [ ] CropForm.vbのGetSide()（380-404行目）を確認
- [ ] CropForm.vbのMouseCrop()（406-427行目）を確認
- [ ] CropForm.vbのFixMod()（459-465行目）を確認
- [ ] CropForm.vbのUpdateAll()（467-515行目）を確認
- [ ] Project.vbのCropプロパティ（233-275行目）を確認
