---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-比較プレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/VideoComparisonForm.vb` 7-13行目 - クラスフィールド
- E-02: `Source/Forms/VideoComparisonForm.vb` 35-47行目 - コンテキストメニュー設定
- E-03: `Source/Forms/VideoComparisonForm.vb` 129-150行目 - Add()メソッド
- E-04: `Source/Forms/VideoComparisonForm.vb` 153-177行目 - Add(sourcePath)メソッド
- E-05: `Source/Forms/VideoComparisonForm.vb` 195-226行目 - Save()メソッド
- E-06: `Source/Forms/VideoComparisonForm.vb` 228-236行目 - TrackBar_ValueChanged
- E-07: `Source/Forms/VideoComparisonForm.vb` 247-257行目 - NextTab()
- E-08: `Source/Forms/VideoComparisonForm.vb` 265-279行目 - OnMouseWheel
- E-09: `Source/Forms/VideoComparisonForm.vb` 291-331行目 - CropZoom()
- E-10: `Source/Forms/VideoComparisonForm.vb` 354-365行目 - VideoTabプロパティ
- E-11: `Source/Forms/VideoComparisonForm.vb` 393-490行目 - VideoTab.Open()
- E-12: `Source/Forms/VideoComparisonForm.vb` 464-488行目 - CSVログ読み込み
- E-13: `Source/Forms/VideoComparisonForm.vb` 536-538行目 - GetBitmap()
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` 49行目 - 機能No.48定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Shared Property PosでフレームPosition共有 | E-01 (8行目) | ○ |
| C-02 | CropLeft/Top/Right/Bottomで表示クロップ設定 | E-01 (12行目) | ○ |
| C-03 | コンテキストメニューで操作（Add, Remove, Save等） | E-02 | ○ |
| C-04 | Add()でファイル選択ダイアログ表示 | E-03 | ○ |
| C-05 | 既存ソースファイルがあれば自動追加 | E-03 (132-137行目) | ○ |
| C-06 | VideoTab作成時にOpen()呼び出し | E-04 (162行目) | ○ |
| C-07 | Save()で全タブのPNG保存 | E-05 | ○ |
| C-08 | ImageFrameNumberPositionでファイル名形式選択 | E-05 (199-204行目) | ○ |
| C-09 | TrackBar_ValueChangedでフレーム同期 | E-06 | ○ |
| C-10 | NextTab()でタブ切り替え（Space） | E-07 | ○ |
| C-11 | マウスホイールで100フレーム移動 | E-08 (268行目) | ○ |
| C-12 | s.ReverseVideoScrollDirectionで逆方向対応 | E-08 (274-276行目) | ○ |
| C-13 | CropZoom()でクロップ設定ダイアログ | E-09 | ○ |
| C-14 | VideoTabにServer, Form, FileType等プロパティ | E-10 | ○ |
| C-15 | Open()でファイルタイプ判定、スクリプト生成 | E-11 (398-437行目) | ○ |
| C-16 | CSVログがあればFrameInfo表示 | E-12 | ○ |
| C-17 | GetBitmap()でビットマップ取得 | E-13 | ○ |
| C-18 | 機能一覧での機能名は「比較プレビュー」 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - VideoComparisonForm.vbのコード構造は明確
- 0: 低リスク - フレーム同期処理は正確
- 0: 低リスク - PNG保存処理は正確

## 6) レビュアーチェックリスト（最小）
- [ ] VideoComparisonForm.vbのAdd()（129-177行目）を確認
- [ ] VideoComparisonForm.vbのSave()（195-226行目）を確認
- [ ] VideoComparisonForm.vbのVideoTab.Open()（393-490行目）を確認
- [ ] CSVログ読み込み処理（464-488行目）を確認
