---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-サムネイルシート生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Thumbnailer.vb` 10-13行目 - ThumbnailerRowMode enum
- E-02: `Source/General/Thumbnailer.vb` 56-274行目 - RunAsync()メソッド
- E-03: `Source/General/Thumbnailer.vb` 72-90行目 - ThumbnailerSettings読み込み
- E-04: `Source/General/Thumbnailer.vb` 74行目 - ThumbWidth（600デフォルト、0-1920）
- E-05: `Source/General/Thumbnailer.vb` 81行目 - Interval（60デフォルト、1-1800）
- E-06: `Source/General/Thumbnailer.vb` 82行目 - Columns（4デフォルト、1-50）
- E-07: `Source/General/Thumbnailer.vb` 83行目 - Rows（6デフォルト、1-80）
- E-08: `Source/General/Thumbnailer.vb` 165-166行目 - rows/thumbCount計算
- E-09: `Source/General/Thumbnailer.vb` 211-212行目 - Parallel.For MaxDegreeOfParallelism=4
- E-10: `Source/General/Thumbnailer.vb` 213行目 - serverPos計算
- E-11: `Source/General/Thumbnailer.vb` 232行目 - タイムスタンプ取得
- E-12: `Source/General/Thumbnailer.vb` 254-255行目 - rowPos/columnPos計算
- E-13: `Source/General/Thumbnailer.vb` 258行目 - DrawImage()
- E-14: `Source/General/Thumbnailer.vb` 270行目 - image.Save()
- E-15: `Source/General/Thumbnailer.vb` 278-320行目 - PrepareVapoursynthVideoScriptAsync()
- E-16: `Source/General/Thumbnailer.vb` 293行目 - ffms2.Source
- E-17: `Source/General/Thumbnailer.vb` 296行目 - resize.Spline64
- E-18: `Source/General/Thumbnailer.vb` 299-306行目 - HDRトーンマッピング
- E-19: `Source/General/Thumbnailer.vb` 324-420行目 - GetHeaderInfosAsync()
- E-20: `docs/code-to-docs/機能一覧/機能一覧.csv` 50行目 - 機能No.49定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThumbnailerRowModeはFixed/TimeIntervalの2種類 | E-01 | ○ |
| C-02 | ThumbWidth デフォルト600、最大1920 | E-04 | ○ |
| C-03 | Interval デフォルト60秒、1-1800範囲 | E-05 | ○ |
| C-04 | Columns デフォルト4、1-50範囲 | E-06 | ○ |
| C-05 | Rows デフォルト6、1-80範囲 | E-07 | ○ |
| C-06 | calculatedRowsはRowModeで分岐 | E-08 | ○ |
| C-07 | Parallel.ForでMaxDegreeOfParallelism=4 | E-09 | ○ |
| C-08 | serverPos計算式 | E-10 | ○ |
| C-09 | g.GetTimeString()でタイムスタンプ取得 | E-11 | ○ |
| C-10 | rowPos = index \ columns, columnPos = index Mod columns | E-12 | ○ |
| C-11 | imageGraphics.DrawImage()でサムネイル配置 | E-13 | ○ |
| C-12 | image.Save(imageFilePath, imageCI, imageEPs)で保存 | E-14 | ○ |
| C-13 | VapourSynthスクリプトを動的生成 | E-15 | ○ |
| C-14 | ffms2.Sourceでソース読み込み | E-16 | ○ |
| C-15 | resize.Spline64でリサイズ | E-17 | ○ |
| C-16 | HDR映像はplacebo.Tonemapでトーンマッピング | E-18 | ○ |
| C-17 | VSLibPlacebo.RequirementsFulfilledでプラグイン確認 | E-18 (303行目) | ○ |
| C-18 | GetHeaderInfosAsync()でMediaInfoから情報収集 | E-19 | ○ |
| C-19 | ヘッダーにファイル名、サイズ、解像度、FPS等表示 | E-19 (343-376行目) | ○ |
| C-20 | 機能一覧での機能名は「サムネイルシート生成」 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Thumbnailer.vbのロジックは明確
- 0: 低リスク - パラメータ検証は正確
- 0: 低リスク - HDRトーンマッピング対応は正確

## 6) レビュアーチェックリスト（最小）
- [ ] Thumbnailer.vbのRunAsync()（56-274行目）を確認
- [ ] ThumbnailerSettingsパラメータ読み込み（72-90行目）を確認
- [ ] Parallel.For並列処理（211-262行目）を確認
- [ ] HDRトーンマッピング処理（299-306行目）を確認
