---
generated_at: 2026-01-21 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-ffmpeg Demux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - ffmpegDemuxerクラス（245-458行目）
- E-02: `Source/General/Demux.vb` - ffmpegDemuxer.Run（253-301行目）
- E-03: `Source/General/Demux.vb` - DemuxVideo（303-336行目）
- E-04: `Source/General/Demux.vb` - DemuxAudio（338-394行目）
- E-05: `Source/General/Demux.vb` - DemuxSubtitles（396-443行目）
- E-06: `Source/Forms/StreamDemuxForm.vb` - StreamDemuxFormクラス
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.5定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ffmpegDemuxerはDemuxerを継承 | E-01 | ○ |
| C-02 | InputExtensionsは{"avi", "flv", "m2ts", "ts"} | E-01 | ○ |
| C-03 | OutputExtensionsはFileTypes.VideoDemuxOutput | E-01 | ○ |
| C-04 | Run()でStreamDemuxForm表示 | E-02, E-06 | ○ |
| C-05 | DemuxVideoで-c:v copy -an -sn使用 | E-03 | ○ |
| C-06 | DemuxAudioで-c:a copy使用 | E-04 | ○ |
| C-07 | DTS形式は-f dts指定 | E-04 | ○ |
| C-08 | PCM形式はpcm_s*le変換 | E-04 | ○ |
| C-09 | 20bitは24bitに補正 | E-04 | ○ |
| C-10 | 複数オーディオ時に-map 0:a:index | E-04 | ○ |
| C-11 | probesize 20M/analyzeduration 20M | E-04 | ○ |
| C-12 | MKS字幕はdvbsubコーデック | E-05 | ○ |
| C-13 | srt字幕はsrtコーデック | E-05 | ○ |
| C-14 | UTF-8エンコーディング使用 | E-03, E-04 | ○ |
| C-15 | -hide_bannerオプション使用 | E-03, E-04 | ○ |
| C-16 | HasConfigDialogはTrue | E-01 | ○ |
| C-17 | Nameは"ffmpeg: Demux" | E-01 | ○ |
| C-18 | フォールバック処理として使用される | E-01, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドライン構築はコードで明確に定義
- 0: 低リスク - オーディオコーデック判定ロジックは単純

## 6) レビュアーチェックリスト（最小）
- [ ] ffmpegDemuxer.Run()の処理フローを確認
- [ ] DemuxAudio()のDTS/PCM分岐を確認
- [ ] DemuxSubtitles()のコーデック選択を確認
- [ ] probesize/analyzedurationパラメータの妥当性を確認
