---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-カスタマイズ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` 151行目 - ThumbnailerSettings As ObjectStorage
- E-02: `Source/General/Thumbnailer.vb` 72行目 - settings = proj.ThumbnailerSettings
- E-03: `Source/General/Thumbnailer.vb` 74行目 - ThumbWidth設定
- E-04: `Source/General/Thumbnailer.vb` 81行目 - Interval設定
- E-05: `Source/General/Thumbnailer.vb` 82行目 - Columns設定
- E-06: `Source/General/Thumbnailer.vb` 83行目 - Rows設定
- E-07: `Source/General/Thumbnailer.vb` 84行目 - RowMode設定
- E-08: `Source/General/Thumbnailer.vb` 85-86行目 - SpacerPercent/spacer計算
- E-09: `Source/General/Thumbnailer.vb` 88-91行目 - タイムスタンプフォント設定
- E-10: `Source/General/Thumbnailer.vb` 92-95行目 - タイムスタンプ色設定
- E-11: `Source/General/Thumbnailer.vb` 96-97行目 - アウトライン設定
- E-12: `Source/General/Thumbnailer.vb` 99-107行目 - TimestampAlignment設定
- E-13: `Source/General/Thumbnailer.vb` 115行目 - Header設定
- E-14: `Source/General/Thumbnailer.vb` 118-123行目 - ヘッダーフォント・色設定
- E-15: `Source/General/Thumbnailer.vb` 125-126行目 - HeaderSeparatorHeight設定
- E-16: `Source/General/Thumbnailer.vb` 112-113行目 - ImageBackColor設定
- E-17: `Source/General/Thumbnailer.vb` 128行目 - ImageFileFormat設定
- E-18: `Source/General/Thumbnailer.vb` 129行目 - ImageQuality設定
- E-19: `Source/General/Thumbnailer.vb` 145-149行目 - ImageFilePathWithoutExtension設定
- E-20: `docs/code-to-docs/機能一覧/機能一覧.csv` 51行目 - 機能No.50定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThumbnailerSettingsはObjectStorageで保存 | E-01, E-02 | ○ |
| C-02 | ThumbWidth: デフォルト600、範囲0-1920 | E-03 | ○ |
| C-03 | Interval: デフォルト60、範囲1-1800 | E-04 | ○ |
| C-04 | Columns: デフォルト4、範囲1-50 | E-05 | ○ |
| C-05 | Rows: デフォルト6、範囲1-80 | E-06 | ○ |
| C-06 | RowMode: Fixed=0, TimeInterval=1 | E-07 | ○ |
| C-07 | SpacerPercent: デフォルト20、範囲0-1000 | E-08 | ○ |
| C-08 | spacer = thumbWidth / 10 * (SpacerPercent / 100) | E-08 | ○ |
| C-09 | TimestampFontName: FontManager.GetThumbnailFont().Nameがデフォルト | E-09 | ○ |
| C-10 | TimestampFontSizePercent: デフォルト100、範囲10-1000 | E-09 | ○ |
| C-11 | TimestampFontColor/OutlineColor: HTML形式で保存 | E-10 | ○ |
| C-12 | TimestampOutlineStrengthPercent: デフォルト100、範囲0-1000 | E-11 | ○ |
| C-13 | TimestampAlignment: Enum.TryParseで取得 | E-12 | ○ |
| C-14 | Header: デフォルトtrue | E-13 | ○ |
| C-15 | HeaderFontName/Size/Color: 独立設定 | E-14 | ○ |
| C-16 | HeaderSeparatorHeightPercent: デフォルト0、範囲0-1000 | E-15 | ○ |
| C-17 | ImageBackColor: HTML形式、デフォルト黒(#0D0D0D程度) | E-16 | ○ |
| C-18 | ImageFileFormat: jpg/png/bmp/gif/tif、デフォルトjpg | E-17 | ○ |
| C-19 | ImageQuality: デフォルト70、範囲1-100 | E-18 | ○ |
| C-20 | ImageFilePathWithoutExtension: マクロ展開対応 | E-19 | ○ |
| C-21 | Mathf.Clampで範囲制限 | E-03, E-04, E-05, E-06 | ○ |
| C-22 | 機能一覧での機能名は「カスタマイズ設定」 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ObjectStorageによる設定保存は明確
- 0: 低リスク - 各パラメータの範囲制限は正確
- 0: 低リスク - デフォルト値は正確

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vbのThumbnailerSettings定義（151行目）を確認
- [ ] Thumbnailer.vbの設定読み込み（72-149行目）を確認
- [ ] 各パラメータのMathf.Clamp範囲を確認
- [ ] HTML形式の色設定が正しく動作することを確認
