---
generated_at: 2025-01-21 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 55-ジョブキュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/JobsForm.vb` JobsFormクラス（1-451行目）
- E-02: `Source/General/JobManager.vb` JobManagerクラス
- E-03: `機能一覧.csv` No.55 ジョブキュー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobsFormクラスが存在する | E-01 (7行目) | ○ |
| C-02 | ListViewExでジョブ一覧表示 | E-01 (15行目) | ○ |
| C-03 | チェックボックスでActive管理 | E-01 (206-208行目) | ○ |
| C-04 | JobManager.GetJobs()でジョブ読込 | E-01 (209行目) | ○ |
| C-05 | FileSystemWatcherでファイル監視 | E-01 (186, 434-440行目) | ○ |
| C-06 | Jobs.datファイルを監視 | E-01 (436行目) | ○ |
| C-07 | bnStart_ClickでProcessJobs呼び出し | E-01 (389-404行目) | ○ |
| C-08 | bnLoad_ClickでLoadProject呼び出し | E-01 (406-412行目) | ○ |
| C-09 | SaveJobs()でジョブ保存 | E-01 (371-387行目) | ○ |
| C-10 | BlockSaveフラグで重複保存防止 | E-01 (188, 279-297行目) | ○ |
| C-11 | Batch Projectsフォルダ内ファイル削除 | E-01 (219-225行目) | ○ |
| C-12 | コンテキストメニューでSelect All等 | E-01 (227-244行目) | ○ |
| C-13 | bnUp/bnDownで順序変更 | E-01 (200-201, 236-240行目) | ○ |
| C-14 | Reload()で変更監視時リロード | E-01 (351-362行目) | ○ |
| C-15 | UpdateControls()でUI更新 | E-01 (364-369行目) | ○ |
| C-16 | Start後フォームを閉じる | E-01 (394行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] JobsFormクラスのコードを確認した
- [x] ジョブの読込/保存処理を確認した
- [x] FileSystemWatcherの設定を確認した
- [x] コンテキストメニューの操作を確認した
