---
generated_at: 2025-01-21 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 56-ジョブ実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/JobsForm.vb` bnStart_Click（389-404行目）
- E-02: `Source/General/GlobalClass.vb` ProcessJobs
- E-03: `機能一覧.csv` No.56 ジョブ実行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bnStart_Clickで処理開始 | E-01 (389行目) | ○ |
| C-02 | g.VerifyRequirements()で要件確認 | E-01 (390行目) | ○ |
| C-03 | g.IsJobProcessing判定 | E-01 (396行目) | ○ |
| C-04 | 別インスタンス起動コマンド"-StartJobs -NoFocus" | E-01 (397行目) | ○ |
| C-05 | Close()でフォーム閉じる | E-01 (394行目) | ○ |
| C-06 | Task.Runで非同期実行 | E-01 (399行目) | ○ |
| C-07 | Thread.Sleep(500)で待機 | E-01 (400行目) | ○ |
| C-08 | g.MainForm.Invokeで呼び出し | E-01 (401行目) | ○ |
| C-09 | g.ProcessJobs()呼び出し | E-01 (401行目) | ○ |
| C-10 | g.ShellExecuteで外部プロセス起動 | E-01 (397行目) | ○ |
| C-11 | Application.ExecutablePathを使用 | E-01 (397行目) | ○ |
| C-12 | 要件未満足時にExit Sub | E-01 (391-392行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] bnStart_Clickのコードを確認した
- [x] インスタンス判定ロジックを確認した
- [x] 非同期実行の仕組みを確認した
- [x] コマンドライン引数を確認した
