---
generated_at: 2025-01-21 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 57-イベントコマンド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/EventCommandsEditor.vb` EventCommandsEditorクラス（1-308行目）
- E-02: `Source/Forms/EventCommandEditor.vb` EventCommandEditorクラス（1-535行目）
- E-03: `機能一覧.csv` No.57 イベントコマンド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventCommandsEditorクラス存在 | E-01 (4行目) | ○ |
| C-02 | EventCommandEditorクラス存在 | E-02 (4行目) | ○ |
| C-03 | tbNameでコマンド名入力 | E-02 (8行目) | ○ |
| C-04 | cbEventでイベント選択 | E-02 (9行目) | ○ |
| C-05 | rbMatchAllCriteria存在 | E-02 (17行目) | ○ |
| C-06 | rbMatchAnyCriteria存在 | E-02 (18行目) | ○ |
| C-07 | CriteriaControl存在 | E-02 (11行目) | ○ |
| C-08 | pgParametersでパラメータ表示 | E-02 (15行目) | ○ |
| C-09 | bnAdd_Clickで追加処理 | E-01 (283-291行目) | ○ |
| C-10 | bnEdit_Clickで編集処理 | E-01 (301-307行目) | ○ |
| C-11 | bnClone_ClickでGetCopy使用 | E-01 (297-299行目) | ○ |
| C-12 | Macro.GetMacrosで条件取得 | E-02 (375行目) | ○ |
| C-13 | MenuClickでCommandParameters設定 | E-02 (434-437行目) | ○ |
| C-14 | OrOnlyでマッチモード管理 | E-02 (370-371, 504行目) | ○ |
| C-15 | EventCommand.Enabledで有効/無効 | E-01 (237行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] EventCommandsEditorのコードを確認した
- [x] EventCommandEditorのコードを確認した
- [x] 条件システムの実装を確認した
- [x] コマンド選択メニューの実装を確認した
