---
generated_at: 2025-01-21 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 58-マクロ機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Macro.vb` Macroクラス（1-811行目）
- E-02: `Source/Forms/MacrosForm.vb` MacrosForm
- E-03: `機能一覧.csv` No.58 マクロ機能

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Macroクラスが<Serializable()>属性を持つ | E-01 (8行目) | ○ |
| C-02 | IComparable(Of Macro)を実装 | E-01 (10行目) | ○ |
| C-03 | GetMacros()でマクロ一覧取得 | E-01 (124-255行目) | ○ |
| C-04 | Expand()でマクロ展開 | E-01 (340-689行目) | ○ |
| C-05 | ExpandGUI()で対話的マクロ展開 | E-01 (257-337行目) | ○ |
| C-06 | %source_file%マクロ存在 | E-01 (167, 356行目) | ○ |
| C-07 | %target_file%マクロ存在 | E-01 (188, 408行目) | ○ |
| C-08 | %video_bitrate%マクロ存在 | E-01 (205, 417行目) | ○ |
| C-09 | %eval:expression%マクロ存在 | E-01 (225, 654-670行目) | ○ |
| C-10 | $browse_file$対話マクロ存在 | E-01 (210, 261-272行目) | ○ |
| C-11 | $enter_text$対話マクロ存在 | E-01 (211, 274-283行目) | ○ |
| C-12 | $select:...$対話マクロ存在 | E-01 (213, 300-334行目) | ○ |
| C-13 | %app_path:name%マクロ存在 | E-01 (223, 560-577行目) | ○ |
| C-14 | MediaInfo連携でメディア情報取得 | E-01 (375-398行目) | ○ |
| C-15 | PowerShell.InvokeAndConvert呼び出し | E-01 (660行目) | ○ |
| C-16 | Package.Items.Values使用 | E-01 (545-546, 564-565行目) | ○ |
| C-17 | 環境変数展開対応 | E-01 (672-686行目) | ○ |
| C-18 | Contains()で不要な処理をスキップ | E-01 (350-351行目など) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] Macroクラスの構造を確認した
- [x] GetMacros()のマクロ定義を確認した
- [x] Expand()の展開ロジックを確認した
- [x] ExpandGUI()の対話的マクロを確認した
