---
generated_at: 2025-01-21 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート: 59-PowerShell連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **PowerShell.vbの詳細実装**：別途確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/PowerShell.vb` PowerShellクラス（ファイル存在確認済み）
- E-02: `Source/General/Macro.vb` evalマクロ処理（654-670行目）
- E-03: `機能一覧.csv` No.59 PowerShell連携

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PowerShellクラスが存在する | E-01 | ○ |
| C-02 | %eval:%マクロでPowerShell式評価 | E-02 (654-670行目) | ○ |
| C-03 | PowerShell.InvokeAndConvert呼び出し | E-02 (660行目) | ○ |
| C-04 | 例外時にex.ToStringを返す | E-02 (662行目) | ○ |
| C-05 | Folder.Scriptsでスクリプトディレクトリ参照 | E-02 (469行目) | ○ |
| C-06 | %script_dir%マクロでスクリプトディレクトリ取得 | E-02 (156, 469行目) | ○ |
| C-07 | System.Management.Automation使用 | E-01 | ○ |
| C-08 | $p, $g, $s変数が利用可能 | **根拠なし** | △ |
| C-09 | 非同期実行メソッド存在 | E-01 | ○ |
| C-10 | マクロからの呼び出しでTry-Catch使用 | E-02 (659-663行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- PowerShell.vbの詳細実装の確認
  - 候補：Invoke/InvokeAndConvert/InvokeAsyncの具体的実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能のロジックは確認済み
- 1: 中リスク - PowerShell.vbの詳細実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [x] Macro.vb内のeval処理を確認した
- [x] PowerShell.InvokeAndConvert呼び出しを確認した
- [x] 例外処理を確認した
- [ ] PowerShell.vbの詳細実装を確認した
