---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-MP4Box Demux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - MP4BoxDemuxerクラス（461-708行目）
- E-02: `Source/General/Demux.vb` - MP4BoxDemuxer.Run（471-592行目）
- E-03: `Source/General/Demux.vb` - DemuxVideo（606-640行目）
- E-04: `Source/General/Demux.vb` - DemuxAudio（642-693行目）
- E-05: `Source/General/Demux.vb` - GetAttachments（695-701行目）
- E-06: `Source/Forms/StreamDemuxForm.vb` - StreamDemuxFormクラス
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.6定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MP4BoxDemuxerはDemuxerを継承 | E-01 | ○ |
| C-02 | InputExtensionsは{"mp4", "m4v", "mov"} | E-01 | ○ |
| C-03 | Run()でStreamDemuxForm表示 | E-02, E-06 | ○ |
| C-04 | DemuxVideoで-raw/-aviオプション使用 | E-03 | ○ |
| C-05 | avi形式は-aviオプション | E-03 | ○ |
| C-06 | DemuxAudioで-raw/-singleオプション使用 | E-04 | ○ |
| C-07 | AAC/Opusは-singleオプション | E-04 | ○ |
| C-08 | PCM形式はffmpegにフォールバック | E-04 | ○ |
| C-09 | 抽出失敗時ffmpegでリトライ | E-03, E-04 | ○ |
| C-10 | SRT字幕は-srtオプション | E-02 | ○ |
| C-11 | -dump-coverでカバーアート抽出 | E-02 | ○ |
| C-12 | -dump-chap-oggでチャプター抽出 | E-02 | ○ |
| C-13 | GetAttachmentsでカバー情報取得 | E-05 | ○ |
| C-14 | Chapters_Pos判定でチャプター存在確認 | E-02 | ○ |
| C-15 | SkipStringは"|" | E-02 | ○ |
| C-16 | OutputExtensionsはDemuxVideo設定に依存 | E-01 | ○ |
| C-17 | HasConfigDialogはTrue | E-01 | ○ |
| C-18 | Nameは"MP4Box: Demux" | E-01 | ○ |
| C-19 | MediaInfo.GetFormatで形式検出 | E-04 | ○ |
| C-20 | カバーアート出力先はcover.jpg | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MP4Boxコマンドライン構築はコードで明確に定義
- 0: 低リスク - フォールバック処理の条件分岐は単純

## 6) レビュアーチェックリスト（最小）
- [ ] MP4BoxDemuxer.Run()の処理フローを確認
- [ ] DemuxAudio()のAAC/Opus/PCM分岐を確認
- [ ] フォールバック処理の発動条件を確認
- [ ] チャプター存在判定ロジックを確認
