---
generated_at: 2025-01-21 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 60-外部ツール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Package.vb` Packageクラス
- E-02: `Source/Forms/AppsForm.vb` AppsFormクラス
- E-03: `Source/General/Macro.vb` app_pathマクロ処理（560-577行目）
- E-04: `機能一覧.csv` No.60 外部ツール管理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Packageクラスが存在する | E-01 | ○ |
| C-02 | AppsFormが存在する | E-02 | ○ |
| C-03 | Package.Itemsでツール一覧管理 | E-03 (545-546行目) | ○ |
| C-04 | %app_path:name%マクロ存在 | E-03 (560-577行目) | ○ |
| C-05 | %app_dir:name%マクロ存在 | E-03 (579-594行目) | ○ |
| C-06 | %app_version:name%マクロ存在 | E-03 (596-611行目) | ○ |
| C-07 | Package.Items.Values.FirstOrDefaultで検索 | E-03 (564-565行目) | ○ |
| C-08 | pack.Pathでパス取得 | E-03 (567行目) | ○ |
| C-09 | pack.Versionでバージョン取得 | E-03 (601行目) | ○ |
| C-10 | path.Dirでディレクトリ取得 | E-03 (587行目) | ○ |
| C-11 | 名前は大文字小文字を区別しない | E-03 (565行目) ToLowerInvariant比較 | ○ |
| C-12 | ffmpegパッケージ存在 | E-01, Grep結果 | ○ |
| C-13 | VerifyOK()メソッド存在 | E-01, Grep結果 | ○ |
| C-14 | Package.Nameプロパティ存在 | E-03 (546行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] Package.vbのクラス構造を確認した
- [x] AppsForm.vbの存在を確認した
- [x] Macro.vb内のapp_path処理を確認した
- [x] Package.Items辞書の使用方法を確認した
