---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-ツール自動ダウンロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ダウンロードファイルの一時保存先**：コード上はFolder.Desktopだが、ユーザー環境依存の可能性
  2. **AppsFormからのUI更新インターフェース**：IUpdateUIインターフェースの詳細実装
  3. **7-Zipの事前インストール要件**：Package.SevenZipの利用可否条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/ToolUpdate.vb`（1-217行目）
- E-02: `Source/General/Package.vb`（1-300行目）
- E-03: `Source/Forms/AppsForm.vb`
- E-04: `Source/Forms/DownloadForm.vb`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（62行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HttpClientでダウンロードURLからHTML取得 | E-01 (24-25行目) | ○ |
| C-02 | 正規表現href=(""\|')[^ ]+\.(7z\|zip\|exe)(""\|')でリンク抽出 | E-01 (26行目) | ○ |
| C-03 | Package.IncludeによるフィルタリングはInclude=""のときスキップ | E-01 (32行目) | ○ |
| C-04 | ダウンロードファイルはデスクトップに保存 | E-01 (41行目: Folder.Desktop) | ○ |
| C-05 | DownloadFormでダウンロード処理を実行 | E-01 (53-54行目) | ○ |
| C-06 | 7-Zipで解凍（x -y オプション使用） | E-01 (76-77行目) | ○ |
| C-07 | 解凍後にサブフォルダ選択のTaskDialogを表示 | E-01 (98-112行目) | ○ |
| C-08 | Package.Keepで指定されたファイルは削除しない | E-01 (129行目, 138-140行目) | ○ |
| C-09 | 旧ファイルをごみ箱に送る | E-01 (142行目, 150行目: RecycleOption.SendToRecycleBin) | ○ |
| C-10 | 新ファイルをFileHelp.Copy/FolderHelp.Copyでコピー | E-01 (171-177行目) | ○ |
| C-11 | バージョン入力ダイアログでバージョン名を設定 | E-01 (188-198行目) | ○ |
| C-12 | 64ビット環境でx86版を除外するIgnore関数 | E-01 (201-211行目) | ○ |
| C-13 | Package.ExcludeでContainsAnyによる除外 | E-01 (202-204行目) | ○ |
| C-14 | UpdateUI.UpdateUI()でUI更新 | E-01 (213-215行目) | ○ |
| C-15 | Packageクラスに各種プロパティ（DownloadURL、Filename等）が定義 | E-02 (11-42行目) | ○ |
| C-16 | ffmpegパッケージの定義例 | E-02 (117-128行目) | ○ |
| C-17 | 機能一覧CSV No.61がツール自動ダウンロード | E-05 | ○ |
| C-18 | AppsFormがツール管理画面として機能 | E-03 | △ |

## 4) 不足情報（Unknown / Missing）
- AppsFormからToolUpdate呼び出しの具体的なUI操作フロー
  - 候補：AppsForm.vbの詳細レビュー / ユーザーマニュアル / 画面仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認できる内容が多い
- 1: 中リスク - AppsFormの具体的な操作フローはコードからの推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] ToolUpdate.vbの処理フローが設計書と一致するか確認
- [ ] Package.vbのパッケージ定義がダウンロード対象と一致するか確認
- [ ] AppsFormからToolUpdateの呼び出し方法を確認
- [ ] エラーハンドリングの網羅性を確認
