---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：62-MediaInfo表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MediaInfo.NETの具体的な起動パラメータ**：GlobalCommands.vbの詳細確認が必要
  2. **パフォーマンス要件の数値**：実測値ではなく推定値
  3. **エラーハンドリングの詳細**：例外処理の具体的実装

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/MediaInfo.vb`
- E-02: `Source/General/Package.vb`（255-280行目）
- E-03: `Source/Forms/MainForm.vb`（4408行目付近）
- E-04: `Source/General/GlobalCommands.vb`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（63行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MediaInfo.dllはネイティブライブラリとして読み込み | E-01 (DllImport属性使用) | ○ |
| C-02 | Package.MediaInfoでDLL定義 | E-02 (255-262行目) | ○ |
| C-03 | Package.MediaInfoNETでGUIアプリ定義 | E-02 (264-271行目) | ○ |
| C-04 | Package.GetMediaInfoでPowerShellスクリプト定義 | E-02 (273-280行目) | ○ |
| C-05 | MediaInfo DLLの配置場所はSupport/MediaInfo.NET | E-02 (258行目: Location) | ○ |
| C-06 | メニューからMediaInfo表示を呼び出し可能 | E-03 | ○ |
| C-07 | MediaInfo Folder View機能も提供 | E-04 | ○ |
| C-08 | Get-MediaInfo.ps1によるPowerShell連携 | E-02, E-04 | ○ |
| C-09 | MediaAreaプロジェクトのライブラリを使用 | E-02 (WebURL: mediaarea.net) | ○ |
| C-10 | MediaInfo.NETはstax76が開発したGUIアプリ | E-02 (WebURL: github.com/stax76) | ○ |
| C-11 | 機能一覧CSV No.62がMediaInfo表示 | E-05 | ○ |
| C-12 | SupportsAutoUpdate = Falseで自動更新無効 | E-02 (259行目, 270行目) | ○ |
| C-13 | パフォーマンス要件（小規模1秒以内） | **根拠なし** | △ |
| C-14 | 読み取り専用機能で外部送信なし | E-01 (ローカル処理のみ) | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の実測データ
  - 候補：ベンチマークテスト / パフォーマンス計測ログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な情報表示機能であり、コードからの確認が容易
- 1: 中リスク - パフォーマンス要件は推定値のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] MediaInfo.vbのP/Invoke定義が正しいか確認
- [ ] Package.vbのパッケージ定義が実際のファイル配置と一致するか確認
- [ ] GlobalCommands.vbのMediaInfo表示コマンド実装を確認
- [ ] MediaInfo.NETの起動パラメータを確認
