---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-mkvinfo表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalCommands.vb`（572-581行目）
- E-02: `Source/General/Package.vb`（712-728行目）
- E-03: `Source/Forms/MainForm.vb`（4410行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（64行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShowMkvInfo()メソッドが存在する | E-01 (572-581行目) | ○ |
| C-02 | Command属性で「Shows an Open File dialog to open a file to be shown by the console tool mkvinfo.」と説明 | E-01 (572行目) | ○ |
| C-03 | OpenFileDialogでMKVファイルを選択 | E-01 (574-575行目) | ○ |
| C-04 | フィルタが「MKV\|*.mkv」 | E-01 (575行目) | ○ |
| C-05 | g.RunCodeInTerminal()でターミナル実行 | E-01 (578行目) | ○ |
| C-06 | Package.mkvinfo.Pathを使用 | E-01 (578行目) | ○ |
| C-07 | mkvinfoパッケージの定義が存在 | E-02 (712-728行目) | ○ |
| C-08 | mkvinfo.exeがFilename | E-02 (714行目) | ○ |
| C-09 | Siblingsにmkvextract、mkvmerge、MKVToolnix GUIが含まれる | E-02 (728行目) | ○ |
| C-10 | メニュー「Apps\|Media Info\|mkvinfo」で登録 | E-03 | ○ |
| C-11 | NameOf(g.DefaultCommands.ShowMkvInfo)でコマンド参照 | E-03 | ○ |
| C-12 | 機能一覧CSV No.63がmkvinfo表示 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalCommands.vbのShowMkvInfo()実装を確認
- [ ] Package.vbのmkvinfoパッケージ定義を確認
- [ ] メニュー登録が正しく機能するか動作確認
