---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：64-カスタムメニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **CustomMenuEditorの詳細実装**：UIの具体的な操作フロー

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/ApplicationSettings.vb`（34-38行目、307-325行目）
- E-02: `Source/UI/CustomMenuEditor.vb`
- E-03: `Source/Forms/MainForm.vb`
- E-04: `Source/Forms/CropForm.vb`
- E-05: `Source/Forms/PreviewForm.vb`
- E-06: `Source/UI/CodeEditor.vb`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`（65行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CustomMenuMainFormプロパティが存在 | E-01 (36行目) | ○ |
| C-02 | CustomMenuCropプロパティが存在 | E-01 (35行目) | ○ |
| C-03 | CustomMenuPreviewプロパティが存在 | E-01 (37行目) | ○ |
| C-04 | CustomMenuCodeEditorプロパティが存在 | E-01 (34行目) | ○ |
| C-05 | CustomMenuSizeプロパティが存在 | E-01 (38行目) | ○ |
| C-06 | Init()でバージョンチェックしてデフォルト復元 | E-01 (307-325行目) | ○ |
| C-07 | MainForm.GetDefaultMainMenuが存在 | E-03 | ○ |
| C-08 | CropForm.GetDefaultMenuCropが存在 | E-01 (308行目での参照) | ○ |
| C-09 | PreviewForm.GetDefaultMenuが存在 | E-01 (316行目での参照) | ○ |
| C-10 | CodeEditor.GetDefaultMenuが存在 | E-01 (319行目での参照) | ○ |
| C-11 | MainForm.GetDefaultMenuSizeが存在 | E-01 (323行目での参照) | ○ |
| C-12 | CustomMenuEditorでメニュー編集が可能 | E-02 | ○ |
| C-13 | 機能一覧CSV No.64がカスタムメニュー | E-07 | ○ |
| C-14 | バージョン番号でCheck()メソッドを呼び出し | E-01 | ○ |
| C-15 | CustomMenuEditorの具体的な操作フロー | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- CustomMenuEditor.vbの詳細な操作フロー（追加・削除・並び替えの具体的な実装）
  - 候補：CustomMenuEditor.vbの詳細レビュー / ユーザーマニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ApplicationSettingsでのプロパティ定義は明確
- 1: 中リスク - CustomMenuEditorの詳細実装は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ApplicationSettings.vbのカスタムメニュープロパティ定義を確認
- [ ] Init()でのバージョンチェックロジックを確認
- [ ] 各フォームのGetDefaultMenuメソッドを確認
- [ ] CustomMenuEditor.vbの詳細実装を確認
