---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-アシスタント機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/MainForm_Assistant.vb`（1-507行目）
- E-02: `Source/Forms/MainForm.vb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（67行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Assistant()関数がPartial Classで定義 | E-01 (5-8行目) | ○ |
| C-02 | refreshScriptパラメータでスクリプト同期制御 | E-01 (8行目, 16-23行目) | ○ |
| C-03 | SkipAssistantフラグでスキップ可能 | E-01 (9行目) | ○ |
| C-04 | ThemeRefreshでテーマ再適用 | E-01 (11-14行目) | ○ |
| C-05 | p.Script.Synchronize()でスクリプト同期 | E-01 (17行目) | ○ |
| C-06 | ProcessTip()でヒント処理判定 | E-01 (128, 137等多数) | ○ |
| C-07 | Block()で致命的エラーを返す | E-01 (138, 163等) | ○ |
| C-08 | Warn()で警告を返す | E-01 (129, 170等) | ○ |
| C-09 | ソースファイル必須チェック | E-01 (168-171行目) | ○ |
| C-10 | ソース/ターゲットパス同一チェック | E-01 (173-175行目) | ○ |
| C-11 | クロップリマインダー | E-01 (177-181行目) | ○ |
| C-12 | オーディオ設定チェック（複数項目） | E-01 (213-251行目) | ○ |
| C-13 | コンテナ互換性チェック | E-01 (207-211行目) | ○ |
| C-14 | アスペクト比エラーチェック | E-01 (265-273行目) | ○ |
| C-15 | Dolby Visionクロップ/リサイズ制約チェック | E-01 (342-388行目) | ○ |
| C-16 | x265 VBV設定必須チェック（Dolby Vision時） | E-01 (390-408行目) | ○ |
| C-17 | 全チェックOK時にgbAssistant.Text = "Add Job" | E-01 (491-493行目) | ○ |
| C-18 | 機能一覧CSV No.66がアシスタント機能 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] MainForm_Assistant.vbの全チェック項目を確認
- [ ] ProcessTip/Block/Warnの実装を確認
- [ ] 各チェックのビジネスルールが仕様と一致するか確認
- [ ] Dolby Vision関連チェックの条件分岐を確認
