---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-ログ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/LogBuilder.vb`
- E-02: `Source/Forms/LogForm.vb`
- E-03: `Source/General/ApplicationSettings.vb`（62-63行目、118行目）
- E-04: `Source/Forms/MainForm_ShowSettings.vb`（58-74行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（68行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LogBuilder.vbでログ構築 | E-01 | ○ |
| C-02 | LogForm.vbでログ表示 | E-02 | ○ |
| C-03 | LogFileNumプロパティ（デフォルト200） | E-03 (63行目) | ○ |
| C-04 | LogEventCommandプロパティ | E-03 (62行目) | ○ |
| C-05 | WriteDebugLogプロパティ | E-03 (118行目) | ○ |
| C-06 | 設定UIにLogsページが存在 | E-04 (59行目) | ○ |
| C-07 | LogFileNum設定項目 | E-04 (61-65行目) | ○ |
| C-08 | LogEventCommand設定項目 | E-04 (67-69行目) | ○ |
| C-09 | WriteDebugLog設定項目 | E-04 (71-73行目) | ○ |
| C-10 | ヘルプテキスト「Log files can be found at: Tools > Folders > Log Files」 | E-04 (63行目) | ○ |
| C-11 | 機能一覧CSV No.67がログ表示 | E-05 | ○ |
| C-12 | 設定画面でログ関連設定が可能 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] LogBuilder.vbのログ構築ロジックを確認
- [ ] LogForm.vbの表示実装を確認
- [ ] ログローテーション処理の実装を確認
- [ ] デバッグログの出力条件を確認
