---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-アプリケーション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/ApplicationSettings.vb`（9-122行目、136-376行目）
- E-02: `Source/Forms/MainForm_ShowSettings.vb`（1-570行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（69行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShowSettingsDialog()メソッドが存在 | E-02 (7行目) | ○ |
| C-02 | SimpleSettingsFormで設定ダイアログ生成 | E-02 (11行目) | ○ |
| C-03 | ui.Store = sでApplicationSettingsバインド | E-02 (13行目) | ○ |
| C-04 | Generalページが存在 | E-02 (17行目) | ○ |
| C-05 | Logsページが存在 | E-02 (59行目) | ○ |
| C-06 | Startupページが存在 | E-02 (77行目) | ○ |
| C-07 | Systemページが存在 | E-02 (223行目) | ○ |
| C-08 | User Interfaceページが存在 | E-02 (282行目) | ○ |
| C-09 | Frameserverページが存在 | E-02 (429行目) | ○ |
| C-10 | Danger Zoneページが存在 | E-02 (460行目) | ○ |
| C-11 | AutoSaveProjectプロパティ | E-01 (13行目) | ○ |
| C-12 | ParallelProcsNumプロパティ | E-01 (68行目) | ○ |
| C-13 | ProcessPriorityプロパティ | E-01 (76行目) | ○ |
| C-14 | ThemeNameプロパティ | E-01 (105行目) | ○ |
| C-15 | Init()でマイグレーション処理 | E-01 (136行目) | ○ |
| C-16 | 機能一覧CSV No.68がアプリケーション設定 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ApplicationSettings.vbの設定プロパティを確認
- [ ] MainForm_ShowSettings.vbの各ページ構築を確認
- [ ] Init()でのマイグレーションロジックを確認
- [ ] Danger Zone設定の警告表示を確認
