---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-eac3to Demux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - eac3toDemuxerクラス（182-242行目）
- E-02: `Source/General/Demux.vb` - eac3toDemuxer.Run（191-235行目）
- E-03: `Source/Forms/eac3toForm.vb` - eac3toFormクラス
- E-04: `Source/Forms/eac3toForm.vb` - GetArgs（967-1030行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.7定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eac3toDemuxerはDemuxerを継承 | E-01 | ○ |
| C-02 | InputExtensionsは{"m2ts"} | E-01 | ○ |
| C-03 | OutputExtensionsは{"h264", "mkv", "m2v"} | E-01 | ○ |
| C-04 | デフォルトでActive=False | E-01 | ○ |
| C-05 | NoDialogs/BatchMode時はスキップ | E-02 | ○ |
| C-06 | eac3toFormでストリーム選択 | E-02, E-03 | ○ |
| C-07 | M2TSFileにSourceFile設定 | E-02 | ○ |
| C-08 | teTempDirにTempDir設定 | E-02 | ○ |
| C-09 | GetArgs()で引数構築 | E-02, E-04 | ○ |
| C-10 | PreferredAudioに言語追加 | E-02 | ○ |
| C-11 | ビデオ出力時にSourceFile更新 | E-02 | ○ |
| C-12 | ビデオ出力時にTempDir更新 | E-02 | ○ |
| C-13 | HasConfigDialogはTrue | E-01 | ○ |
| C-14 | Nameは"eac3to: Demux" | E-01 | ○ |
| C-15 | 例外発生時にAbortException | E-02 | ○ |
| C-16 | キャンセル時にAbortException | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローはシンプルで明確
- 0: 低リスク - eac3toFormとの連携は直接的

## 6) レビュアーチェックリスト（最小）
- [ ] eac3toDemuxer.Run()の処理フローを確認
- [ ] NoDialogs/BatchModeチェックの動作を確認
- [ ] PreferredAudio更新ロジックを確認
- [ ] SourceFile/TempDir更新条件を確認
