---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-設定リセット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalCommands.vb`（917-937行目）
- E-02: `Source/General/ApplicationSettings.vb`（114行目、132-134行目）
- E-03: `Source/Forms/MainForm.vb`（4390行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（71行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ResetSettings()メソッドが存在 | E-01 (918行目) | ○ |
| C-02 | Command属性で「Shows a dialog allowing to reset specific settings.」と説明 | E-01 (917行目) | ○ |
| C-03 | SelectionBox<String>で選択ダイアログ生成 | E-01 (919行目) | ○ |
| C-04 | タイトルが「Reset Settings」 | E-01 (921行目) | ○ |
| C-05 | 一時ApplicationSettingsを生成してInit()呼び出し | E-01 (924-925行目) | ○ |
| C-06 | appSettings.Versions.Keysをイテレート | E-01 (927-929行目) | ○ |
| C-07 | sb.Items.Sort()でソート | E-01 (931行目) | ○ |
| C-08 | OK時にs.Versions(sb.SelectedValue) = -1 | E-01 (934行目) | ○ |
| C-09 | MsgInfo(「Will be reseted on next startup.」, sb.SelectedValue) | E-01 (935行目) | ○ |
| C-10 | メニュー「Tools\|Advanced\|Reset Settings...」で登録 | E-03 | ○ |
| C-11 | Versionsプロパティが存在 | E-02 (114行目) | ○ |
| C-12 | 機能一覧CSV No.70が設定リセット | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalCommands.vbのResetSettings()実装を確認
- [ ] ApplicationSettings.vbのVersions管理ロジックを確認
- [ ] Check()メソッドによるバージョン比較を確認
- [ ] メニュー登録が正しく機能するか動作確認
