---
generated_at: 2026-01-21 18:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：71-アップデート確認.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **UpdateFormとStaxRipUpdateの関係性**：両クラスの使い分けについて明確なドキュメントが不足
  2. **バージョン比較ロジックの詳細**：UpdateForm.vb内のバージョン比較がハードコードされている
  3. **エラーハンドリングの詳細**：サイレント失敗の妥当性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/StaxRipUpdate.vb` - メインのアップデート確認ロジック
- E-02: `Source/Forms/UpdateForm.vb` - ダウンロード進捗表示UI
- E-03: `Source/Forms/UpdateForm.Designer.vb` - UpdateFormのUI定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHubリポジトリに問い合わせて新バージョンを確認する | E-01 (59-80行目) | ○ |
| C-02 | HttpClientを使用した非同期通信を行う | E-01 (11行目, 64行目) | ○ |
| C-03 | 正規表現でバージョンタグを解析する | E-01 (67行目) | ○ |
| C-04 | チェック間隔は1〜12時間で動的に調整される | E-01 (46-51行目) | ○ |
| C-05 | インストールからの経過時間に基づいて間隔を決定 | E-01 (46-51行目) | ○ |
| C-06 | TaskDialogでユーザーに選択肢を提示する | E-01 (88-131行目) | ○ |
| C-07 | CHANGELOGから変更点を最大30項目表示する | E-01 (107行目) | ○ |
| C-08 | スキップしたバージョンは次回通知しない | E-01 (85-86行目, 129行目) | ○ |
| C-09 | force引数で強制チェック可能 | E-01 (41-42行目, 56行目) | ○ |
| C-10 | 開発環境では質問ダイアログを表示しない | E-01 (21行目) | ○ |
| C-11 | UpdateFormでProgressBarを使用して進捗表示 | E-02 (38-43行目), E-03 (26-35行目) | ○ |
| C-12 | WebClientでファイルをダウンロードする（UpdateForm） | E-02 (4行目, 20行目) | ○ |
| C-13 | ダウンロード完了後にファイルを開く | E-02 (22行目) | ○ |
| C-14 | HTTPSのみを使用する | E-01 (59-60行目, 76-77行目) | ○ |
| C-15 | 画面No.23がUpdateForm | E-05 | ○ |
| C-16 | 機能No.71がアップデート確認 | E-04 | ○ |
| C-17 | SetFirstRunOnCurrentVersionでバージョン初回実行を記録 | E-01 (13-18行目) | ○ |
| C-18 | s.CheckForUpdates設定で自動チェックを制御 | E-01 (42行目, 36行目) | ○ |
| C-19 | s.CheckForUpdatesLastRequestで最終チェック時刻を記録 | E-01 (54行目, 139行目) | ○ |
| C-20 | リリースページURLを構築してブラウザで開く | E-01 (77行目, 127行目) | ○ |
| C-21 | ダウンロードファイル名にバージョン番号を含む | E-01 (75行目) | ○ |
| C-22 | 例外発生時はサイレントに処理を終了する | E-01 (140行目) | ○ |
| C-23 | UpdateFormの存在意義（StaxRipUpdateとの使い分け） | **根拠なし** | △ |
| C-24 | ダウンロード失敗時はファイルを削除する | E-02 (28行目) | ○ |
| C-25 | バージョン比較は文字列ではなくVersion型で行う | E-01 (71行目, 73行目, 83行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- UpdateForm.vbとStaxRipUpdate.vbの両方にアップデート処理が存在するが、どちらがどのような場合に使用されるかの明確な仕様が見当たらない
  - 候補：README / 開発者ドキュメント / コードコメント

## 5) リスクフラグ（レビュー観点）
- 0: UpdateFormのハードコードされたバージョン番号（15行目）は古い可能性あり
- 1: ネットワークエラー時のユーザー通知がない（サイレント失敗）
- 0: CHANGELOG解析の正規表現が複雑で、フォーマット変更に弱い可能性

## 6) レビュアーチェックリスト（最小）
- [ ] StaxRipUpdate.vbのCheckForUpdateAsyncメソッドのフローが設計書と一致しているか
- [ ] UpdateForm.vbが実際に使用されているか、または非推奨かを確認
- [ ] チェック間隔の計算ロジック（BR-71-01）がコードと一致しているか
- [ ] TaskDialogの選択肢（Open/Dismiss/Cancel）が実装と一致しているか
- [ ] HTTPSのみ使用されていることを確認
