---
generated_at: 2026-01-21 18:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-ヘルプ表示.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべての主張に根拠が確認できた
- 確認推奨項目
  1. CSSスタイルのダークテーマ対応：General.vb内のハードコードされた色設定の確認
  2. 一時ファイル削除タイミング：Disposeイベントでの確実な削除確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/HelpForm.vb` - ヘルプ表示フォーム
- E-02: `Source/General/General.vb` - HelpDocumentクラス（439-719行目）
- E-03: `Source/UI/TipProvider.vb` - コンテキストヘルプ管理
- E-04: `Source/General/GlobalClass.vb` - g.ShowHelpメソッド（1009-1015行目）
- E-05: `Source/UI/UI Help.vb` - WebBrowserHelperクラス
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLベースのビューアでヘルプを表示する | E-01 (18行目: WebBrowser) | ○ |
| C-02 | 一時ファイルをTempフォルダに作成する | E-01 (58行目) | ○ |
| C-03 | 一時ファイルはMainForm.Disposed時に削除される | E-01 (59行目) | ○ |
| C-04 | GUIDを使用して一時ファイル名を生成する | E-01 (58行目) | ○ |
| C-05 | ShowDialogでヘルプ表示のエントリーポイント | E-01 (70-84行目) | ○ |
| C-06 | 外部URLはShellExecuteで開く | E-01 (108-113行目) | ○ |
| C-07 | http/httpsで始まるURLはブラウザに委譲 | E-01 (109行目) | ○ |
| C-08 | XmlTextWriterでHTML生成 | E-02 (495行目) | ○ |
| C-09 | CSSスタイルはダークテーマ（#323232背景） | E-02 (463行目) | ○ |
| C-10 | MediaWiki形式リンクをHTMLのaタグに変換 | E-02 (590-597行目) | ○ |
| C-11 | '''テキスト'''をbタグに変換 | E-02 (599-606行目) | ○ |
| C-12 | ヘルプ項目はソートして表示 | E-02 (631行目) | ○ |
| C-13 | WriteTipsでH3+P形式出力 | E-02 (634-636行目) | ○ |
| C-14 | WriteTableでテーブル形式出力 | E-02 (686-719行目) | ○ |
| C-15 | ConvertCharsで特殊文字エスケープ | E-02 (553-569行目) | ○ |
| C-16 | TipProviderで右クリック時ヘルプ表示 | E-03 (99-105行目) | ○ |
| C-17 | SetTipTextでヘルプテキスト設定 | E-03 (50-53行目) | ○ |
| C-18 | TipProviderからg.ShowHelp呼び出し | E-03 (109行目) | ○ |
| C-19 | g.ShowHelpでタイトル末尾の.と:を削除 | E-04 (1011行目) | ○ |
| C-20 | g.ShowHelpはMsgInfoを呼び出す | E-04 (1014行目) | ○ |
| C-21 | WebBrowserHelp.ResetTextSizeでテキストサイズリセット | E-01 (91行目), E-05 (102-106行目) | ○ |
| C-22 | 機能No.72がヘルプ表示、画面No.10がHelpForm | E-06, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張について根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: CSSスタイルがGeneral.vb内にハードコードされており、テーマ変更時に影響を受ける可能性
- 0: 一時ファイル削除がMainForm.Disposedイベントに依存しているため、異常終了時は残存する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] HelpForm.vbのWebBrowserコントロールが正しく初期化されているか
- [ ] 一時ファイルが確実に削除されるか（Disposedイベントハンドラの確認）
- [ ] ConvertMarkupメソッドの正規表現が意図通り動作するか
- [ ] 外部URLの判定ロジック（http/https開始）が正しいか
- [ ] WriteTips/WriteTableの出力形式が設計書と一致しているか
