---
generated_at: 2026-01-21 18:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-コードエディタ.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべての主張に根拠が確認できた
- 確認推奨項目
  1. FilterTableの複雑なUI構成：TableLayoutPanel内のネストが深い
  2. JoinFiltersの保護カテゴリ判定：ハードコードされた文字列リスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/CodeEditor.vb` - コードエディタ本体
- E-02: `Source/Forms/CodeEditor.Designer.vb` - UIデザイナー定義
- E-03: `Source/Forms/CodeForm.vb` - コードビューア
- E-04: `Source/Forms/CodeForm.Designer.vb` - CodeFormのUIデザイナー定義
- E-05: `Source/Video/VideoScript.vb` - VideoFilter、ScriptEngine定義
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AviSynth/VapourSynthスクリプトを編集する | E-01 (23行目: Engine), E-05 (1230-1233行目) | ○ |
| C-02 | FilterTableでフィルタを表示する | E-01 (36-37行目, 526-842行目) | ○ |
| C-03 | フィルタの追加・挿入・置換機能 | E-01 (359-369行目, 766-841行目) | ○ |
| C-04 | フィルタの削除機能 | E-01 (115-127行目) | ○ |
| C-05 | フィルタの並べ替え（上下移動） | E-01 (129-151行目) | ○ |
| C-06 | フィルタの有効/無効切り替え | E-01 (601-604行目: cbActive.CheckedChanged) | ○ |
| C-07 | コードプレビュー（マクロ展開後） | E-01 (153-160行目) | ○ |
| C-08 | ビデオプレビューとの連携 | E-01 (223-241行目) | ○ |
| C-09 | フィルタの結合機能 | E-01 (244-289行目) | ○ |
| C-10 | ScriptEngineはAviSynthとVapourSynthの2値 | E-05 (1230-1233行目) | ○ |
| C-11 | CommandManagerでコマンド管理 | E-01 (13行目, 26-27行目) | ○ |
| C-12 | CustomMenuでカスタムメニュー構築 | E-01 (29-31行目, 371-403行目) | ○ |
| C-13 | 保護カテゴリ（source等）は結合対象外 | E-01 (245行目, 261行目, 277行目) | ○ |
| C-14 | Macro.ExpandGUIでマクロ展開 | E-01 (767行目, 791行目, 819行目) | ○ |
| C-15 | FontManager.GetCodeFont()で等幅フォント | E-01 (599行目), E-03 (17行目) | ○ |
| C-16 | DialogBaseを継承 | E-02 (4行目) | ○ |
| C-17 | OK/Cancelボタンでダイアログ操作 | E-02 (57-70行目) | ○ |
| C-18 | MainFlowLayoutPanelにFilterTable配置 | E-01 (36行目), E-02 (73-82行目) | ○ |
| C-19 | ApplyFiltersでPreviewScript更新 | E-01 (107-113行目) | ○ |
| C-20 | GetFiltersでFilterTableからフィルタ取得 | E-01 (419-432行目) | ○ |
| C-21 | CreateTempScriptでエラーチェック | E-01 (439-447行目) | ○ |
| C-22 | mpv.net再生機能 | E-01 (213-216行目) | ○ |
| C-23 | MPC-HC再生機能 | E-01 (218-221行目) | ○ |
| C-24 | ThemeManager.CurrentThemeChangedに対応 | E-01 (46行目, 55-57行目) | ○ |
| C-25 | CodeFormは読み取り専用 | E-03 (15行目: rtb.ReadOnly = True) | ○ |
| C-26 | CodeFormでFindによる検索 | E-03 (57-86行目) | ○ |
| C-27 | 機能No.73がコードエディタ | E-06 | ○ |
| C-28 | 画面No.24がCodeForm | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張について根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 保護カテゴリ判定がハードコード（"source", "crop", "cutting", "resize", "rotation"）
- 0: FilterTableのUI構成が複雑（TableLayoutPanel内にネスト）
- 0: テキストサイズ計算のUIScaleFactor依存

## 6) レビュアーチェックリスト（最小）
- [ ] FilterTableの生成と配置が正しく行われているか
- [ ] ApplyFiltersがPreviewScriptに正しく反映されているか
- [ ] JoinFiltersの保護カテゴリ判定が意図通り動作するか
- [ ] CreateTempScriptのエラーチェックが適切か
- [ ] テーマ変更時にUIが正しく更新されるか
- [ ] CodeFormの検索機能（Find）が動作するか
