---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-DGIndex/D2V Witch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - Demuxer基底クラス（7-108行目）
- E-02: `Source/General/Demux.vb` - CommandLineDemuxerクラス（110-179行目）
- E-03: `Source/General/Demux.vb` - GetDefaults内DGIndex定義（85-93行目）
- E-04: `Source/General/Demux.vb` - GetDefaults内D2V Witch定義（94-103行目）
- E-05: `Source/General/Demux.vb` - CommandLineDemuxer.Run（129-170行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.8定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DGIndex/D2V WitchはCommandLineDemuxerとして定義 | E-02, E-03, E-04 | ○ |
| C-02 | DGIndexのInputExtensionsにmpg/mpeg/vob/m2ts/m2v/mts/m2t | E-03 | ○ |
| C-03 | OutputExtensionsは{"d2v"} | E-03, E-04 | ○ |
| C-04 | InputFormatsは{"mpeg2"} | E-03, E-04 | ○ |
| C-05 | DGIndexのCommandは%app_path:DGIndex% | E-03 | ○ |
| C-06 | DGIndexのArgumentsに-ia 2 -fo 0等含む | E-03 | ○ |
| C-07 | D2V WitchはデフォルトでActive=False | E-04 | ○ |
| C-08 | D2V Witchはcmd.exe経由で実行 | E-04 | ○ |
| C-09 | D2V Witchに--audio-ids allオプション | E-04 | ○ |
| C-10 | SourceFiltersにMPEG2Source/D2VSource/d2v.Source | E-03, E-04 | ○ |
| C-11 | Run()でMacro.Expand実行 | E-05 | ○ |
| C-12 | DGIndex判定時にIntegerPercentOutput=True | E-05 | ○ |
| C-13 | D2V Witch判定時にSkipString="%" | E-05 | ○ |
| C-14 | DGIndexでログファイルリネーム処理 | E-05 | ○ |
| C-15 | DGIndexでM2Vファイルリネーム処理 | E-05 | ○ |
| C-16 | MKVソース時にタイムスタンプ抽出 | E-05 | ○ |
| C-17 | Nameは"DGIndex: Demux & Index MPEG-2" | E-03 | ○ |
| C-18 | D2V Witchは"D2V Witch: Demux & Index MPEG-2" | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定値はソースコードで直接確認可能
- 0: 低リスク - コマンドライン引数は明示的に定義

## 6) レビュアーチェックリスト（最小）
- [ ] GetDefaults()のDGIndex/D2V Witch定義を確認
- [ ] CommandLineDemuxer.Run()の処理フローを確認
- [ ] DGIndex固有のファイルリネーム処理を確認
- [ ] タイムスタンプ抽出条件を確認
