---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-チャプター抽出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Demux.vb` - mkvDemuxer.Runチャプター処理（756-780行目）
- E-02: `Source/General/Demux.vb` - MP4BoxDemuxer.Runチャプター処理（577-589行目）
- E-03: `Source/Forms/eac3toForm.vb` - GetArgsチャプター処理（1022-1026行目）
- E-04: `Source/Forms/eac3toForm.vb` - M2TSStream.IsChapters判定
- E-05: `Source/Forms/StreamDemuxForm.vb` - cbDemuxChaptersチェックボックス
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.9定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MKVチャプターはmkvextract chaptersで抽出 | E-01 | ○ |
| C-02 | stdout.Contains("Chapters: ")で存在確認 | E-01 | ○ |
| C-03 | XML形式とOGG形式の両方を出力（MKV） | E-01 | ○ |
| C-04 | --simpleオプションでOGG形式出力 | E-01 | ○ |
| C-05 | MP4チャプターはMP4Box -dump-chap-oggで抽出 | E-02 | ○ |
| C-06 | Chapters_Pos_End - Chapters_Pos_Begin > 0で存在確認 | E-02 | ○ |
| C-07 | eac3toでIsChapters判定 | E-04 | ○ |
| C-08 | cbChapters.Checkedでチャプター抽出制御 | E-03 | ○ |
| C-09 | 出力ファイル名は_chapters.xml/_chapters.txt | E-01, E-02, E-03 | ○ |
| C-10 | demuxChaptersでチャプター抽出を制御 | E-05 | ○ |
| C-11 | "demux Blu-ray chapters"設定として保存 | E-03 | ○ |
| C-12 | mkvextract終了コード0,1,2を許容 | E-01 | ○ |
| C-13 | MediaInfo.GetMenuでチャプター位置取得 | E-02 | ○ |
| C-14 | p.DemuxChaptersプロパティが存在 | E-05 | ○ |
| C-15 | チャプター抽出はメタデータのみで瞬時 | E-01, E-02 | ○ |
| C-16 | 各Demuxerでチャプター抽出処理を実装 | E-01, E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - チャプター抽出はシンプルなメタデータ操作
- 0: 低リスク - 各Demuxerの処理は独立して明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] mkvDemuxer.Runのチャプター処理を確認
- [ ] MP4BoxDemuxer.Runのチャプター処理を確認
- [ ] eac3toForm.GetArgsのチャプター処理を確認
- [ ] チャプター存在判定ロジックを確認
