---
generated_at: 2026-01-21 12:00:00
metrics:
  claims_total: 29
  claims_with_evidence: 29
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：29 / 29、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/MainForm.vb` - メインフォームのソースコード
- E-02: `Source/Forms/PreviewForm.vb` - プレビューフォームのソースコード
- E-03: `Source/Forms/ProcessingForm.vb` - 処理フォームのソースコード
- E-04: `Source/Forms/JobsForm.vb` - ジョブフォームのソースコード
- E-05: `Source/Forms/CropForm.vb` - クロップフォームのソースコード
- E-06: `Source/Forms/AudioForm.vb` - オーディオフォームのソースコード
- E-07: `Source/Forms/AppsForm.vb` - アプリ設定フォームのソースコード
- E-08: `Source/Forms/ProfilesForm.vb` - プロファイルフォームのソースコード
- E-09: `Source/Forms/MacrosForm.vb` - マクロフォームのソースコード
- E-10: `Source/Forms/HelpForm.vb` - ヘルプフォームのソースコード
- E-11: `Source/Forms/LogForm.vb` - ログフォームのソースコード
- E-12: `Source/Forms/VideoComparisonForm.vb` - 動画比較フォームのソースコード
- E-13: `Source/Forms/SimpleSettingsForm.vb` - 汎用設定フォームのソースコード
- E-14: `Source/Forms/MuxerForm.vb` - マルチプレクサフォームのソースコード
- E-15: `Source/Forms/SourceFilesForm.vb` - ソースファイルフォームのソースコード
- E-16: `Source/Forms/StreamDemuxForm.vb` - ストリームデマックスフォームのソースコード
- E-17: `Source/Forms/eac3toForm.vb` - eac3toフォームのソースコード
- E-18: `Source/Forms/CommandLineForm.vb` - コマンドラインフォームのソースコード
- E-19: `Source/Forms/CommandLineVideoEncoderForm.vb` - 動画エンコーダフォームのソースコード
- E-20: `Source/Forms/CommandLineAudioEncoderForm.vb` - 音声エンコーダフォームのソースコード
- E-21: `Source/Forms/CommandLineDemuxForm.vb` - デマックスフォームのソースコード
- E-22: `Source/Forms/DownloadForm.vb` - ダウンロードフォームのソースコード
- E-23: `Source/Forms/UpdateForm.vb` - アップデートフォームのソースコード
- E-24: `Source/Forms/CodeForm.vb` - コードフォームのソースコード
- E-25: `Source/Forms/TestForm.vb` - テストフォームのソースコード
- E-26: `Source/UI/DataForm.vb` - データフォームのソースコード
- E-27: `Source/UI/StringEditorForm.vb` - 文字列エディタフォームのソースコード
- E-28: `Source/UI/MenuTemplateForm.vb` - メニューテンプレートフォームのソースコード
- E-29: `Source/UI/TaskDialogBaseForm.vb` - タスクダイアログ基底フォームのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MainFormはアプリケーションのメイン画面である | E-01 | ○ |
| C-02 | PreviewFormは動画のプレビュー表示画面である | E-02 | ○ |
| C-03 | ProcessingFormはエンコード処理中の進捗表示画面である | E-03 | ○ |
| C-04 | JobsFormはエンコードジョブの一覧表示・管理画面である | E-04 | ○ |
| C-05 | CropFormは動画のクロップ設定画面である | E-05 | ○ |
| C-06 | AudioFormはオーディオストリームの設定画面である | E-06 | ○ |
| C-07 | AppsFormは外部ツールの設定画面である | E-07 | ○ |
| C-08 | ProfilesFormはプロファイルの管理画面である | E-08 | ○ |
| C-09 | MacrosFormは使用可能なマクロの一覧表示画面である | E-09 | ○ |
| C-10 | HelpFormはヘルプ情報の表示画面である | E-10 | ○ |
| C-11 | LogFormは処理ログの表示画面である | E-11 | ○ |
| C-12 | VideoComparisonFormは複数の動画ファイルを比較する画面である | E-12 | ○ |
| C-13 | SimpleSettingsFormは汎用的な設定ダイアログである | E-13 | ○ |
| C-14 | MuxerFormはマルチプレクサの設定画面である | E-14 | ○ |
| C-15 | SourceFilesFormは複数ソースファイルの管理画面である | E-15 | ○ |
| C-16 | StreamDemuxFormはストリームのデマルチプレクス設定画面である | E-16 | ○ |
| C-17 | eac3toFormはeac3toツールを使用したデマックス設定画面である | E-17 | ○ |
| C-18 | CommandLineFormはコマンドラインパラメータの設定画面である | E-18 | ○ |
| C-19 | CommandLineVideoEncoderFormは動画エンコーダのコマンドライン設定画面である | E-19 | ○ |
| C-20 | CommandLineAudioEncoderFormは音声エンコーダのコマンドライン設定画面である | E-20 | ○ |
| C-21 | CommandLineDemuxFormはコマンドラインベースのデマックス設定画面である | E-21 | ○ |
| C-22 | DownloadFormはファイルダウンロードの進捗表示画面である | E-22 | ○ |
| C-23 | UpdateFormはアプリケーション更新画面である | E-23 | ○ |
| C-24 | CodeFormはスクリプトコードの編集画面である | E-24 | ○ |
| C-25 | TestFormは開発用テスト画面である | E-25 | ○ |
| C-26 | DataFormは汎用データ表示ダイアログである | E-26 | ○ |
| C-27 | StringEditorFormは複数行テキストの編集画面である | E-27 | ○ |
| C-28 | MenuTemplateFormはメニューテンプレートの選択画面である | E-28 | ○ |
| C-29 | TaskDialogBaseFormはタスクダイアログ風UIを提供する基底フォームである | E-29 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての画面について対応するソースファイルが存在し、クラス定義から画面の役割を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている
- 画面遷移図については、コード内のメソッド呼び出しパターンから推測した部分があり、実際のUI操作フローと異なる可能性がある（リスク: 1）

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面ファイルが実際に存在することを確認
- [ ] 画面の説明がソースコード内のコメントや実装と一致しているか確認
- [ ] 画面遷移図が実際のアプリケーション動作と一致しているか確認
- [ ] カテゴリ分類が適切かどうか確認
- [ ] 備考欄の情報が正確かどうか確認
