# 画面遷移図

## 概要

StaxRipは動画エンコードを目的としたWindows Formsアプリケーションです。MainFormを中心に、各種設定・処理画面への遷移が行われます。

## 画面遷移図（Mermaid形式）

```mermaid
flowchart TB
    subgraph メイン
        MainForm[MainForm<br/>メイン画面]
    end

    subgraph プレビュー・編集
        PreviewForm[PreviewForm<br/>プレビュー]
        CropForm[CropForm<br/>クロップ設定]
        VideoComparisonForm[VideoComparisonForm<br/>動画比較]
        CodeForm[CodeForm<br/>コード編集]
    end

    subgraph 処理・ジョブ
        ProcessingForm[ProcessingForm<br/>処理中画面]
        JobsForm[JobsForm<br/>ジョブ管理]
    end

    subgraph オーディオ・マルチプレクサ
        AudioForm[AudioForm<br/>オーディオ設定]
        MuxerForm[MuxerForm<br/>マルチプレクサ]
    end

    subgraph デマックス
        StreamDemuxForm[StreamDemuxForm<br/>ストリームデマックス]
        eac3toForm[eac3toForm<br/>eac3toデマックス]
        CommandLineDemuxForm[CommandLineDemuxForm<br/>コマンドラインデマックス]
    end

    subgraph エンコーダ設定
        CommandLineForm[CommandLineForm<br/>コマンドライン設定]
        CommandLineVideoEncoderForm[CommandLineVideoEncoderForm<br/>動画エンコーダ設定]
        CommandLineAudioEncoderForm[CommandLineAudioEncoderForm<br/>音声エンコーダ設定]
    end

    subgraph システム設定
        AppsForm[AppsForm<br/>アプリケーション設定]
        ProfilesForm[ProfilesForm<br/>プロファイル管理]
        SimpleSettingsForm[SimpleSettingsForm<br/>汎用設定]
    end

    subgraph ヘルプ・情報
        HelpForm[HelpForm<br/>ヘルプ]
        LogForm[LogForm<br/>ログ表示]
        MacrosForm[MacrosForm<br/>マクロ一覧]
    end

    subgraph ソース管理
        SourceFilesForm[SourceFilesForm<br/>ソースファイル]
    end

    subgraph ユーティリティ
        DownloadForm[DownloadForm<br/>ダウンロード]
        UpdateForm[UpdateForm<br/>アップデート]
    end

    %% メイン画面からの遷移
    MainForm --> PreviewForm
    MainForm --> CropForm
    MainForm --> ProcessingForm
    MainForm --> JobsForm
    MainForm --> AudioForm
    MainForm --> MuxerForm
    MainForm --> AppsForm
    MainForm --> ProfilesForm
    MainForm --> HelpForm
    MainForm --> LogForm
    MainForm --> MacrosForm
    MainForm --> VideoComparisonForm
    MainForm --> CodeForm
    MainForm --> SourceFilesForm
    MainForm --> SimpleSettingsForm
    MainForm --> UpdateForm

    %% プレビューからの遷移
    PreviewForm --> CropForm

    %% 処理画面からの遷移
    ProcessingForm --> JobsForm
    ProcessingForm --> LogForm
    ProcessingForm --> HelpForm

    %% ジョブ管理からの遷移
    JobsForm --> ProcessingForm

    %% マルチプレクサからの遷移
    MuxerForm --> ProfilesForm
    MuxerForm --> HelpForm

    %% デマックス関連
    MainForm --> StreamDemuxForm
    MainForm --> eac3toForm
    MainForm --> CommandLineDemuxForm

    %% コマンドライン設定関連
    CommandLineForm --> HelpForm
    CommandLineVideoEncoderForm --> HelpForm
    CommandLineAudioEncoderForm --> HelpForm
    MainForm --> CommandLineForm
    MainForm --> CommandLineVideoEncoderForm
    MainForm --> CommandLineAudioEncoderForm

    %% オーディオからの遷移
    AudioForm --> ProfilesForm
    AudioForm --> CommandLineAudioEncoderForm

    %% ダウンロード関連
    AppsForm --> DownloadForm
    UpdateForm --> DownloadForm

    %% プロファイル管理からの遷移
    ProfilesForm --> HelpForm
```

## 画面遷移の説明

### 1. メイン画面（MainForm）からの遷移

| 遷移先 | 説明 | トリガー |
|--------|------|----------|
| PreviewForm | 動画プレビュー表示 | プレビューボタン、メニュー |
| CropForm | クロップ設定 | クロップボタン、メニュー |
| ProcessingForm | エンコード処理開始 | エンコード開始ボタン |
| JobsForm | ジョブ一覧表示 | F6キー、メニュー |
| AudioForm | オーディオ設定 | オーディオ設定ボタン |
| MuxerForm | マルチプレクサ設定 | コンテナ設定ボタン |
| AppsForm | 外部ツール設定 | メニュー「Tools > Settings」 |
| ProfilesForm | プロファイル管理 | 各種プロファイルメニュー |
| HelpForm | ヘルプ表示 | F1キー |
| LogForm | ログ表示 | メニュー「Tools > Log」 |
| MacrosForm | マクロ一覧 | マクロボタン |
| VideoComparisonForm | 動画比較 | メニュー「Tools > Video Comparison」 |
| CodeForm | スクリプト編集 | フィルタースクリプト編集時 |
| SourceFilesForm | ソースファイル管理 | 複数ソース使用時 |
| SimpleSettingsForm | 各種詳細設定 | 設定ダイアログ表示時 |

### 2. 処理画面（ProcessingForm）からの遷移

| 遷移先 | 説明 | トリガー |
|--------|------|----------|
| JobsForm | ジョブ一覧表示 | F6キー、Jobsボタン |
| LogForm | ログ表示 | F8キー、Logボタン |
| HelpForm | ヘルプ表示 | F1キー |

### 3. 設定画面間の遷移

- **AudioForm** から **ProfilesForm** へ：オーディオプロファイルの管理
- **MuxerForm** から **ProfilesForm** へ：マルチプレクサプロファイルの管理
- **CommandLineForm** から **HelpForm** へ：オプションのヘルプ表示

### 4. モーダル/モードレスダイアログ

| 画面 | タイプ | 説明 |
|------|--------|------|
| ProcessingForm | モードレス | エンコード中も他の操作が可能 |
| PreviewForm | モードレス | プレビュー表示しながら設定変更可能 |
| CropForm | モーダル | 設定完了まで他の操作をブロック |
| ProfilesForm | モーダル | プロファイル選択完了まで待機 |
| SimpleSettingsForm | モーダル | 設定完了まで他の操作をブロック |

## 備考

- 本画面遷移図はソースコード解析に基づいて作成
- 実際のUI操作によっては追加の遷移パスが存在する可能性あり
- コンテキストメニューからの遷移は省略
