---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **AudioForm関連マッピング**：AudioForm.vbファイルが見つからず、機能一覧からの推測
  2. **ProfilesForm関連マッピング**：ソースファイル未確認
  3. **eac3toForm関連マッピング**：ソースファイル詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面ID、画面名、対応するFormファイル
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能ID、機能名、機能カテゴリ
- E-03: `Source/Forms/MainForm.vb` - メインフォームのUI定義とイベントハンドラ
- E-04: `Source/Forms/PreviewForm.vb` - プレビューフォームのUI定義とカット機能実装
- E-05: `Source/Forms/ProcessingForm.vb` - エンコード処理フォームのUI定義
- E-06: `Source/Forms/JobsForm.vb` - ジョブ管理フォームのUI定義とジョブ操作
- E-07: `Source/Forms/CropForm.vb` - クロップフォームのUI定義とクロップ操作
- E-08: `Source/Forms/AppsForm.vb` - アプリケーション管理フォームのUI定義
- E-09: `Source/Forms/MuxerForm.vb` - マルチプレクサフォームのUI定義と字幕/オーディオ管理
- E-10: `Source/Forms/StreamDemuxForm.vb` - ストリーム分離フォームのUI定義
- E-11: `Source/Forms/VideoComparisonForm.vb` - ビデオ比較フォームのUI定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MainForm - ソースファイル読み込み機能 | E-01, E-02, E-03 | ○ |
| C-02 | MainForm - 複数ファイル読み込み機能 | E-02, E-03 | ○ |
| C-03 | MainForm - x265エンコード機能 | E-02, E-03 | ○ |
| C-04 | MainForm - x264エンコード機能 | E-02, E-03 | ○ |
| C-05 | MainForm - NVEncエンコード機能 | E-02, E-03 | ○ |
| C-06 | MainForm - QSVEncエンコード機能 | E-02, E-03 | ○ |
| C-07 | MainForm - VCEEncエンコード機能 | E-02, E-03 | ○ |
| C-08 | MainForm - AV1エンコード機能 | E-02, E-03 | ○ |
| C-09 | MainForm - AviSynth+連携機能 | E-02, E-03 | ○ |
| C-10 | MainForm - VapourSynth連携機能 | E-02, E-03 | ○ |
| C-11 | MainForm - クロップ機能呼び出し | E-02, E-03 | ○ |
| C-12 | MainForm - リサイズ機能 | E-02, E-03 | ○ |
| C-13 | MainForm - テンプレート機能 | E-02 | ○ |
| C-14 | MainForm - プロジェクト保存/読込 | E-02 | ○ |
| C-15 | MainForm - ジョブキュー遷移 | E-02, E-03 | ○ |
| C-16 | MainForm - アシスタント機能 | E-02, E-03 | ○ |
| C-17 | MainForm - アプリケーション設定遷移 | E-02, E-03 | ○ |
| C-18 | PreviewForm - ビデオプレビュー機能 | E-01, E-02, E-04 | ○ |
| C-19 | PreviewForm - フレームカット機能 | E-02, E-04 | ○ |
| C-20 | PreviewForm - 範囲指定カット機能 | E-02, E-04 | ○ |
| C-21 | PreviewForm - AviSynth連携 | E-02, E-04 | ○ |
| C-22 | PreviewForm - VapourSynth連携 | E-02, E-04 | ○ |
| C-23 | ProcessingForm - ジョブ実行機能 | E-01, E-02, E-05 | ○ |
| C-24 | ProcessingForm - ログ表示機能 | E-02, E-05 | ○ |
| C-25 | ProcessingForm - ジョブキュー遷移 | E-02, E-05 | ○ |
| C-26 | JobsForm - ジョブキュー機能 | E-01, E-02, E-06 | ○ |
| C-27 | JobsForm - ジョブ実行機能 | E-02, E-06 | ○ |
| C-28 | JobsForm - プロジェクト読込 | E-02, E-06 | ○ |
| C-29 | CropForm - クロップ機能 | E-01, E-02, E-07 | ○ |
| C-30 | CropForm - クロップ調整UI | E-02, E-07 | ○ |
| C-31 | CropForm - ビデオプレビュー | E-02, E-07 | ○ |
| C-32 | AudioForm - オーディオDemux | E-02 | △ |
| C-33 | AudioForm - オーディオエンコード | E-02 | △ |
| C-34 | AudioForm - オーディオ正規化 | E-02 | △ |
| C-35 | AudioForm - オーディオカット | E-02 | △ |
| C-36 | AudioForm - チャンネルダウンミックス | E-02 | △ |
| C-37 | AppsForm - 外部ツール管理 | E-01, E-02, E-08 | ○ |
| C-38 | AppsForm - ツール自動ダウンロード | E-02, E-08 | ○ |
| C-39 | AppsForm - MediaInfo表示 | E-02, E-08 | ○ |
| C-40 | MuxerForm - MKV Mux | E-01, E-02, E-09 | ○ |
| C-41 | MuxerForm - MP4 Mux | E-02, E-09 | ○ |
| C-42 | MuxerForm - 字幕追加 | E-02, E-09 | ○ |
| C-43 | MuxerForm - メタデータ設定 | E-02, E-09 | ○ |
| C-44 | MuxerForm - 添付ファイル追加 | E-02, E-09 | ○ |
| C-45 | StreamDemuxForm - オーディオDemux | E-01, E-02, E-10 | ○ |
| C-46 | StreamDemuxForm - 字幕抽出 | E-02, E-10 | ○ |
| C-47 | StreamDemuxForm - 添付ファイル抽出 | E-02, E-10 | ○ |
| C-48 | StreamDemuxForm - チャプター抽出 | E-02, E-10 | ○ |
| C-49 | VideoComparisonForm - 比較プレビュー | E-01, E-02, E-11 | ○ |
| C-50 | VideoComparisonForm - ビデオプレビュー | E-02, E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- AudioForm.vbファイルの詳細な解析が完了していない
  - 候補：機能一覧からの推測 / 関連するオーディオ処理クラスの確認 / ユーザーマニュアル
- ProfilesForm.vb、eac3toForm.vb、CodeForm.vb、LogForm.vb、DownloadForm.vb、UpdateForm.vbの詳細解析が未実施
  - 候補：各フォームファイルの直接読み取り / 機能一覧との照合 / 画面遷移分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MainForm、PreviewForm、CropForm、MuxerForm、VideoComparisonForm（詳細なコード解析済み）
- 1: 中リスク - JobsForm、ProcessingForm、AppsForm、StreamDemuxForm（部分的なコード解析）
- 2: 高リスク - AudioForm、ProfilesForm、eac3toForm、CodeForm（ソースコード詳細未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] AudioForm関連のマッピングが機能一覧の記述と整合しているか確認
- [ ] ProfilesFormのテンプレート機能マッピングが正確か確認
- [ ] eac3toFormのDemux機能マッピングが実装と一致するか確認
- [ ] 画面一覧のNo.と本マッピングのNo.が一致しているか確認
- [ ] 機能一覧のNo.と本マッピングの機能No.が一致しているか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
