# 画面設計書: MainForm（メイン画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 1 |
| 画面名 | MainForm |
| 画面名（日本語） | メイン画面 |
| ソースファイル | `Source/Forms/MainForm.vb` |
| 継承元クラス | FormBase |
| 画面種別 | メインウィンドウ |

## 2. 画面概要

StaxRipアプリケーションのメイン画面。動画エンコードのための主要な操作をすべて行うための中心的なインターフェースを提供する。ソースファイルの指定、ターゲットファイルの設定、リサイズ、フィルター、エンコーダー設定、オーディオ設定など、動画変換に必要なすべての設定項目を一画面で管理できる。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| MenuStrip（メニューバー）                                          |
+------------------------------------------------------------------+
| +----------------------------+ +------------------------------+  |
| | lgbSource（ソース）         | | lgbTarget（ターゲット）       |  |
| | - tbSourceFile             | | - tbTargetFile               |  |
| | - lSource1, lSource2       | | - tbTargetSize, tbBitrate    |  |
| | - Crop/PAR/DAR情報         | | - lTarget1, laTarget2        |  |
| +----------------------------+ +------------------------------+  |
| +----------------+ +----------------+ +------------------------+ |
| | lgbFilters     | | lgbResize      | | lgbEncoder             | |
| | (フィルター)   | | (リサイズ)     | | (エンコーダー)         | |
| | FiltersListView| | tbTargetWidth  | | pnEncoder              | |
| |                | | tbTargetHeight | | llMuxer                | |
| |                | | tbResize       | |                        | |
| +----------------+ +----------------+ +------------------------+ |
| +------------------------------------------------------------------+
| | gbAudio（オーディオ）                                            |
| | tlpAudio                                                         |
| +------------------------------------------------------------------+
| +------------------------------------------------------------------+
| | gbAssistant（アシスタント）                                      |
| | - laTip                                                          |
| | - bnNext                                                         |
| +------------------------------------------------------------------+
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| MenuStrip | MenuStrip | メインメニューバー |
| lgbSource | LinkGroupBox | ソースファイル設定グループ |
| tbSourceFile | TextEdit | ソースファイルパス入力 |
| lSource1 | LabelEx | ソース情報ライン1 |
| lSource2 | LabelEx | ソース情報ライン2 |
| lCrop | LabelEx | クロップ値表示 |
| blSourceParText | ButtonLabel | ソースPAR表示 |
| blSourceDarText | ButtonLabel | ソースDAR表示 |
| lgbTarget | LinkGroupBox | ターゲットファイル設定グループ |
| tbTargetFile | TextEdit | ターゲットファイルパス入力 |
| tbTargetSize | TextEdit | ターゲットサイズ入力 |
| tbBitrate | TextEdit | ビットレート入力 |
| blFilesize | ButtonLabel | ファイルサイズ表示 |
| lTarget1 | LabelEx | ターゲット情報ライン1 |
| laTarget2 | LabelEx | ターゲット情報ライン2 |
| lgbFilters | LinkGroupBox | フィルター設定グループ |
| FiltersListView | FiltersListView | フィルターリスト |
| lgbResize | LinkGroupBox | リサイズ設定グループ |
| tbTargetWidth | TextEdit | ターゲット幅入力 |
| tbTargetHeight | TextEdit | ターゲット高さ入力 |
| tbResize | TrackBar | リサイズスライダー |
| blTargetDarText | ButtonLabel | ターゲットDAR表示 |
| blTargetParText | ButtonLabel | ターゲットPAR表示 |
| lgbEncoder | LinkGroupBox | エンコーダー設定グループ |
| pnEncoder | Panel | エンコーダー設定パネル |
| llMuxer | ButtonLabel | Muxer選択 |
| gbAudio | GroupBoxEx | オーディオ設定グループ |
| tlpAudio | TableLayoutPanel | オーディオレイアウト |
| gbAssistant | GroupBoxEx | アシスタントグループ |
| laTip | LabelEx | ヒント表示 |
| bnNext | ButtonEx | 次へボタン |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | ソースファイル指定 | 変換元の動画ファイルを指定 |
| F002 | ターゲットファイル指定 | 出力ファイルのパスと名前を指定 |
| F003 | ターゲットサイズ設定 | 出力ファイルのサイズを指定 |
| F004 | ビットレート設定 | 動画のビットレートを設定 |
| F005 | フィルター設定 | AviSynthフィルターの追加・編集・削除 |
| F006 | リサイズ設定 | 出力動画の解像度を設定 |
| F007 | エンコーダー設定 | 使用するエンコーダーとパラメータを設定 |
| F008 | Muxer設定 | 出力コンテナとMuxerを設定 |
| F009 | オーディオ設定 | オーディオトラックの設定 |
| F010 | アシスタント機能 | 次のステップへのガイダンス表示 |
| F011 | クロップ設定 | 動画のクロップ範囲を設定 |
| F012 | アスペクト比設定 | PAR/DAR/SARの設定 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| ソースファイル変更 | ファイル解析、メタデータ取得、UIの自動更新 |
| ターゲットファイル変更 | 出力パスの検証、拡張子によるMuxer自動選択 |
| サイズ/ビットレート変更 | 相互計算による値の連動更新 |
| フィルター編集 | フィルタースクリプトの再生成 |
| リサイズ変更 | アスペクト比、ピクセル数の再計算 |
| bnNextクリック | アシスタントの次のステップへ遷移またはエンコード開始 |

### 4.3 メニュー構成

MainFormはCustomMainMenuを使用してメニューを構成。以下の主要メニューが含まれる：
- Project: プロジェクト関連操作
- View: 表示関連
- Size: サイズ設定
- Tools: ツール類
- Apps: 外部アプリケーション
- Help: ヘルプ

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| p.SourceFile | tbSourceFile | ソースファイルパス |
| p.TargetFile | tbTargetFile | ターゲットファイルパス |
| p.VideoBitrate | tbBitrate | ビデオビットレート |
| p.Size | tbTargetSize | ターゲットサイズ |
| p.CropLeft/Right/Top/Bottom | lCrop | クロップ値 |
| p.TargetWidth | tbTargetWidth | ターゲット幅 |
| p.TargetHeight | tbTargetHeight | ターゲット高さ |

## 6. 画面遷移

### 6.1 遷移元

- アプリケーション起動時に最初に表示される

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| PreviewForm | プレビューメニュー/ショートカット | ソースファイル設定済み |
| ProcessingForm | エンコード開始 | 設定完了 |
| JobsForm | ジョブ管理メニュー | - |
| CropForm | クロップ設定クリック | ソースファイル設定済み |
| AudioForm | オーディオ設定編集 | - |
| AppsForm | アプリケーション設定メニュー | - |
| ProfilesForm | プロファイル管理メニュー | - |
| MacrosForm | マクロ表示メニュー | - |
| HelpForm | ヘルプ/ツールチップ表示 | - |

## 7. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| ソースファイル | 有効なファイルパス、対応形式 | ファイルが見つかりません |
| ターゲットファイル | 有効なパス、書き込み権限 | 出力先にアクセスできません |
| ビットレート | 正の整数値 | 無効なビットレート値です |
| サイズ | 正の整数値 | 無効なサイズ値です |
| 解像度 | MOD値に従った値 | 解像度がMOD値に適合しません |

## 8. 非機能要件

### 8.1 パフォーマンス

- 画面初期表示: 1秒以内
- ソースファイル読み込み: ファイルサイズに依存

### 8.2 UI/UX

- ドラッグ&ドロップによるファイル指定対応（AllowDrop = True）
- DPIスケーリング対応（AutoScaleMode.Dpi）
- テーマ切り替え対応（ThemeManager）
- キーボードショートカット対応

## 9. コードリーディングガイド

### 9.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/MainForm.vb` | メインフォーム実装（行1-2000+） |
| `Source/Forms/MainForm.Designer.vb` | デザイナー生成コード（存在する場合） |
| `Source/UI/FormBase.vb` | 基底フォームクラス |
| `Source/UI/LinkGroupBox.vb` | カスタムグループボックス |
| `Source/UI/TextEdit.vb` | カスタムテキスト編集コントロール |
| `Source/FiltersListView.vb` | フィルターリストビュー |
| `Source/Project.vb` | プロジェクトデータクラス |
| `Source/Settings.vb` | 設定管理クラス |

### 9.2 プログラム呼び出し階層図

```
MainForm (FormBase)
├── InitializeComponent() [行85-959]
│   └── 全UIコントロールの初期化
├── New(loadSettings As Boolean) [行991-]
│   ├── g.MainForm = Me
│   ├── g.LoadSettings()
│   ├── g.LoadAudioProfiles()
│   └── g.LoadVideoEncoderProfiles()
├── ソースファイル処理
│   ├── tbSourceFile_TextChanged
│   └── OpenSourceFile()
│       └── MediaInfo解析
├── エンコード処理
│   └── bnNext_Click
│       └── ProcessingForm表示
└── メニュー処理
    └── CustomMainMenu各項目
```

### 9.3 データフロー図

```
[ソースファイル選択]
       │
       ▼
[MediaInfo解析] ─────► [ソース情報表示]
       │                  (lSource1, lSource2)
       ▼
[プロジェクト(p)更新]
       │
       ├──► [クロップ/アスペクト比計算]
       │
       ├──► [フィルタースクリプト生成]
       │
       └──► [ターゲット設定推定]
                │
                ▼
         [ビットレート/サイズ計算]
                │
                ▼
         [エンコード実行] ──► ProcessingForm
```

### 9.4 読み解きの推奨順序

1. **データ構造の理解**: `Project.vb`のプロパティを確認
2. **エントリーポイント**: `MainForm.New()`コンストラクタ（行991）
3. **UI初期化**: `InitializeComponent()`（行85-959）
4. **主要イベントハンドラ**: ソースファイル変更、bnNextクリック等
5. **メニュー構築**: CustomMainMenuの設定部分
