# 画面設計書: HelpForm（ヘルプ画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 10 |
| 画面名 | HelpForm |
| 画面名（日本語） | ヘルプ画面 |
| ソースファイル | `Source/Forms/HelpForm.vb` |
| 継承元クラス | FormBase |
| 画面種別 | モーダレスフォーム |

## 2. 画面概要

ヘルプドキュメントを表示する画面。WebBrowserコントロールを使用してHTMLヘルプを表示する。HelpDocumentクラスと連携してXML/HTMLベースのドキュメントを動的に生成・表示する。外部URLへのリンクはデフォルトブラウザで開く。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| [タイトル: ドキュメントタイトル]                                     |
+------------------------------------------------------------------+
| Browser (WebBrowser - Dock.Fill)                                  |
| +--------------------------------------------------------------+ |
| |                                                              | |
| |  <h1>ヘルプタイトル</h1>                                     | |
| |                                                              | |
| |  <h2>セクション1</h2>                                        | |
| |  説明テキスト...                                             | |
| |                                                              | |
| |  <h2>セクション2</h2>                                        | |
| |  ・ヒント1: 説明...                                          | |
| |  ・ヒント2: 説明...                                          | |
| |                                                              | |
| +--------------------------------------------------------------+ |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| Browser | WebBrowser | ヘルプHTML表示ブラウザ |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | ヘルプ表示 | HTML形式のヘルプドキュメント表示 |
| F002 | 動的ドキュメント生成 | HelpDocumentによるHTML生成 |
| F003 | 外部リンク処理 | HTTPリンクをデフォルトブラウザで開く |
| F004 | タイトル自動更新 | ドキュメントタイトルをフォームタイトルに反映 |
| F005 | テキストサイズリセット | ドキュメント完了時にテキストサイズをリセット |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| Browser.DocumentCompleted | テキストサイズのリセット |
| Browser.Navigated | フォームタイトルの更新 |
| Browser.Navigating | 外部URL（http）をデフォルトブラウザで開く |
| OnFormClosed | リソース解放（Dispose） |

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| HelpDocument | Doc プロパティ | ヘルプドキュメント生成オブジェクト |
| Browser.DocumentTitle | Text | フォームタイトル |

### 5.2 HelpDocumentクラス

HelpDocumentは動的にHTMLを生成するクラス:

| メソッド | 説明 |
|---------|------|
| WriteStart(title) | HTMLドキュメント開始・タイトル設定 |
| WriteParagraph(text) | 段落テキスト書き込み |
| WriteTips(tips) | ヒント一覧（StringPairList）書き込み |
| WriteDocument(browser) | 生成HTMLをWebBrowserに表示 |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| 各画面 | F1キー（HelpRequested） |
| ProfilesForm | F1キー |
| CropForm | F1キー/ヘルプメニュー |
| 各設定ダイアログ | ヘルプボタン |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| デフォルトブラウザ（外部） | HTTPリンククリック | URLがhttpで始まる場合 |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| Doc | HelpDocument | ヘルプドキュメント生成オブジェクト（遅延初期化） |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| Show() | フォーム表示＆ドキュメント書き込み |
| ShowDialog(heading, tips) | 静的メソッド：ヒント一覧表示 |
| ShowDialog(heading, tips, summary) | 静的メソッド：サマリー付きヒント一覧表示 |

### 7.3 静的メソッド

| メソッド | 説明 |
|---------|------|
| ShowDialog(heading, tips) | ヒント一覧をHelpFormで表示 |
| ShowDialog(heading, tips, summary) | サマリー付きヒント一覧を表示 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| URL判定 | httpで始まるURLは外部ブラウザで開く | - |

## 9. 非機能要件

### 9.1 パフォーマンス

- 一時ファイルとしてHTMLを生成（Folder.Temp）
- MainForm.Disposedで一時ファイル削除

### 9.2 UI/UX

- DPIスケーリング対応（AutoScaleMode.Dpi）
- 画面中央に表示（StartPosition.CenterScreen）
- クライアントサイズ復元機能（RestoreClientSize）
- テキストサイズリセット（WebBrowserHelp.ResetTextSize）
- 外部リンクは新しいブラウザウィンドウで開く

### 9.3 デザイン

- ダークテーマベース（背景色 #323232、文字色 #DDDDDD）
- Lato/Tahoma/Genevaフォント使用
- H1見出し 150%サイズ

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/HelpForm.vb` | ヘルプフォーム実装（行1-114） |
| `Source/General/General.vb` | HelpDocumentクラス（行439〜） |
| `Source/UI/WebBrowserHelp.vb` | WebBrowserヘルパー |

### 10.2 プログラム呼び出し階層図

```
HelpForm (FormBase)
├── New() [行47-51]
│   ├── InitializeComponent() [行20-44]
│   ├── RestoreClientSize(50, 35)
│   └── Icon = g.Icon
├── Doc プロパティ [行55-68]
│   └── 遅延初期化
│       ├── 一時ファイルパス生成
│       ├── MainForm.Disposed で削除登録
│       └── New HelpDocument(path)
├── Show() [行102-106]
│   ├── MyBase.Show()
│   └── DocumentValue?.WriteDocument(Browser)
├── ShowDialog(heading, tips) [行70-72]
│   └── ShowDialog(heading, tips, Nothing)
├── ShowDialog(heading, tips, summary) [行74-84]
│   ├── New HelpForm()
│   ├── form.Doc.WriteStart(heading)
│   ├── form.Doc.WriteParagraph(summary) ※あれば
│   ├── form.Doc.WriteTips(tips)
│   └── form.Show()
├── Browser_DocumentCompleted() [行90-92]
│   └── WebBrowserHelp.ResetTextSize(Browser)
├── Browser_Navigated() [行94-100]
│   └── Text = Browser.DocumentTitle または ファイル名
├── Browser_Navigating() [行108-113]
│   └── http URL → g.ShellExecute() & キャンセル
└── OnFormClosed() [行86-88]
    └── Dispose()
```

### 10.3 データフロー図

```
[呼び出し元（ProfilesForm等）]
      │
      ├──► HelpForm.ShowDialog(heading, tips)
      │         │
      │         ▼
      │    [Doc.WriteStart(heading)]
      │         │
      │         ▼
      │    [Doc.WriteTips(tips)]
      │         │
      │         ▼
      │    [Show()]
      │         │
      │         ▼
      │    [Doc.WriteDocument(Browser)]
      │         │
      │         ▼
      │    [一時HTMLファイル生成]
      │         │
      │         ▼
      │    [Browser.Navigate(path)]
      │
      └──► [HTTPリンククリック]
                │
                ▼
           [Browser_Navigating]
                │
                ▼
           [g.ShellExecute(url)]
                │
                ▼
           [デフォルトブラウザで開く]
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `HelpDocument`クラス（General.vb内）
2. **エントリーポイント**: コンストラクタ `New()` [行47]
3. **静的メソッド**: `ShowDialog()` [行70, 74]
4. **ドキュメント生成**: `Doc`プロパティの遅延初期化 [行55]
5. **表示処理**: `Show()` [行102]
6. **ブラウザイベント**: DocumentCompleted, Navigated, Navigating
7. **外部リンク処理**: `Browser_Navigating()` [行108]
