# 画面設計書 11-LogForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるログ表示画面（LogForm）の設計仕様を記載する。処理ログの表示、セクション検索、ログファイルの保存・外部編集機能を提供する画面である。

### 本画面の処理概要

LogFormは、エンコード処理中に生成されたログ情報を表示・管理するための画面である。リッチテキスト形式でログを表示し、処理の詳細を確認することができる。

**業務上の目的・背景**：動画エンコード処理は複雑で長時間に及ぶことがあり、処理中の詳細な情報やエラー発生時の原因究明のためにログ情報の確認が不可欠である。本画面により、ユーザーはエンコード処理の進行状況や発生した問題を詳細に把握し、必要に応じてログを保存・共有することができる。

**画面へのアクセス方法**：メイン画面（MainForm）のメニュー「Tools > Log」から呼び出される。また、ProcessingFormからもF8キーまたはLogボタンで遷移可能。

**主要な操作・処理内容**：
1. ログファイルの内容をリッチテキストボックスに表示
2. セクション見出しをリストボックスに抽出・表示し、クリックで該当セクションへジャンプ
3. 「Save As...」でログファイルを任意の場所に保存
4. 「Save Obfuscated As...」で機密情報を難読化したログファイルを保存
5. 「Open in Text Editor」でシステム既定のテキストエディタで開く
6. 「Show in File Explorer」でログファイルの場所をエクスプローラーで表示
7. 「Show History」で過去のログファイル履歴を表示

**画面遷移**：MainFormまたはProcessingFormから遷移してくる。本画面から他画面への遷移はない（モーダルダイアログとして動作）。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 67 | ログ表示 | 主機能 | リッチテキスト形式でログ表示 |

## 画面種別

詳細表示 / ログビューア

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `LogForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| ログファイルパス | 入力 | String | はい | 表示対象のログファイルパス（p.Log.GetPath） |
| ログ内容 | 出力 | String | - | ログファイルのテキスト内容 |
| セクション一覧 | 出力 | List(Of String) | - | 正規表現で抽出されたセクション見出し |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タイトルバー | String | 「Log - {ログファイルパス}」形式で表示 |
| セクションリスト（lb） | ListBox | ログ内セクション見出しの一覧表示 |
| ログ本文（rtb） | RichTextBox | ログファイル全文を表示（読み取り専用） |

## イベント仕様

### 1-フォーム初期化

フォーム生成時にログファイルを読み込み、セクション見出しを抽出する。

1. ログファイルパスをタイトルバーに表示
2. `p.Log.GetPath.ReadAllText`でログファイル全文を読み込み
3. 正規表現`^-+ (.+) -+`でセクション見出しを抽出
4. 抽出したセクション見出しをリストボックスに追加
5. コンテキストメニューに各種操作を追加
6. テーマを適用

### 2-セクション選択（lb_SelectedIndexChanged）

リストボックスでセクションを選択するとログ本文の該当位置へスクロール。

1. 選択されたセクション名を取得
2. `rtb.Find("- " + セクション名 + " -")`で該当箇所を検索
3. `rtb.ScrollToCaret()`でカーソル位置へスクロール

### 3-ログ保存（Save As...）

Ctrl+Sで実行。ログファイルを任意の場所に保存。

1. SaveFileDialogを表示
2. デフォルトファイル名をログファイル名に設定
3. OK押下でUTF-8形式で保存

### 4-難読化保存（Save Obfuscated As...）

Ctrl+Alt+Sで実行。機密情報を難読化したログを保存。

1. SaveFileDialogを表示
2. デフォルトファイル名を「Source」+拡張子に設定
3. `g.ObfuscateLogFile`で難読化処理
4. UTF-8形式で保存

### 5-テキストエディタで開く（Open in Text Editor）

Ctrl+Tで実行。システム既定のテキストエディタでログを開く。

### 6-エクスプローラーで表示（Show in File Explorer）

Ctrl+Eで実行。ログファイルの場所をエクスプローラーで開き選択。

### 7-履歴表示（Show History）

Ctrl+Hで実行。設定フォルダ内のLog Filesフォルダを開く。

## データベース更新仕様

本画面はデータベースを使用しない。ログはファイルシステム上のテキストファイルとして管理される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | 本画面では特定のメッセージ表示なし | - |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ログファイルが存在しない | ファイル読み込み時に空文字が設定される |
| ファイル保存エラー | SaveFileDialogのキャンセルで処理中止 |

## 備考

- ログ表示はリッチテキストボックスを使用し、URLの自動検出は無効化されている（`rtb.DetectUrls = False`）
- フォントはコードフォント（等幅フォント）を使用（`FontManager.GetCodeFont()`）
- リストボックスの行高さはフォント高さの2倍に設定
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ表示画面はシンプルな構造で、プロジェクトオブジェクト（p）からログパスを取得する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | `Log`プロパティおよび`GetPath`メソッドでログファイルパスの取得方法を理解 |

**読解のコツ**: VB.NETのプロパティアクセスとファイルパス操作の基本を押さえておくとよい。

#### Step 2: エントリーポイントを理解する

LogFormのコンストラクタがエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogForm.vb | `Source/Forms/LogForm.vb` | コンストラクタ`Sub New()`でフォーム初期化処理を確認 |

**主要処理フロー**:
1. **行7-8**: `InitializeComponent()`でデザイナー生成コードを実行、`RestoreClientSize(50, 35)`でウィンドウサイズ復元
2. **行10**: タイトルバーにログファイルパスを設定
3. **行11-15**: リストボックス・リッチテキストボックスの初期設定
4. **行17-26**: 正規表現でセクション見出しを抽出しリストボックスに追加
5. **行28-56**: コンテキストメニューの設定（保存・外部編集機能）
6. **行58-60**: テーマ適用とイベントハンドラ登録

#### Step 3: イベント処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogForm.vb | `Source/Forms/LogForm.vb` | `lb_SelectedIndexChanged`（行98-103）でセクションジャンプ処理を確認 |

**主要処理フロー**:
- **行99-102**: リストボックス選択時に`rtb.Find`と`rtb.ScrollToCaret`でログ本文内の該当セクションへスクロール

### プログラム呼び出し階層図

```
LogForm (Source/Forms/LogForm.vb)
    │
    ├─ New() コンストラクタ
    │      ├─ InitializeComponent() ← デザイナー生成コード
    │      ├─ p.Log.GetPath ← ログファイルパス取得
    │      ├─ Regex.Matches() ← セクション見出し抽出
    │      └─ ContextMenuStripEx.Add() ← メニュー項目追加
    │
    ├─ lb_SelectedIndexChanged()
    │      ├─ rtb.Find() ← テキスト検索
    │      └─ rtb.ScrollToCaret() ← スクロール
    │
    ├─ Save As... (Lambda)
    │      └─ rtb.Text.WriteFileUTF8() ← ファイル保存
    │
    └─ Save Obfuscated As... (Lambda)
           └─ g.ObfuscateLogFile() ← 難読化処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

p.Log.GetPath ───▶ File.ReadAllText() ───▶ rtb.Text (ログ表示)
                         │
                         ▼
                   Regex.Matches() ───▶ lb.Items (セクションリスト)
                         │
                         ▼
lb.SelectedIndex ───▶ rtb.Find() ───▶ rtb.ScrollToCaret()

Save As... ───▶ SaveFileDialog ───▶ WriteFileUTF8() ───▶ ファイル出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogForm.vb | `Source/Forms/LogForm.vb` | ソース | ログ表示フォーム本体 |
| LogForm.Designer.vb | `Source/Forms/LogForm.Designer.vb` | ソース | デザイナー生成コード |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクト情報（Logプロパティ） |
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | g.ObfuscateLogFile等のグローバル関数 |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理機能 |
