# 画面設計書 12-VideoComparisonForm

## 概要

本ドキュメントはStaxRipアプリケーションにおける動画比較画面（VideoComparisonForm）の設計仕様を記載する。複数の動画ファイルをタブ形式で並べて比較し、エンコード前後の品質確認を行う画面である。

### 本画面の処理概要

VideoComparisonFormは、複数の動画ファイルをタブコントロールで管理し、同一フレーム位置で品質を比較するための画面である。AviSynthまたはVapourSynthスクリプトを介してフレームを表示し、PNG画像として保存する機能を提供する。

**業務上の目的・背景**：動画エンコードにおいて、エンコード前後の品質差やエンコード設定の違いによる結果の差異を視覚的に確認することは重要である。本画面により、ユーザーは複数の動画ファイルを同一フレーム位置で素早く切り替えながら比較し、最適なエンコード設定を判断することができる。また、比較結果をPNG画像として保存し、レビューや報告に活用できる。

**画面へのアクセス方法**：メイン画面（MainForm）のメニュー「Tools > Video Comparison」から呼び出される。

**主要な操作・処理内容**：
1. 動画ファイルの追加（ファイル選択ダイアログまたはドラッグ&ドロップ）
2. タブ切り替えによる動画の表示切り替え
3. トラックバーでフレーム位置を指定
4. マウスホイールでフレーム移動（100フレーム単位）
5. 現在位置のフレームをPNG画像として保存
6. クロップ＆ズーム設定で表示範囲を調整
7. 特定フレームまたは時間へのジャンプ
8. x265のCSVログファイルからフレーム情報を表示

**画面遷移**：MainFormから遷移してくる。本画面からHelpFormへ遷移可能（F1キー）。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | 比較プレビュー | 主機能 | TabControlで複数動画を並べて比較表示 |
| 46 | ビデオプレビュー | 補助機能 | VideoTabでフレーム単位プレビュー |

## 画面種別

比較表示 / プレビューア

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `VideoComparisonForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| 動画ファイルパス | 入力 | String[] | いいえ | 比較対象の動画ファイルパス（複数可） |
| ソースファイル | 入力 | String | いいえ | プロジェクトのソースファイル（p.SourceFile） |
| ターゲットファイル | 入力 | String | いいえ | エンコード出力ファイル（p.TargetFile） |
| クロップ値 | 入力 | Integer | いいえ | 上下左右のクロップ値 |
| フレーム画像 | 出力 | PNG | - | 保存されるフレーム画像 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タブコントロール | TabControl | 各動画ファイルをタブで表示 |
| トラックバー | TrackBar | フレーム位置指定用スライダー |
| ファイルパスラベル | Label | 現在選択中タブの動画ファイルパス |
| 情報ラベル | Label | フレーム位置、時間、解像度等の情報 |
| メニューボタン | Button | コンテキストメニュー表示用 |

## イベント仕様

### 1-フォーム表示（OnShown）

フォーム表示時に自動的に動画ファイル追加処理を開始。

1. ソースファイルが存在し未オープンの場合、自動追加
2. ターゲットファイルが存在する場合、続けて追加
3. 上記がない場合、ファイル選択ダイアログを表示

### 2-動画追加（Add）

動画ファイルをタブとして追加する。

1. AviSynthパッケージの確認
2. VideoTabインスタンスを作成
3. ファイル種別（avs/vpy/png/video）に応じてスクリプト生成
4. クロップ設定を適用
5. FrameServerを作成してレンダリング準備
6. CSVログファイルがあればフレーム情報を読み込み
7. トラックバーの最大値を更新

### 3-タブ削除（Remove）

選択中のタブを削除しリソースを解放。

### 4-フレーム位置変更（TrackBar_ValueChanged）

トラックバー操作時に現在タブのフレームを更新。

1. Posプロパティを更新
2. 選択中のVideoTabでDraw()を呼び出し
3. フレーム情報ラベルを更新（位置、時間、解像度）

### 5-PNG保存（Save）

各タブの現在フレームをPNG画像として保存。

1. 全タブをループ
2. ファイル名形式はPrefixまたはSuffixでフレーム番号を付加
3. BitmapUtil.CreateBitmapでフレーム取得
4. PNG形式で保存

### 6-クロップ＆ズーム（CropZoom）

SimpleSettingsFormを使用してクロップ値を設定。

1. 上下左右のクロップ値を数値入力
2. OK押下で全タブをリロード
3. 新しいクロップ値でフレームを再描画

### 7-フレームジャンプ（GoToFrame）

指定フレーム番号へ移動。InputBoxで数値入力を受け付け。

### 8-時間ジャンプ（GoToTime）

指定時間（HH:mm:ss.fff形式）へ移動。フレームレートから位置を計算。

### 9-ドラッグ&ドロップ

フォームまたはタブコントロールへのファイルドロップを受け付け。

## データベース更新仕様

本画面はデータベースを使用しない。動画ファイルはファイルシステムから直接読み込む。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-01 | 情報 | Images were saved in the source file directory. | PNG保存成功時 |
| MSG-02 | エラー | AviSynth確認エラー | AviSynthパッケージ未インストール時 |
| MSG-03 | エラー | FrameServer.Error | フレームサーバーエラー発生時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 動画ファイルが開けない | VideoTab.Open()がFalseを返し、タブを破棄 |
| フレームサーバーエラー | MsgErrorでエラーメッセージを表示 |
| 無効なフレーム位置 | TrackBar.Valueの範囲内に制限 |

## 備考

- AviSynth+が必要（Package.AviSynth.VerifyOK）
- MP4ファイルはLSMASHVideoSource、その他はFFVideoSourceを使用
- フレーム画像のファイル名位置（Prefix/Suffix）は設定で選択可能
- メモリ使用量制限のためSetMemoryMax(512)を設定
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VideoTabクラスが動画タブの基本単位となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | VideoTab内部クラス（行354-613）でタブの構造を理解 |

**読解のコツ**: VideoTabはTabPageを継承し、Server（IFrameServer）とRenderer（VideoRenderer）を保持する。ファイル種別ごとのスクリプト生成処理が重要。

#### Step 2: エントリーポイントを理解する

フォームのコンストラクタとOnShownがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | New()（行16-59）でメニュー・イベント設定、OnShown()（行286-289）で自動追加 |

**主要処理フロー**:
1. **行16-18**: フォーム初期化、サイズ復元
2. **行21-48**: コンテキストメニュー設定（Add, Remove, Save, CropZoom等）
3. **行51-58**: ドラッグ&ドロップイベントハンドラ登録
4. **行286-289**: OnShownでAdd()を呼び出し

#### Step 3: 動画追加処理を理解する

Add()メソッドとVideoTab.Open()が動画追加の中核。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | Add(sourcePath)（行153-177）でタブ作成、VideoTab.Open()（行393-490）でスクリプト生成 |

**主要処理フロー**:
- **行393-411**: ファイル種別判定とTempFilePath設定
- **行420-437**: ファイル種別に応じたソースフィルタ生成
- **行439-452**: クロップフィルタ追加
- **行454-458**: スクリプト同期とFrameServer作成
- **行464-488**: CSVログファイルからフレーム情報読み込み

### プログラム呼び出し階層図

```
VideoComparisonForm (Source/Forms/VideoComparisonForm.vb)
    │
    ├─ New() コンストラクタ
    │      ├─ InitializeComponent()
    │      └─ Menu.Add() ← メニュー項目設定
    │
    ├─ OnShown()
    │      └─ Add() ← 自動追加開始
    │
    ├─ Add(sourcePath)
    │      ├─ VideoTab.New()
    │      ├─ VideoTab.Open()
    │      │      ├─ VideoScript作成
    │      │      ├─ FrameServerFactory.Create()
    │      │      └─ VideoRenderer作成
    │      └─ TrackBar.Maximum更新
    │
    ├─ TrackBar_ValueChanged()
    │      └─ VideoTab.TrackBarValueChanged()
    │             ├─ Pos更新
    │             ├─ Draw()
    │             └─ laInfo.Text更新
    │
    └─ Save()
           └─ VideoTab.GetBitmap()
                  └─ BitmapUtil.CreateBitmap()
```

### データフロー図

```
[入力]                   [処理]                      [出力]

動画ファイルパス ───▶ VideoScript生成 ───▶ IFrameServer
                              │
                              ▼
                      FrameServerFactory.Create()
                              │
                              ▼
TrackBar.Value ───▶ VideoRenderer.Draw() ───▶ VideoPanel (画面表示)
      │
      ▼
Pos(フレーム位置) ───▶ BitmapUtil.CreateBitmap() ───▶ PNG保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VideoComparisonForm.vb | `Source/Forms/VideoComparisonForm.vb` | ソース | 動画比較フォーム本体（VideoTab含む） |
| VideoComparisonForm.Designer.vb | `Source/Forms/VideoComparisonForm.Designer.vb` | ソース | デザイナー生成コード |
| VideoScript.vb | `Source/Encoding/VideoScript.vb` | ソース | AviSynth/VapourSynthスクリプト管理 |
| FrameServerFactory.vb | `Source/FrameServer/FrameServerFactory.vb` | ソース | フレームサーバー生成 |
| VideoRenderer.vb | `Source/UI/VideoRenderer.vb` | ソース | フレーム描画処理 |
| BitmapUtil.vb | `Source/General/BitmapUtil.vb` | ソース | ビットマップ生成ユーティリティ |
| SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | ソース | クロップ設定ダイアログ |
