# 画面設計書 13-SimpleSettingsForm

## 概要

本ドキュメントはStaxRipアプリケーションにおける汎用設定ダイアログ（SimpleSettingsForm）の設計仕様を記載する。SimpleUIコンポーネントを使用した再利用可能な設定フォーム基盤である。

### 本画面の処理概要

SimpleSettingsFormは、各種設定画面で共通的に使用される汎用的な設定ダイアログである。SimpleUIコントロールをベースに動的にUI要素を構築し、設定の入力・保存を行う。他の機能から呼び出される基盤コンポーネントとして機能する。

**業務上の目的・背景**：StaxRipでは多くの設定画面が必要であり、それぞれ個別のフォームを作成すると開発コストが増大する。本画面は汎用的な設定UI基盤を提供することで、設定画面の実装を効率化し、UIの一貫性を保つ役割を果たす。

**画面へのアクセス方法**：直接呼び出されるのではなく、各機能から設定ダイアログとして利用される。例えばVideoComparisonFormのCropZoom機能などから呼び出される。

**主要な操作・処理内容**：
1. タイトルとヘルプ情報を受け取ってフォームを初期化
2. SimpleUIコンポーネントで動的にUI要素（数値入力、テキスト入力、メニュー等）を構築
3. ユーザーが設定値を入力・変更
4. OK押下で設定値を保存、Cancel押下でキャンセル
5. F1キーでヘルプ表示

**画面遷移**：各種画面から設定ダイアログとして呼び出される（モーダル）。HelpFormへF1キーで遷移可能。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 汎用設定 | 基盤機能 | 各種設定画面の基盤コンポーネント |

## 画面種別

設定ダイアログ / 汎用

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `SimpleSettingsForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| タイトル | 入力 | String | はい | ダイアログのタイトル |
| ヘルプ段落 | 入力 | String[] | いいえ | F1ヘルプに表示する説明文 |
| 設定値 | 入出力 | 各種 | - | SimpleUIで管理される設定値 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タイトルバー | String | {title} - {アプリケーション詳細}形式 |
| SimpleUI | SimpleUI | 動的設定UIコンポーネント |
| LineControl | LineControl | OK/Cancelボタン上部の区切り線 |
| OKボタン | Button | DialogResult.OK |
| Cancelボタン | Button | DialogResult.Cancel |

## イベント仕様

### 1-フォーム初期化（New）

コンストラクタでタイトルとヘルプ情報を受け取り初期化。

1. InitializeComponent()で基本UI構築
2. SetMinimumSize(33, 25)で最小サイズ設定
3. ScaleClientSize(40, 32.75)でクライアントサイズ設定
4. タイトルバーに`{title} - {g.DefaultCommands.GetApplicationDetails()}`を設定
5. HelpParagraphsにヘルプ文字列を保存
6. SimpleUI.Tree.Select()でツリービューを選択
7. テーマ適用

### 2-ヘルプ要求（SimpleSettingsForm_HelpRequested）

F1キーまたはヘルプ要求時にHelpFormを表示。

1. HelpFormインスタンスを作成
2. タイトルでドキュメント開始
3. HelpParagraphsの各段落を出力
4. SimpleUI.ActivePage.TipProviderからツールチップ情報を取得・出力
5. HelpFormを表示

### 3-OK押下

DialogResult.OKでフォームを閉じる。呼び出し元でSimpleUI.Save()を実行。

### 4-Cancel押下

DialogResult.Cancelでフォームを閉じる。設定変更は破棄。

### 5-リサイズ（OnResize）

ウィンドウサイズ変更時のイベント。現在は処理なし（コメントアウト）。

## データベース更新仕様

本画面はデータベースを直接更新しない。設定値はSimpleUIコンポーネントを通じて呼び出し元に返される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | 本画面では特定のメッセージ表示なし | - |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| TipProviderがNull | HelpRequested内でNull参照チェック（Not ... Is Nothing） |

## 備考

- DialogBaseを継承
- SimpleUIコンポーネントでページ分割した設定が可能
- OKボタンはデフォルトボタン（AcceptButton）ではない
- CancelボタンはCancelButtonに設定済み
- テーマ変更に対応（ThemeManager）
- DPI対応（AutoScaleMode.Dpi）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SimpleSettingsFormはDialogBaseを継承し、SimpleUIコンポーネントを中心に構成される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | クラス定義（行5）とフィールド（行118） |
| 1-2 | SimpleUI.vb | `Source/UI/SimpleUI.vb` | SimpleUIクラスの構造を理解 |

**読解のコツ**: SimpleUIは動的にUIを構築するコンポーネント。FlowPage、NumBlock、TextBlock等のUI要素を提供する。

#### Step 2: エントリーポイントを理解する

コンストラクタがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | New()（行120-130）でフォーム初期化処理を確認 |

**主要処理フロー**:
1. **行121**: InitializeComponent()
2. **行122**: SetMinimumSize(33, 25)で最小サイズ
3. **行123**: ScaleClientSize(40, 32.75)でサイズ設定
4. **行124**: タイトルバー設定
5. **行125**: HelpParagraphs保存
6. **行126**: SimpleUI.Tree.Select()

#### Step 3: ヘルプ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | SimpleSettingsForm_HelpRequested（行157-172）でヘルプ表示処理を確認 |

**主要処理フロー**:
- **行158-159**: HelpFormを作成、ドキュメント開始
- **行161-165**: HelpParagraphsの各段落を出力
- **行167-169**: TipProviderからTipsを取得・出力
- **行171**: HelpFormを表示

### プログラム呼び出し階層図

```
SimpleSettingsForm (Source/Forms/SimpleSettingsForm.vb)
    │
    ├─ New(title, helpParagraphs) コンストラクタ
    │      ├─ InitializeComponent() ← デザイナー生成コード
    │      ├─ SetMinimumSize()
    │      ├─ ScaleClientSize()
    │      ├─ g.DefaultCommands.GetApplicationDetails()
    │      └─ ApplyTheme()
    │
    ├─ SimpleSettingsForm_HelpRequested()
    │      ├─ HelpForm.New()
    │      ├─ Doc.WriteStart()
    │      ├─ Doc.WriteParagraph()
    │      ├─ Doc.WriteTips()
    │      └─ form.Show()
    │
    └─ Dispose()
           └─ ThemeManager イベントハンドラ解除
```

### データフロー図

```
[入力]                [処理]                      [出力]

title ───▶ コンストラクタ ───▶ タイトルバー表示
                 │
                 ▼
helpParagraphs ───▶ HelpParagraphs保存 ───▶ HelpRequested時に出力
                 │
                 ▼
SimpleUI ───▶ 動的UI構築 ───▶ 設定画面表示
    │
    ▼
ユーザー入力 ───▶ SimpleUI.Save() ───▶ 設定値保存（呼び出し元で実行）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | ソース | 汎用設定フォーム本体 |
| SimpleSettingsForm.Designer.vb | `Source/Forms/SimpleSettingsForm.Designer.vb` | ソース | デザイナー生成コード |
| SimpleUI.vb | `Source/UI/SimpleUI.vb` | ソース | 動的UIコンポーネント |
| DialogBase.vb | `Source/Forms/DialogBase.vb` | ソース | ダイアログ基底クラス |
| HelpForm.vb | `Source/Forms/HelpForm.vb` | ソース | ヘルプ表示フォーム |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理機能 |
