# 画面設計書 14-MuxerForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるマルチプレクサ設定画面（MuxerForm）の設計仕様を記載する。動画・音声・字幕等のストリームを結合（マルチプレックス）するための設定を行う画面である。

### 本画面の処理概要

MuxerFormは、エンコード後の動画ファイル、音声ファイル、字幕ファイル等を単一のコンテナファイル（MKV、MP4等）に結合するための設定画面である。各種ストリームの追加・編集、字幕設定、チャプター設定、コンテナオプションの設定を行う。

**業務上の目的・背景**：動画エンコードでは、動画・音声・字幕を別々に処理した後、最終的に単一のコンテナファイルに結合する必要がある。本画面により、ユーザーはストリームの追加順序、言語設定、フォースドフラグ等を柔軟に設定し、最終出力ファイルを構成できる。

**画面へのアクセス方法**：メイン画面（MainForm）のContainerメニューから、またはMuxerプロファイル編集時に呼び出される。

**主要な操作・処理内容**：
1. 動画ストリームの設定
2. 音声ストリームの追加・編集・削除
3. 字幕ストリームの追加・編集・削除
4. チャプターファイルの指定
5. タグファイルの指定
6. 添付ファイルの追加
7. コンテナ固有オプションの設定
8. コマンドラインプレビュー

**画面遷移**：MainFormから遷移。字幕編集用のSubtitleControlダイアログ、MKV/MP4オプション用のSimpleSettingsFormへ遷移可能。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | マルチプレクサ | 主機能 | MKV/MP4等への多重化設定 |
| 30 | 出力先指定 | 補助機能 | 出力ファイルパス設定 |
| 35 | 字幕処理 | 補助機能 | 字幕ストリーム設定 |
| 36 | チャプター処理 | 補助機能 | チャプターファイル設定 |

## 画面種別

設定画面 / マルチプレクサ

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `MuxerForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| Muxer設定 | 入力 | Muxer | はい | マルチプレクサ設定オブジェクト |
| 動画ファイルパス | 入力 | String | いいえ | エンコード済み動画ファイル |
| 音声プロファイル | 入力 | List(Of AudioProfile) | いいえ | 音声ストリーム設定リスト |
| 字幕リスト | 入力 | List(Of Subtitle) | いいえ | 字幕ストリーム設定リスト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 動画トラック設定 | TextBox | 動画ファイルパス、名前、言語 |
| 音声トラックDataGridView | DataGridView | 音声ストリーム一覧（パス、言語、遅延、デフォルト、フォースド） |
| 字幕トラックDataGridView | DataGridView | 字幕ストリーム一覧 |
| チャプターファイル | TextBox | チャプターファイルパス |
| タグファイル | TextBox | タグファイルパス |
| オプションボタン | Button | コンテナ固有オプション（MKV/MP4） |
| コマンドラインプレビュー | TextBox | 生成されるコマンドライン |

## イベント仕様

### 1-フォーム初期化（New）

Muxer設定オブジェクトを受け取りUIを初期化。

1. Muxer設定のディープコピーを作成
2. DataGridViewの設定（チェックボックス列、テキスト列）
3. 動画トラック情報を表示
4. 音声・字幕リストをDataGridViewに反映
5. チャプター、タグ、出力先を設定
6. コマンドラインプレビューを更新
7. MKVオプション/MP4オプションボタンの表示制御

### 2-音声追加（bnAudioAdd_Click）

音声ストリームを追加。

1. ファイル選択ダイアログを表示
2. 選択されたファイルからAudioProfileを作成
3. DataGridViewに追加
4. コマンドラインプレビューを更新

### 3-音声編集（bnAudioEdit_Click）

選択された音声ストリームを編集。

1. 選択行のAudioProfileを取得
2. BatchAudioProfile/GUIAudioProfileに応じた編集ダイアログを表示
3. 変更を反映
4. コマンドラインプレビューを更新

### 4-音声削除（bnAudioRemove_Click）

選択された音声ストリームを削除。

1. 選択行を取得
2. 削除確認なしで削除
3. コマンドラインプレビューを更新

### 5-字幕追加（bnSubtitleAdd_Click）

字幕ストリームを追加。

1. ファイル選択ダイアログを表示（SUP/SRT/ASS/SSA/IDX/VTT/PGS）
2. 選択されたファイルからSubtitleオブジェクト作成
3. 言語自動検出
4. DataGridViewに追加

### 6-字幕編集（bnSubtitleEdit_Click）

選択された字幕ストリームを編集。SubtitleControlダイアログを表示。

### 7-字幕削除（bnSubtitleRemove_Click）

選択された字幕ストリームを削除。

### 8-チャプター設定（bnChapterBrowse_Click）

チャプターファイルを選択。OGG/TXT/XML形式に対応。

### 9-タグ設定（bnTagsBrowse_Click）

タグファイル（XML形式）を選択。

### 10-出力先設定（bnOutputPath_Click）

出力ファイルパスを選択。拡張子はMuxerによって固定。

### 11-MKVオプション（bnOptionsEdit_Click）

MKV固有オプションをSimpleSettingsFormで編集。

- Webm出力
- 動画タイムコードファイル
- セグメントUID

### 12-コマンドラインプレビュー更新

設定変更時に自動的にコマンドラインを再生成。

### 13-OK押下

設定を保存してダイアログを閉じる。EditModeがtrueの場合、元のMuxerオブジェクトを更新。

## データベース更新仕様

本画面はデータベースを使用しない。Muxer設定はプロジェクトオブジェクトとして管理される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-01 | 情報 | ヘルプ表示 | F1キー押下時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 無効なファイル形式 | ダイアログフィルタで制限 |
| ファイル読み込みエラー | ファイル存在チェック |

## 備考

- MKVマルチプレクサとMP4マルチプレクサで表示項目が異なる
- DataGridViewのセル編集で直接値変更可能
- ドラッグ&ドロップで行の並び替え可能
- EditModeによりプロファイル編集とプロジェクト編集を切り替え
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Muxerクラスとそのサブクラス、AudioProfile、Subtitleクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/Encoding/Muxer.vb` | Muxer抽象クラス、MkvMuxer、MP4Muxer等 |
| 1-2 | AudioProfile.vb | `Source/Encoding/AudioProfile.vb` | 音声プロファイルのデータ構造 |
| 1-3 | Subtitle.vb | `Source/General/Subtitle.vb` | 字幕データ構造 |

**読解のコツ**: MuxerはGetCommandLineメソッドでコマンドライン生成、EditModeプロパティで編集モード切替。

#### Step 2: エントリーポイントを理解する

MuxerFormのコンストラクタとLoadイベント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MuxerForm.vb | `Source/Forms/MuxerForm.vb` | New()でMuxer設定を受け取り、Loadイベントで初期化 |

**主要処理フロー**:
1. コンストラクタでMuxerのディープコピー作成
2. LoadイベントでDataGridView設定、初期値反映
3. 各コントロールにMuxer設定を反映

#### Step 3: DataGridView操作を理解する

音声・字幕のリスト操作。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MuxerForm.vb | `Source/Forms/MuxerForm.vb` | bnAudioAdd_Click, bnSubtitleAdd_Click等 |

**主要処理フロー**:
- 追加: ファイル選択 → オブジェクト作成 → DataGridView追加
- 編集: 行選択 → ダイアログ表示 → 変更反映
- 削除: 行選択 → 削除

### プログラム呼び出し階層図

```
MuxerForm (Source/Forms/MuxerForm.vb)
    │
    ├─ New(muxer) コンストラクタ
    │      ├─ ObjectHelp.GetCopy() ← ディープコピー
    │      └─ InitializeComponent()
    │
    ├─ MuxerForm_Load()
    │      ├─ DataGridView設定
    │      └─ 初期値反映
    │
    ├─ bnAudioAdd_Click()
    │      ├─ FileDialog表示
    │      └─ AudioProfile作成・追加
    │
    ├─ bnSubtitleAdd_Click()
    │      ├─ FileDialog表示
    │      └─ Subtitle作成・追加
    │
    ├─ bnOptionsEdit_Click()
    │      └─ SimpleSettingsForm表示
    │
    ├─ UpdateCommandLinePreview()
    │      └─ Muxer.GetCommandLine()
    │
    └─ OnFormClosing()
           └─ Muxer設定更新（EditMode時）
```

### データフロー図

```
[入力]                [処理]                      [出力]

Muxer設定 ───▶ ObjectHelp.GetCopy() ───▶ TempMuxer
                      │
                      ▼
ファイル選択 ───▶ AudioProfile作成 ───▶ dgvAudio
                      │
                      ▼
ファイル選択 ───▶ Subtitle作成 ───▶ dgvSubtitle
                      │
                      ▼
TempMuxer ───▶ GetCommandLine() ───▶ コマンドラインプレビュー
      │
      ▼
OK押下 ───▶ Muxer設定更新 ───▶ 元オブジェクトに反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | マルチプレクサ設定フォーム本体 |
| MuxerForm.Designer.vb | `Source/Forms/MuxerForm.Designer.vb` | ソース | デザイナー生成コード |
| Muxer.vb | `Source/Encoding/Muxer.vb` | ソース | Muxer抽象クラス・具象クラス |
| AudioProfile.vb | `Source/Encoding/AudioProfile.vb` | ソース | 音声プロファイル |
| Subtitle.vb | `Source/General/Subtitle.vb` | ソース | 字幕データクラス |
| SimpleSettingsForm.vb | `Source/Forms/SimpleSettingsForm.vb` | ソース | オプション設定ダイアログ |
| SubtitleControl.vb | `Source/Controls/SubtitleControl.vb` | ソース | 字幕編集コントロール |
