# 画面設計書 15-SourceFilesForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるソースファイル管理画面（SourceFilesForm）の設計仕様を記載する。複数のソースファイルを管理し、結合順序を設定するためのダイアログである。

### 本画面の処理概要

SourceFilesFormは、プロジェクトのソースファイルリストを管理するダイアログである。複数のソースファイルを追加・削除し、ドラッグ&ドロップで順序を変更できる。主にBlu-ray等のディスクメディアから複数ファイルを読み込む際に使用される。

**業務上の目的・背景**：Blu-ray等のディスクメディアは複数のm2tsファイルに分割されていることがあり、これらを正しい順序で結合してエンコードする必要がある。本画面により、ユーザーは複数のソースファイルを管理し、結合順序を視覚的に確認・変更できる。

**画面へのアクセス方法**：メイン画面（MainForm）のSourceセクションからの呼び出しや、ソースファイル読み込み時の追加ファイル選択で表示される。

**主要な操作・処理内容**：
1. ソースファイルの追加（Add...ボタン）
2. ソースファイルの削除（Remove...ボタン）
3. ドラッグ&ドロップによる順序変更
4. ソースファイルリストの確定

**画面遷移**：MainFormから遷移。本画面からの外部遷移はなし（モーダルダイアログ）。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | ファイル読み込み | 主機能 | 複数ソースファイルの管理 |
| 16 | ファイル結合 | 補助機能 | ソースファイルの結合順序設定 |

## 画面種別

一覧管理 / リスト編集ダイアログ

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `SourceFilesForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| ソースファイルリスト | 入出力 | List(Of String) | はい | 管理対象のソースファイルパスリスト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ファイルリストボックス（lb） | ListBox | ソースファイル一覧（パス表示） |
| Add...ボタン | Button | ファイル追加 |
| Remove...ボタン | Button | ファイル削除 |
| OKボタン | Button | DialogResult.OK |
| Cancelボタン | Button | DialogResult.Cancel |

## イベント仕様

### 1-フォーム初期化（New）

ソースファイルリストを受け取りUIを初期化。

1. InitializeComponent()でUI構築
2. ScaleClientSize(30, 15)でウィンドウサイズ設定
3. タイトルバーにアプリケーション名を表示
4. 受け取ったファイルリストをリストボックスに設定
5. ListBoxEx.EnableDragAndDropReorderでドラッグ&ドロップ有効化
6. テーマ適用

### 2-ファイル追加（bnAdd_Click）

新しいソースファイルを追加。

1. OpenFileDialogを表示
2. 対応形式でフィルタリング（動画ファイル全般）
3. 複数選択を許可
4. 選択されたファイルをリストボックスに追加

### 3-ファイル削除（bnRemove_Click）

選択されたソースファイルを削除。

1. 選択項目を取得
2. 確認なしで削除
3. リストボックスを更新

### 4-ドラッグ&ドロップ（ListBoxEx）

リストボックス内でアイテムをドラッグして順序変更。

1. ListBoxEx.EnableDragAndDropReorderで自動有効化
2. マウスドラッグでアイテム位置を移動
3. ドロップ位置にアイテムを挿入

### 5-OK押下

ファイルリストを確定してダイアログを閉じる。

1. リストボックスの内容をFilePathsプロパティに設定
2. DialogResult.OKを設定
3. フォームを閉じる

### 6-Cancel押下

変更を破棄してダイアログを閉じる。

## データベース更新仕様

本画面はデータベースを使用しない。ソースファイルリストはプロジェクトオブジェクトとして管理される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | 本画面では特定のメッセージ表示なし | - |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 空のファイルリスト | リストボックスが空の状態で表示 |
| 無効なファイルパス | ダイアログフィルタで制限 |

## 備考

- ListBoxExコンポーネントを使用（ドラッグ&ドロップ対応）
- ファイルパスはフルパスで表示・管理
- 複数ファイル選択対応
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファイルパスのリストとしてシンプルな構造。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | FilePathsプロパティ（行100-104）でデータ構造を理解 |

**読解のコツ**: List(Of String)でファイルパスを管理。リストボックスのItemsと連動。

#### Step 2: エントリーポイントを理解する

コンストラクタがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | New(paths)（行101-109）でフォーム初期化を確認 |

**主要処理フロー**:
1. **行102**: InitializeComponent()
2. **行103**: ScaleClientSize(30, 15)
3. **行104**: タイトルバー設定
4. **行105-106**: ファイルリストをリストボックスに設定
5. **行107**: EnableDragAndDropReorderでドラッグ&ドロップ有効化
6. **行108**: テーマ適用

#### Step 3: 追加・削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | bnAdd_Click, bnRemove_Clickでリスト操作を確認 |

**主要処理フロー**:
- 追加: OpenFileDialogで選択 → lb.Items.Add
- 削除: 選択項目取得 → lb.Items.Remove

### プログラム呼び出し階層図

```
SourceFilesForm (Source/Forms/SourceFilesForm.vb)
    │
    ├─ New(paths) コンストラクタ
    │      ├─ InitializeComponent()
    │      ├─ ScaleClientSize(30, 15)
    │      ├─ lb.Items.AddRange(paths)
    │      └─ lb.EnableDragAndDropReorder()
    │
    ├─ bnAdd_Click()
    │      ├─ OpenFileDialog.ShowDialog()
    │      └─ lb.Items.Add()
    │
    ├─ bnRemove_Click()
    │      └─ lb.Items.Remove()
    │
    └─ FilePaths Property
           └─ lb.Items → List(Of String)
```

### データフロー図

```
[入力]                [処理]                      [出力]

paths (List) ───▶ リストボックス表示 ───▶ lb.Items
                        │
                        ▼
OpenFileDialog ───▶ ファイル追加 ───▶ lb.Items更新
                        │
                        ▼
選択項目 ───▶ ファイル削除 ───▶ lb.Items更新
                        │
                        ▼
ドラッグ&ドロップ ───▶ 順序変更 ───▶ lb.Items更新
                        │
                        ▼
OK押下 ───▶ FilePaths Property ───▶ 呼び出し元に返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | ソース | ソースファイル管理フォーム本体 |
| SourceFilesForm.Designer.vb | `Source/Forms/SourceFilesForm.Designer.vb` | ソース | デザイナー生成コード |
| ListBoxEx.vb | `Source/UI/ListBoxEx.vb` | ソース | 拡張リストボックス（ドラッグ&ドロップ対応） |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理機能 |
