# 画面設計書 16-StreamDemuxForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるストリームデマックス画面（StreamDemuxForm）の設計仕様を記載する。ソースファイルから音声・字幕・添付ファイルを抽出するための設定ダイアログである。

### 本画面の処理概要

StreamDemuxFormは、メディアファイルに含まれる音声ストリーム、字幕ストリーム、添付ファイル（フォント等）を個別に抽出（デマックス）するための設定ダイアログである。MediaInfo を使用してソースファイルのストリーム情報を取得し、抽出対象を選択できる。

**業務上の目的・背景**：コンテナファイル（MKV、MP4等）には複数の音声トラック、字幕トラック、添付ファイルが含まれることがある。エンコード処理では必要なストリームのみを抽出して再利用することが多い。本画面により、ユーザーはストリームを視覚的に選択し、必要なものだけをデマックスできる。

**画面へのアクセス方法**：メイン画面（MainForm）のAudio/Subtitleセクションからのデマックス操作、またはプロジェクト読み込み時に自動表示される場合がある。

**主要な操作・処理内容**：
1. 音声ストリームの選択（チェックボックス）
2. 字幕ストリームの選択（チェックボックス）
3. 添付ファイルの選択（チェックボックス）
4. 一括選択（All/None/English/Native言語）
5. チャプターデマックスのON/OFF
6. 動画ストリームデマックスのON/OFF

**画面遷移**：MainFormから遷移。本画面からの外部遷移はなし（モーダルダイアログ）。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | デマルチプレクス | 主機能 | ストリーム抽出設定 |
| 20 | 音声抽出 | 補助機能 | 音声ストリームの選択・抽出 |
| 21 | 字幕抽出 | 補助機能 | 字幕ストリームの選択・抽出 |

## 画面種別

選択ダイアログ / デマックス設定

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `StreamDemuxForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| ソースファイル | 入力 | String | はい | 解析対象のソースファイルパス |
| 添付ファイルリスト | 入力 | List(Of Attachment) | いいえ | 添付ファイル情報 |
| 音声ストリームリスト | 出力 | List(Of AudioStream) | - | 選択された音声ストリーム |
| 字幕リスト | 出力 | List(Of Subtitle) | - | 選択された字幕ストリーム |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 音声リストビュー（lvAudio） | ListViewEx | 音声ストリーム一覧（チェックボックス付き） |
| 字幕リストビュー（lvSubtitles） | ListViewEx | 字幕ストリーム一覧（チェックボックス付き） |
| 添付ファイルリストビュー（lvAttachments） | ListViewEx | 添付ファイル一覧（チェックボックス付き） |
| 音声選択ボタン群 | Button | All / None / English / Native |
| 字幕選択ボタン群 | Button | All / None / English / Native |
| 添付ファイル選択ボタン群 | Button | All / None |
| チャプターデマックスチェック | CheckBox | チャプター抽出の有無 |
| 動画デマックスチェック | CheckBox | 動画ストリーム抽出の有無 |
| OK/Cancelボタン | Button | 確定/キャンセル |

## イベント仕様

### 1-フォーム初期化（New）

ソースファイルと添付ファイルリストを受け取り初期化。

1. InitializeComponent()でUI構築
2. ScaleClientSize(42, 30)でウィンドウサイズ設定
3. Owner = g.MainFormで親フォーム設定
4. 各ListViewExの設定（View, CheckBoxes, HeaderStyle等）
5. MediaInfo.GetAudioStreams/GetSubtitlesで情報取得
6. 言語ボタンの有効/無効設定（英語/ネイティブ言語の有無）
7. リストビューにストリーム情報を表示
8. チェックボックスの初期値設定（p.DemuxChapters, p.DemuxVideo）
9. テーマ適用

### 2-音声ストリーム選択変更（lvAudio_ItemChecked）

チェックボックス変更時にAudioStream.Enabledを更新。

### 3-字幕ストリーム選択変更（lvSubtitles_ItemChecked）

チェックボックス変更時にSubtitle.Enabledを更新。

### 4-添付ファイル選択変更（lvAttachments_ItemChecked）

チェックボックス変更時にAttachment.Enabledを更新。

### 5-音声一括選択（All/None/English/Native）

- bnAudioAll_Click: 全音声を選択
- bnAudioNone_Click: 全音声を解除
- bnAudioEnglish_Click: 英語音声のみ選択
- bnAudioNative_Click: ネイティブ言語（システム言語）音声のみ選択

### 6-字幕一括選択（All/None/English/Native）

- bnSubtitleAll_Click: 全字幕を選択
- bnSubtitleNone_Click: 全字幕を解除
- bnSubtitleEnglish_Click: 英語字幕のみ選択
- bnSubtitleNative_Click: ネイティブ言語字幕のみ選択

### 7-添付ファイル一括選択（All/None）

- bnAllAttachments_Click: 全添付ファイルを選択
- bnNoneAttachments_Click: 全添付ファイルを解除

### 8-結果取得（AudioStreams/Subtitles プロパティ）

チェック済みアイテムからリストを生成して返却。

## データベース更新仕様

本画面はデータベースを使用しない。ストリーム設定はプロジェクトオブジェクトとして管理される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | 本画面では特定のメッセージ表示なし | - |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ソースファイルにストリームなし | 空のリストビューを表示 |
| MediaInfo解析エラー | 空のリストを返却 |

## 備考

- MediaInfo を使用してストリーム情報を取得
- ネイティブ言語ボタンは英語以外のシステム言語の場合のみ表示
- ListViewExはAutoCheckMode.SingleClickに設定（シングルクリックでチェック切り替え）
- 各ストリームのEnabledプロパティで選択状態を管理
- テーマ変更に対応（ThemeManager）
- HideFocusRectange()でフォーカス矩形を非表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AudioStream、Subtitle、Attachmentクラスの構造を理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | AudioStreams/Subtitlesプロパティ（行10-20）でデータ取得方法を理解 |
| 1-2 | AudioStream.vb | `Source/General/AudioStream.vb` | AudioStreamクラスの構造 |
| 1-3 | Subtitle.vb | `Source/General/Subtitle.vb` | Subtitleクラスの構造 |

**読解のコツ**: 各ストリームクラスはLanguage、Enabled、Name等のプロパティを持つ。

#### Step 2: エントリーポイントを理解する

コンストラクタがエントリーポイント。MediaInfoでストリーム取得。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | New()（行22-93）でフォーム初期化を確認 |

**主要処理フロー**:
1. **行22-26**: InitializeComponent, サイズ設定, 親フォーム設定
2. **行28-37**: lvAudio ListViewExの設定
3. **行39-43**: lvSubtitles ListViewExの設定
4. **行45-49**: lvAttachments ListViewExの設定
5. **行53-54**: MediaInfoでストリーム取得
6. **行56-64**: 言語ボタンの有効/無効設定
7. **行66-85**: リストビューにアイテム追加
8. **行87-88**: チェックボックス初期値
9. **行90**: テーマ適用

#### Step 3: 一括選択処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | bnAudioAll_Click等（行135-210）で一括選択処理を確認 |

**主要処理フロー**:
- All: ForEachで全アイテムをChecked = True
- None: ForEachで全アイテムをChecked = False
- English: TwoLetterCode = "en"のアイテムをChecked = True
- Native: TwoLetterCode = CultureInfo.CurrentCultureのアイテムをChecked = True

### プログラム呼び出し階層図

```
StreamDemuxForm (Source/Forms/StreamDemuxForm.vb)
    │
    ├─ New(sourceFile, attachments) コンストラクタ
    │      ├─ InitializeComponent()
    │      ├─ MediaInfo.GetAudioStreams()
    │      ├─ MediaInfo.GetSubtitles()
    │      └─ lvAudio/lvSubtitles/lvAttachments.Items.Add()
    │
    ├─ AudioStreams Property (ReadOnly)
    │      └─ lvAudio.Items → AudioStream List
    │
    ├─ Subtitles Property (ReadOnly)
    │      └─ lvSubtitles.Items → Subtitle List
    │
    ├─ lvAudio_ItemChecked()
    │      └─ AudioStream.Enabled = Checked
    │
    ├─ lvSubtitles_ItemChecked()
    │      └─ Subtitle.Enabled = Checked
    │
    ├─ bnAudioAll_Click() / bnAudioNone_Click()
    │      └─ ForEach item.Checked = True/False
    │
    └─ bnAudioEnglish_Click() / bnAudioNative_Click()
           └─ ForEach Language.TwoLetterCode判定
```

### データフロー図

```
[入力]                     [処理]                      [出力]

sourceFile ───▶ MediaInfo.GetAudioStreams() ───▶ _audioStreams
                            │
                            ▼
sourceFile ───▶ MediaInfo.GetSubtitles() ───▶ _subtitles
                            │
                            ▼
_audioStreams ───▶ lvAudio.Items.Add() ───▶ リストビュー表示
                            │
                            ▼
_subtitles ───▶ lvSubtitles.Items.Add() ───▶ リストビュー表示
                            │
                            ▼
チェック操作 ───▶ Enabled更新 ───▶ ストリームオブジェクト更新
                            │
                            ▼
OK押下 ───▶ AudioStreams/Subtitles ───▶ 選択済みリスト返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamDemuxForm.vb | `Source/Forms/StreamDemuxForm.vb` | ソース | デマックスフォーム本体 |
| StreamDemuxForm.Designer.vb | `Source/Forms/StreamDemuxForm.Designer.vb` | ソース | デザイナー生成コード |
| AudioStream.vb | `Source/General/AudioStream.vb` | ソース | 音声ストリームデータクラス |
| Subtitle.vb | `Source/General/Subtitle.vb` | ソース | 字幕データクラス |
| Attachment.vb | `Source/General/Attachment.vb` | ソース | 添付ファイルデータクラス |
| MediaInfo.vb | `Source/MediaInfo/MediaInfo.vb` | ソース | メディア情報取得ユーティリティ |
| ListViewEx.vb | `Source/UI/ListViewEx.vb` | ソース | 拡張リストビュー |
