# 画面設計書 17-eac3toForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるeac3toデマックス画面（eac3toForm）の設計仕様を記載する。eac3toツールを使用してBlu-ray等からストリームをデマックスするための詳細設定ダイアログである。

### 本画面の処理概要

eac3toFormは、eac3toコマンドラインツールを使用してBlu-rayディスクやM2TSファイルから動画・音声・字幕ストリームを抽出するための設定ダイアログである。各ストリームの出力形式、オプション設定を詳細に指定できる。

**業務上の目的・背景**：Blu-rayディスクは複雑なストリーム構成を持ち、eac3toは高品質なデマックスが可能な専門ツールである。DTS-HD MA、TrueHD等のロスレス音声コーデックのデコード・変換に対応しており、本画面ではストリームごとの出力形式とオプションを細かく設定できる。

**画面へのアクセス方法**：メイン画面（MainForm）からBlu-rayソースを読み込む際に、eac3toによるデマックスを選択した場合に表示される。

**主要な操作・処理内容**：
1. M2TSファイルまたはプレイリストの解析（バックグラウンド処理）
2. 動画ストリームの出力形式選択（H264/H265/MKV/VC1/M2V/Nothing）
3. 音声ストリームの選択と出力形式設定
4. 字幕ストリームの選択
5. チャプター抽出のON/OFF
6. 出力先ディレクトリの指定
7. 音声出力オプションの設定（コマンドラインプリセット）

**画面遷移**：MainFormから遷移。Audio Stream Profiles編集用のDataFormへ遷移可能。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | デマルチプレクス | 主機能 | eac3toによるストリーム抽出 |
| 22 | Blu-ray処理 | 補助機能 | Blu-rayディスク/プレイリスト解析 |
| 20 | 音声抽出 | 補助機能 | 音声ストリーム出力設定 |

## 画面種別

詳細設定ダイアログ / デマックス

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `eac3toForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| M2TSファイル | 入力 | String | いいえ | M2TSファイルパス（M2TSFile） |
| プレイリストフォルダ | 入力 | String | いいえ | プレイリストのあるフォルダ（PlaylistFolder） |
| プレイリストID | 入力 | Integer | いいえ | 選択されたプレイリスト番号 |
| 出力フォルダ | 入力 | String | はい | デマックス出力先ディレクトリ |
| ストリーム情報 | 出力 | BindingList(Of M2TSStream) | - | 解析されたストリーム一覧 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 動画出力形式（cbVideoOutput） | ComboBox | H264/H265/MKV/VC1/M2V/Nothing |
| 動画ストリーム選択（cbVideoStream） | ComboBox | 動画ストリーム選択 |
| 音声リストビュー（lvAudio） | ListViewEx | 音声ストリーム一覧（チェックボックス付き） |
| 音声出力形式（cbAudioOutput） | ComboBox | m4a/ac3/dts/flac/pcm/wav/dtsma/dtshr/eac3/thd |
| オプション入力（cmdlOptions） | CommandLineControl | 音声オプションコマンドライン |
| 字幕リストビュー（lvSubtitles） | ListViewEx | 字幕ストリーム一覧 |
| チャプター抽出（cbChapters） | CheckBox | チャプター抽出の有無 |
| 出力先ディレクトリ（teTempDir） | TextEdit | 出力先パス |
| メニューボタン（bnMenu） | ButtonEx | Audio Stream Profiles等のメニュー |
| OK/Cancelボタン | Button | 確定/キャンセル |

## イベント仕様

### 1-フォーム初期化（New）

Projectオブジェクトを受け取り初期化。解析はOnShownで開始。

1. InitializeComponent()でUI構築
2. RestoreClientSize(40, 30)でサイズ復元
3. コンボボックスに出力形式リストを設定
4. ListViewExの設定（チェックボックス、詳細表示等）
5. CommandLineControlにプリセットを設定
6. 言語ボタンの初期化（非表示）
7. コンテキストメニューの設定
8. テーマ適用

### 2-解析開始（OnShown → StartAnalyze）

フォーム表示後にバックグラウンドで解析を実行。

1. Task.Run(AddressOf StartAnalyze)でバックグラウンド開始
2. eac3to.exeを起動し出力を解析
3. OutputDataReceivedでプログレス表示
4. 解析完了後、BeginInvoke(Sub() Init())でUI更新

### 3-ストリーム情報初期化（Init）

eac3to出力を解析してストリーム情報を構築。

1. 出力テキストをパース
2. M2TSStreamオブジェクトを作成（ID, Codec, IsVideo, IsAudio, IsSubtitle等）
3. 言語情報、出力タイプを自動設定
4. Audio Stream Profilesによるマッチング適用
5. ListViewに追加
6. ComboBoxの初期選択

### 4-動画出力形式変更（cbVideoStream_SelectedIndexChanged）

動画ストリーム選択時に対応出力形式リストを更新。

- h264/AVC → H264, MKV
- h265/HEVC → H265
- VC-1 → MKV, VC1
- MPEG2 → M2V, MKV

### 5-音声ストリーム選択変更（lvAudio_SelectedIndexChanged）

音声ストリーム選択時にオプションコントロールを更新。

### 6-音声出力形式変更（cbAudioOutput_SelectedIndexChanged）

音声出力形式変更時にM2TSStream.OutputTypeを更新。DTS→dts選択時は-coreオプション自動付加。

### 7-オプション変更（cmdlOptions_ValueChanged）

音声オプション変更時にM2TSStream.Optionsを更新。

### 8-出力先参照（bnBrowse_Click）

FolderBrowserDialogで出力先を選択。

### 9-コマンドライン引数生成（GetArgs）

デマックス実行用のコマンドライン引数を生成。

### 10-フォームクローズ（OnFormClosing）

設定の保存と検証。

1. HD音声選択の確認
2. CmdlPresetsEac3toの保存
3. cbChapters設定の保存
4. MKV出力時のHaaliパッケージ確認

## データベース更新仕様

本画面はデータベースを使用しない。設定はアプリケーション設定（s.Storage）に保存。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-01 | エラー | eac3to failed with error code {code} | eac3to実行エラー時 |
| MSG-02 | 警告 | eac3to output was empty | 解析出力が空の場合 |
| MSG-03 | エラー | 3D demuxing isn't supported. | 3D映像検出時 |
| MSG-04 | エラー | Failed to detect stream: {line} | ストリーム種別判定失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| eac3to実行エラー | MsgErrorでエラー表示、フォームキャンセル |
| ストリーム検出エラー | Exceptionをスロー |
| 3D映像 | MsgErrorでエラー表示、フォームキャンセル |

## 備考

- SizeSavingDialogBaseを継承（サイズ保存対応）
- eac3toパッケージが必要（Package.eac3to.Path）
- 音声出力形式: m4a, ac3, dts, flac, pcm, wav, dtsma, dtshr, eac3, thd
- DTS Master Audio/DTS Hi-Resから-coreオプションでDTSコア抽出可能
- Audio Stream Profilesで出力形式・オプションの自動マッチング設定
- テーマ変更に対応（ThemeManager）
- プログレス表示（analyze: xx%）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

M2TSStreamクラスがストリーム情報の基本単位。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Streamsプロパティ（行583）でBindingList(Of M2TSStream)を理解 |
| 1-2 | M2TSStream.vb | `Source/General/M2TSStream.vb` | ID, Codec, OutputType, Options等のプロパティ |

**読解のコツ**: M2TSStreamはID（トラック番号）、Codec、OutputType（出力形式）、Options（コマンドラインオプション）を保持。

#### Step 2: エントリーポイントを理解する

コンストラクタとOnShownがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | New()（行590-653）、OnShown()（行1240-1243） |

**主要処理フロー**:
1. **行590-653**: コンストラクタでUI初期化、コンボボックス・リストビュー設定
2. **行1240-1243**: OnShownでTask.Run(StartAnalyze)
3. **行726-759**: StartAnalyzeでeac3to実行、出力解析

#### Step 3: ストリーム解析処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | eac3toForm.vb | `Source/Forms/eac3toForm.vb` | Init()（行780-961）でeac3to出力のパース処理を確認 |

**主要処理フロー**:
- **行816-842**: 各行をパースしM2TSStreamオブジェクト作成
- **行861-893**: Codecに応じた出力タイプ自動設定
- **行895-906**: Audio Stream Profilesによるマッチング
- **行918-936**: ListViewに追加

### プログラム呼び出し階層図

```
eac3toForm (Source/Forms/eac3toForm.vb)
    │
    ├─ New(proj) コンストラクタ
    │      ├─ InitializeComponent()
    │      ├─ cbAudioOutput.Items.AddRange() ← 出力形式リスト
    │      └─ cms.Items.Add() ← コンテキストメニュー
    │
    ├─ OnShown()
    │      └─ Task.Run(AddressOf StartAnalyze)
    │
    ├─ StartAnalyze()
    │      ├─ Process.Start() ← eac3to.exe
    │      ├─ OutputDataReceived() ← 進捗表示
    │      └─ BeginInvoke(Init)
    │
    ├─ Init()
    │      ├─ Output.SplitLinesNoEmpty() ← 出力パース
    │      ├─ M2TSStream作成
    │      ├─ Profile マッチング
    │      └─ lvAudio/lvSubtitles.Items.Add()
    │
    └─ GetArgs()
           └─ コマンドライン引数生成
```

### データフロー図

```
[入力]                       [処理]                      [出力]

M2TSFile/PlaylistFolder ───▶ eac3to.exe実行 ───▶ 標準出力
                                   │
                                   ▼
標準出力 ───▶ OutputDataReceived() ───▶ Output変数蓄積
                                   │
                                   ▼
Output ───▶ Regex.Match解析 ───▶ M2TSStreamリスト
                                   │
                                   ▼
M2TSStream ───▶ Profile適用 ───▶ OutputType/Options設定
      │
      ▼
UI操作 ───▶ GetArgs() ───▶ コマンドライン引数
      │
      ▼
OK押下 ───▶ s.Storage保存 ───▶ 設定永続化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| eac3toForm.vb | `Source/Forms/eac3toForm.vb` | ソース | eac3toデマックスフォーム本体 |
| eac3toForm.Designer.vb | `Source/Forms/eac3toForm.Designer.vb` | ソース | デザイナー生成コード |
| M2TSStream.vb | `Source/General/M2TSStream.vb` | ソース | M2TSストリームデータクラス |
| eac3toProfile.vb | `Source/General/eac3toProfile.vb` | ソース | Audio Stream Profile設定 |
| CommandLineControl.vb | `Source/Controls/CommandLineControl.vb` | ソース | コマンドラインプリセットコントロール |
| Package.vb | `Source/General/Package.vb` | ソース | eac3toパッケージ情報（Path） |
| DataForm.vb | `Source/Forms/DataForm.vb` | ソース | Audio Stream Profiles編集ダイアログ |
