# 画面設計書 18-CommandLineForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるコマンドライン設定画面（CommandLineForm）の設計仕様を記載する。動画エンコーダ（x265, x264, AV1等）のコマンドラインオプションを詳細に設定するための画面である。

### 本画面の処理概要

CommandLineFormは、動画エンコーダのコマンドラインパラメータを視覚的に設定するための画面である。SimpleUIコンポーネントを使用して、各パラメータをチェックボックス、ドロップダウン、数値入力等のUI要素として動的に生成する。設定変更はリアルタイムでコマンドラインプレビューに反映される。

**業務上の目的・背景**：動画エンコーダは多数のコマンドラインオプションを持ち、直接コマンドライン文字列を編集するのは困難である。本画面は各オプションを分類・整理し、視覚的なUIで設定できるようにすることで、ユーザーが最適なエンコード設定を行えるようにする。また、検索機能により目的のオプションを素早く見つけられる。

**画面へのアクセス方法**：メイン画面（MainForm）のEncoderセクションでx265、x264、AV1等の動画エンコーダを選択し、設定ボタンをクリックすると表示される。

**主要な操作・処理内容**：
1. ページ切り替えによるオプションカテゴリの選択
2. 各種パラメータの設定（Bool, Number, Option, String）
3. コマンドラインプレビューのリアルタイム更新
4. 検索機能によるオプション検索
5. コマンドラインの実行
6. コマンドラインのコピー/インポート
7. ヘルプ表示

**画面遷移**：MainFormから遷移。HelpFormへF1キーで遷移可能。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | x265エンコード | 主機能 | x265パラメータ設定 |
| 24 | x264エンコード | 主機能 | x264パラメータ設定 |
| 25 | AV1エンコード | 主機能 | AV1(SVT-AV1/rav1e等)パラメータ設定 |
| 26 | NVEncエンコード | 主機能 | NVEncパラメータ設定 |
| 27 | QSVEncエンコード | 主機能 | QSVEncパラメータ設定 |
| 28 | VCEEncエンコード | 主機能 | VCEEncパラメータ設定 |

## 画面種別

詳細設定画面 / パラメータ設定

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `CommandLineForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| CommandLineParams | 入力 | CommandLineParams | はい | エンコーダのパラメータ定義オブジェクト |
| コマンドライン | 出力 | String | - | 生成されたコマンドライン文字列 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| SimpleUI | SimpleUI | 動的設定UIコンポーネント（ページ分割） |
| コマンドラインプレビュー（rtbCommandLine） | CommandLineRichTextBox | リアルタイムコマンドライン表示 |
| 検索ドロップダウン（cbGoTo） | ComboBox | オプション検索用 |
| メニューボタン | Button | コンテキストメニュー表示 |

## イベント仕様

### 1-フォーム初期化（New）

CommandLineParamsオブジェクトを受け取りUIを動的生成。

1. InitializeComponent()でUI構築
2. ScaleClientSize(50, 30)でサイズ設定
3. rtbCommandLineの設定（スクロールバー無効、コンテキストメニュー）
4. Params.Itemsをループしてキー重複チェック
5. タイトルバーに「{エンコーダ名} ({オプション数} options) - {アプリ詳細}」
6. InitUI()でSimpleUIにパラメータUI要素を生成
7. SelectLastPage()で前回選択ページを復元
8. ValueChangedイベントハンドラ登録
9. コンテキストメニュー設定（Execute, Copy, Show, Import等）
10. テーマ適用

### 2-UI生成（InitUI）

Params.ItemsをループしてSimpleUI要素を生成。

1. パラメータ種別ごとに適切なUI要素を生成
   - BoolParam → CheckBox
   - NumParam → NumEdit
   - OptionParam → MenuButton
   - StringParam → TextEdit
2. ヘルプ情報（Switch, HelpSwitch, NoSwitch）を設定
3. Itemsリストに登録（検索用）

### 3-値変更（ValueChanged）

パラメータ値変更時にコマンドラインを再生成。

1. rtbCommandLine.SetText(Params.GetCommandLine)
2. rtbCommandLine.UpdateHeight()
3. 検索コンボボックスを更新

### 4-検索機能（cbGoTo_TextChanged）

入力テキストに基づいてオプションを検索・ハイライト。

1. 2文字以上で検索開始
2. Switch, NoSwitch, HelpSwitch, Help, Text, Optionsを検索対象
3. 一致するパラメータのページを表示
4. コントロールをボールドフォントでハイライト
5. Enterキーで次のマッチへ移動

### 5-コマンドライン実行（Execute Command Line）

Ctrl+Eで実行。Params.Execute()を呼び出し。

### 6-コマンドラインコピー（Copy Command Line）

Ctrl+Shift+Cで実行。クリップボードにコマンドラインをコピー。

### 7-コマンドラインプレビュー（Show Command Line...）

F4で実行。g.ShowCommandLinePreviewでプレビューダイアログを表示。

### 8-コマンドラインインポート（Import Command Line...）

Ctrl+Iで実行。クリップボードからコマンドラインをインポート。

### 9-ハイライト切り替え（Command Line Highlighting）

Ctrl+Hで実行。コマンドラインのシンタックスハイライトを切り替え。

### 10-プレビューマウスアップ検索（Preview Mouse-Up Search）

Ctrl+Pで設定。プレビュー内のオプションをクリックで検索へジャンプ。

### 11-プレビュー右クリック（rtbCommandLine_MouseUp）

プレビュー内で右クリック時のコンテキストメニュー表示。選択テキストのコピー、オプション検索。

### 12-フォームクローズ（OnFormClosed）

ページ選択状態を保存、ValueChangedイベントハンドラ解除。

## データベース更新仕様

本画面はデータベースを使用しない。パラメータ設定はCommandLineParamsオブジェクトとして管理される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-01 | 情報 | Command Line was copied. | コマンドラインコピー時 |
| MSG-02 | 確認 | Import command line from clipboard? | コマンドラインインポート時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| パラメータキー重複 | 警告（コメントアウト、デバッグ用） |
| 空の検索 | 何もしない |

## 備考

- SimpleUIでFlowPage（タブページ）を使用した分類表示
- 数値・ドロップダウンラベルダブルクリックでデフォルト値に戻す
- CommandLineRichTextBoxでシンタックスハイライト
- 検索はSwitch/Help/Options/Valuesを対象
- s.CommandLineHighlightingでハイライト設定を永続化
- s.CommandLinePreviewMouseUpSearchでマウスアップ検索設定を永続化
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CommandLineParamsとCommandLineParamサブクラスを理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommandLineParams.vb | `Source/Encoding/CommandLineParams.vb` | Items、GetCommandLine、Title等 |
| 1-2 | CommandLineParam.vb | `Source/Encoding/CommandLineParam.vb` | BoolParam、NumParam、OptionParam、StringParam |

**読解のコツ**: CommandLineParamsは複数のCommandLineParamを持ち、各ParamがSwitch、Value、Pathを持つ。

#### Step 2: エントリーポイントを理解する

コンストラクタとInitUIがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | New()（行21-96）でフォーム初期化、InitUI()（行132-318）でUI生成 |

**主要処理フロー**:
1. **行21-42**: コンストラクタでParams設定、タイトル設定
2. **行42**: InitUI()呼び出し
3. **行132-318**: InitUIでParams.Itemsループ、UI要素生成

#### Step 3: パラメータUI生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | InitUI内の種別判定（行205-308）でUI要素生成を確認 |

**主要処理フロー**:
- **行208-221**: BoolParam → SimpleUI.AddBool
- **行222-245**: NumParam → SimpleUI.AddNum
- **行247-278**: OptionParam → SimpleUI.AddMenu
- **行279-307**: StringParam → SimpleUI.AddText/AddTextButton/AddTextMenu

### プログラム呼び出し階層図

```
CommandLineForm (Source/Forms/CommandLineForm.vb)
    │
    ├─ New(params) コンストラクタ
    │      ├─ InitializeComponent()
    │      ├─ InitUI() ← UI要素生成
    │      ├─ SelectLastPage() ← ページ復元
    │      └─ cms.Add() ← メニュー設定
    │
    ├─ InitUI()
    │      ├─ SimpleUI.GetFlowPage() ← ページ取得
    │      ├─ SimpleUI.AddBool/AddNum/AddMenu/AddText()
    │      └─ Items.Add() ← 検索用リスト
    │
    ├─ ValueChanged(item)
    │      ├─ rtbCommandLine.SetText()
    │      └─ UpdateSearchComboBox()
    │
    ├─ cbGoTo_TextChanged()
    │      ├─ 検索処理
    │      ├─ SimpleUI.ShowPage()
    │      └─ ハイライト表示
    │
    └─ OnFormClosed()
           └─ SimpleUI.SaveLast()
```

### データフロー図

```
[入力]                     [処理]                      [出力]

CommandLineParams ───▶ InitUI() ───▶ SimpleUI要素群
                             │
                             ▼
                      Param.InitParam() ───▶ UI-パラメータバインド
                             │
                             ▼
UI操作 ───▶ ValueChanged ───▶ GetCommandLine() ───▶ rtbCommandLine
                             │
                             ▼
検索入力 ───▶ cbGoTo_TextChanged ───▶ ハイライト表示
                             │
                             ▼
OK押下 ───▶ Params更新済み ───▶ 呼び出し元に反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineForm.vb | `Source/Forms/CommandLineForm.vb` | ソース | コマンドラインフォーム本体 |
| CommandLineForm.Designer.vb | `Source/Forms/CommandLineForm.Designer.vb` | ソース | デザイナー生成コード |
| CommandLineParams.vb | `Source/Encoding/CommandLineParams.vb` | ソース | パラメータ定義基底クラス |
| CommandLineParam.vb | `Source/Encoding/CommandLineParam.vb` | ソース | 個別パラメータクラス群 |
| x265.vb | `Source/Encoding/x265.vb` | ソース | x265パラメータ定義 |
| x264.vb | `Source/Encoding/x264.vb` | ソース | x264パラメータ定義 |
| SimpleUI.vb | `Source/UI/SimpleUI.vb` | ソース | 動的UIコンポーネント |
| CommandLineRichTextBox.vb | `Source/UI/CommandLineRichTextBox.vb` | ソース | シンタックスハイライト付きRTB |
