# 画面設計書 19-CommandLineVideoEncoderForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるコマンドライン動画エンコーダ設定画面（CommandLineVideoEncoderForm）の設計仕様を記載する。バッチエンコーダ用のカスタムコマンドラインを設定するための画面である。

### 本画面の処理概要

CommandLineVideoEncoderFormは、カスタム動画エンコーダ（BatchEncoder）のコマンドラインを設定するための画面である。エンコードコマンドライン、圧縮率チェック用コマンドライン、出力ファイル形式、品質モード等を設定できる。マクロ機能を使用したコマンドライン記述が可能。

**業務上の目的・背景**：StaxRipは多くの動画エンコーダをサポートしているが、ユーザーが独自のエンコーダを使用したい場合や、特殊なコマンドラインオプションを使用したい場合がある。本画面により、任意のコマンドラインベースエンコーダを統合し、マクロ展開による柔軟なコマンドライン生成が可能となる。

**画面へのアクセス方法**：メイン画面（MainForm）のEncoderセクションで「Command Line」タイプの動画エンコーダを選択し、設定ボタンをクリックすると表示される。

**主要な操作・処理内容**：
1. 出力ファイル形式の指定（mp4, mkv等）
2. 品質モードのON/OFF設定
3. 目標品質パーセンテージの設定
4. エンコードコマンドラインの編集（マクロ対応）
5. 圧縮率チェック用コマンドラインの編集

**画面遷移**：MainFormから遷移。本画面からの外部遷移はなし（モーダルダイアログ）。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | カスタムエンコード | 主機能 | カスタムコマンドライン動画エンコード |
| 42 | 圧縮率チェック | 補助機能 | 圧縮率チェック用コマンドライン設定 |

## 画面種別

設定画面 / コマンドライン編集

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `CommandLineVideoEncoderForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| BatchEncoder | 入力 | BatchEncoder | はい | バッチエンコーダ設定オブジェクト |
| OutputExt | 入出力 | String | はい | 出力ファイル拡張子 |
| QualityMode | 入出力 | Boolean | いいえ | 品質モードフラグ |
| CommandLines | 入出力 | String | はい | エンコードコマンドライン |
| CompCheckCommandLines | 入出力 | String | いいえ | 圧縮率チェック用コマンドライン |
| AutoCompCheckValue | 入出力 | Integer | いいえ | 目標品質パーセンテージ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 出力ファイル形式（tbType） | TextEdit | 出力拡張子（例：mp4） |
| 品質モード（cbQualityMode） | CheckBox | 品質モードON/OFF |
| 目標品質（numPercent） | NumEdit | 目標品質パーセンテージ（0-200%） |
| 目標品質ラベル（laPercent） | Label | 「Aimed Quality (%):」 |
| コマンドライン編集（EncodingControl） | MacroEditorControl | エンコードコマンドライン |
| 圧縮率チェック編集（CompCheckControl） | MacroEditorControl | 圧縮率チェックコマンドライン |
| OK/Cancelボタン | Button | 確定/キャンセル |

## イベント仕様

### 1-フォーム初期化（New）

BatchEncoderオブジェクトを受け取り初期化。

1. InitializeComponent()でUI構築
2. RestoreClientSize(50, 22)でサイズ復元
3. Encoderプロパティに参照を保存
4. cbQualityMode.Checked = encoder.QualityMode
5. tbType.Text = encoder.OutputExt
6. EncodingControl.SetCommandLineDefaults()
7. EncodingControl.Value = encoder.CommandLines
8. CompCheckControl.SetCommandLineDefaults()
9. CompCheckControl.Value = encoder.CompCheckCommandLines
10. numPercent.Value = encoder.AutoCompCheckValue
11. TipProviderでツールチップ設定
12. テーマ適用

### 2-品質モード変更（cbQualityMode_CheckedChanged）

品質モードON/OFF時のUI表示切替。

1. 品質モードONの場合：
   - CompCheckControlを非表示
   - laPercent, numPercentを非表示
   - tlpMain.RowStyles(2).Height = 0
2. 品質モードOFFの場合：
   - CompCheckControlを表示
   - laPercent, numPercentを表示
   - tlpMain.RowStyles(2).Height = 50

### 3-フォームクローズ（OnFormClosed）

DialogResult.OKの場合、設定をEncoderに保存。

1. Encoder.OutputFileTypeValue = tbType.Text
2. Encoder.CommandLines = EncodingControl.Value
3. Encoder.CompCheckCommandLines = CompCheckControl.Value
4. Encoder.QualityMode = cbQualityMode.Checked
5. Encoder.AutoCompCheckValue = CInt(numPercent.Value)

## データベース更新仕様

本画面はデータベースを使用しない。設定はBatchEncoderオブジェクトに保存される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | 本画面では特定のメッセージ表示なし | - |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 空のコマンドライン | バリデーションなし（空文字許可） |

## 備考

- DialogBaseを継承
- MacroEditorControlでマクロ展開対応のコマンドライン編集
- 品質モードON時は圧縮率チェックコントロールを非表示
- numPercent.Maximumは200%に設定
- numPercent.Incrementは5に設定
- TipProviderで「Adjusts the target file size or image size after the compressibility check accordingly.」のツールチップ表示
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BatchEncoderクラスがカスタム動画エンコーダの設定を保持。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BatchEncoder.vb | `Source/Encoding/BatchEncoder.vb` | CommandLines、CompCheckCommandLines、QualityMode等のプロパティ |

**読解のコツ**: BatchEncoderはVideoEncoderを継承し、コマンドライン文字列でエンコードを実行する。マクロ展開はMacro.Expandで行われる。

#### Step 2: エントリーポイントを理解する

コンストラクタがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineVideoEncoderForm.vb | `Source/Forms/CommandLineVideoEncoderForm.vb` | New()（行214-235）でフォーム初期化を確認 |

**主要処理フロー**:
1. **行215-217**: InitializeComponent、サイズ復元、Encoder参照保存
2. **行220-222**: cbQualityMode、tbType設定
3. **行224-225**: EncodingControl設定
4. **行227-228**: CompCheckControl設定
5. **行230**: numPercent設定
6. **行232**: TipProvider設定

#### Step 3: 品質モード切替を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineVideoEncoderForm.vb | `Source/Forms/CommandLineVideoEncoderForm.vb` | cbQualityMode_CheckedChanged（行269-283）でUI切替を確認 |

**主要処理フロー**:
- **行272-273**: 品質モードONならRowHeight = 0
- **行274-275**: 品質モードOFFならRowHeight = 50
- **行278**: CompCheckControl.Visible設定
- **行281-282**: laPercent、numPercent.Visible設定

### プログラム呼び出し階層図

```
CommandLineVideoEncoderForm (Source/Forms/CommandLineVideoEncoderForm.vb)
    │
    ├─ New(encoder) コンストラクタ
    │      ├─ InitializeComponent()
    │      ├─ RestoreClientSize(50, 22)
    │      ├─ EncodingControl.SetCommandLineDefaults()
    │      ├─ CompCheckControl.SetCommandLineDefaults()
    │      └─ TipProvider.SetTip()
    │
    ├─ cbQualityMode_CheckedChanged()
    │      ├─ tlpMain.RowStyles(2).Height設定
    │      ├─ CompCheckControl.Visible設定
    │      └─ laPercent/numPercent.Visible設定
    │
    └─ OnFormClosed()
           └─ Encoder.プロパティ更新
```

### データフロー図

```
[入力]                     [処理]                      [出力]

BatchEncoder ───▶ コンストラクタ ───▶ UIコントロール反映
                        │
                        ▼
tbType入力 ───▶ TextEdit.Text ───▶ 出力拡張子
                        │
                        ▼
EncodingControl入力 ───▶ MacroEditorControl ───▶ コマンドライン
                        │
                        ▼
cbQualityMode ───▶ UI表示切替 ───▶ CompCheckControl表示/非表示
                        │
                        ▼
OK押下 ───▶ OnFormClosed ───▶ Encoder更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineVideoEncoderForm.vb | `Source/Forms/CommandLineVideoEncoderForm.vb` | ソース | 動画エンコーダフォーム本体 |
| CommandLineVideoEncoderForm.Designer.vb | `Source/Forms/CommandLineVideoEncoderForm.Designer.vb` | ソース | デザイナー生成コード |
| BatchEncoder.vb | `Source/Encoding/BatchEncoder.vb` | ソース | バッチエンコーダクラス |
| MacroEditorControl.vb | `Source/Controls/MacroEditorControl.vb` | ソース | マクロ対応コマンドラインエディタ |
| DialogBase.vb | `Source/Forms/DialogBase.vb` | ソース | ダイアログ基底クラス |
| TipProvider.vb | `Source/UI/TipProvider.vb` | ソース | ツールチップ管理 |
