# 画面設計書: PreviewForm（プレビュー画面）

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 2 |
| 画面名 | PreviewForm |
| 画面名（日本語） | プレビュー画面 |
| ソースファイル | `Source/Forms/PreviewForm.vb` |
| 継承元クラス | DialogBase |
| 画面種別 | モーダレスダイアログ |

## 2. 画面概要

動画のプレビューおよびカット編集機能を提供するダイアログ。フレーム単位でのナビゲーション、カット範囲の設定・削除、フルスクリーン表示、画像保存など、動画編集に必要な機能を備える。複数インスタンスを同時に開いてフィルター比較も可能。

## 3. 画面レイアウト

### 3.1 レイアウト構成

```
+------------------------------------------------------------------+
| pnVideo（ビデオ表示パネル）                                       |
|                                                                    |
|                    [動画プレビュー表示領域]                        |
|                                                                    |
|                                                                    |
+------------------------------------------------------------------+
| pnTrack（トラックバー）                                            |
+------------------------------------------------------------------+
| [<<] [<10] [<1] [start] [end] [>1] [>10] [>>] [del] [menu]        |
| bnLeft3 bnLeft2 bnLeft1 bnStart bnEnd bnRight1 bnRight2 bnRight3  |
+------------------------------------------------------------------+
```

### 3.2 主要コントロール一覧

| コントロール名 | 種類 | 説明 |
|--------------|------|------|
| pnVideo | Panel | 動画表示パネル（Dock=Fill） |
| pnTrack | Panel | タイムライントラックバー |
| bnLeft3 | ButtonEx | 100フレーム後退ボタン |
| bnLeft2 | ButtonEx | 10フレーム後退ボタン |
| bnLeft1 | ButtonEx | 1フレーム後退ボタン |
| bnStartCutRange | ButtonEx | カット範囲開始設定ボタン |
| bnEndCutRange | ButtonEx | カット範囲終了設定ボタン |
| bnRight1 | ButtonEx | 1フレーム前進ボタン |
| bnRight2 | ButtonEx | 10フレーム前進ボタン |
| bnRight3 | ButtonEx | 100フレーム前進ボタン |
| bnDelete | ButtonEx | カット範囲削除ボタン |
| bnMenu | ButtonEx | メニュー表示ボタン |
| cmsMain | ContextMenuStripEx | コンテキストメニュー |
| ToolTip | ToolTip | ツールチップ表示 |

## 4. 機能仕様

### 4.1 画面機能一覧

| 機能ID | 機能名 | 説明 |
|--------|--------|------|
| F001 | フレーム表示 | 指定フレームの動画を表示 |
| F002 | フレームナビゲーション | 1/10/100/1000フレーム単位での移動 |
| F003 | カット範囲設定 | 保持したい範囲の開始/終了設定 |
| F004 | カット範囲削除 | 設定したカット範囲の削除 |
| F005 | 全カット範囲クリア | すべてのカット範囲をクリア |
| F006 | 範囲分割 | 現在位置でカット範囲を分割 |
| F007 | フルスクリーン切替 | ウィンドウ/フルスクリーン切替 |
| F008 | ズーム | 表示サイズの拡大/縮小 |
| F009 | フレーム位置ジャンプ | 指定フレーム/時間へジャンプ |
| F010 | チャプターへジャンプ | チャプター位置へジャンプ |
| F011 | 画像保存 | 現在フレームをBMP/PNG/JPG保存 |
| F012 | 外部プレイヤー再生 | mpv.net/MPCで動画を再生 |
| F013 | 情報表示切替 | プレビュー情報の表示/非表示 |
| F014 | リロード | プレビュースクリプトの再読み込み |
| F015 | 複数選択ジョブ作成 | 各選択範囲から個別ジョブを作成 |

### 4.2 イベント処理

| イベント | 処理内容 |
|---------|---------|
| bnLeft1_Click | 1フレーム後退 |
| bnLeft2_Click | 10フレーム後退 |
| bnLeft3_Click | 100フレーム後退 |
| bnRight1_Click | 1フレーム前進 |
| bnRight2_Click | 10フレーム前進 |
| bnRight3_Click | 100フレーム前進 |
| bnStartCutRange_Click | カット範囲開始位置設定 |
| bnEndCutRange_Click | カット範囲終了位置設定 |
| bnDelete_Click | 現在位置を含むカット範囲削除 |
| bnMenu_Click | コンテキストメニュー表示 |
| pnTrack_MouseDown | トラックバーでの位置指定 |
| pnTrack_Paint | トラックバーの描画（カット範囲表示含む） |
| pnVideo_DoubleClick | フルスクリーン切替 |
| OnMouseWheel | マウスホイールでフレーム移動 |

### 4.3 キーボードショートカット

| キー | 機能 |
|------|------|
| Left | 1フレーム後退 |
| Right | 1フレーム前進 |
| Up | 10フレーム後退 |
| Down | 10フレーム前進 |
| PageUp | 100フレーム後退 |
| PageDown | 100フレーム前進 |
| Home | カット範囲開始設定 |
| End | カット範囲終了設定 |
| Delete | カット範囲削除 |
| Enter | フルスクリーン切替 |
| G | フレーム指定ダイアログ |
| T | 時間指定ダイアログ |
| C | チャプター選択ダイアログ |
| S | 範囲分割 |
| I | 情報表示切替 |
| R | リロード |
| B | ボタン表示/非表示 |
| Ctrl+S | ビットマップ保存 |
| Ctrl+P | PNG保存 |
| F1 | ヘルプ |
| F9 | mpv.netで再生 |
| F10 | MPCで再生 |
| Escape | 閉じる |

### 4.4 コンテキストメニュー構成

GenericMenuによるカスタマイズ可能なメニュー構成：
- Navigation（ナビゲーション）
- Cut（カット）
- View（表示）
- Tools（ツール）
- Edit Menu...（メニュー編集）
- Help...（ヘルプ）
- Exit（終了）

## 5. データバインディング

### 5.1 関連データ

| データ項目 | バインド先 | 説明 |
|-----------|-----------|------|
| PreviewScript | Renderer | プレビュー用スクリプト |
| p.Ranges | pnTrack描画 | カット範囲リスト |
| s.LastPosition | Renderer.Position | 最後の表示位置 |
| s.ShowPreviewInfo | Renderer.ShowInfo | 情報表示フラグ |
| s.HidePreviewButtons | ボタン表示 | ボタン非表示フラグ |

## 6. 画面遷移

### 6.1 遷移元

| 遷移元 | トリガー |
|--------|---------|
| MainForm | プレビューメニュー/ショートカット |

### 6.2 遷移先

| 遷移先 | トリガー | 条件 |
|--------|---------|------|
| HelpForm | F1キー/ヘルプメニュー | - |
| JobsForm | ジョブ作成後 | 複数選択ジョブ作成時 |

## 7. 内部クラス・メソッド

### 7.1 主要プロパティ

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| Instances | List(Of PreviewForm) | 開いているインスタンス一覧（共有） |
| FrameServer | IFrameServer | フレーム取得サーバー |
| Renderer | VideoRenderer | 動画レンダラー |
| StartRange | Integer | カット範囲開始位置 |
| EndRange | Integer | カット範囲終了位置 |
| VideoSize | Size | 動画サイズ |

### 7.2 主要メソッド

| メソッド | 説明 |
|---------|------|
| Open() | プレビュースクリプトを開く |
| Reload() | スクリプトをリロード |
| SetPos() | 指定フレームに移動 |
| SetAbsolutePos() | 絶対位置に移動 |
| SetRelativePos() | 相対位置に移動 |
| SetRangeStart() | カット範囲開始設定 |
| SetRangeEnd() | カット範囲終了設定 |
| DeleteRange() | カット範囲削除 |
| MergeRanges() | カット範囲のマージ |
| Fullscreen() | フルスクリーン表示 |
| NormalScreen() | 通常表示 |
| SaveBitmap()/SavePng()/SaveJPG() | 画像保存 |

## 8. バリデーション

| 項目 | ルール | エラーメッセージ |
|------|--------|----------------|
| スクリプト | 有効なスクリプト | Script Error: [エラー内容] |
| フレーム位置 | 0 <= pos < FrameCount | （範囲外は無視） |
| チャプターファイル | 存在確認 | No chapter file found. |

## 9. 非機能要件

### 9.1 パフォーマンス

- フレーム表示: リアルタイム応答
- マウスホイール操作: 即座に反映

### 9.2 UI/UX

- DPIスケーリング対応（AutoScaleMode.Dpi）
- マウスドラッグでウィンドウ移動
- アスペクト比維持リサイズ
- 複数インスタンス対応（フィルター比較用）
- マウスホイールでのフレーム移動

## 10. コードリーディングガイド

### 10.1 関連ファイル一覧

| ファイル | 役割 |
|---------|------|
| `Source/Forms/PreviewForm.vb` | プレビューフォーム実装（行1-1305） |
| `Source/UI/DialogBase.vb` | 基底ダイアログクラス |
| `Source/FrameServer.vb` | フレームサーバーインターフェース |
| `Source/VideoRenderer.vb` | 動画レンダラー |
| `Source/VideoScript.vb` | ビデオスクリプト |
| `Source/Project.vb` | プロジェクト（p.Ranges） |
| `Source/Settings.vb` | 設定（s.LastPosition等） |

### 10.2 プログラム呼び出し階層図

```
PreviewForm (DialogBase)
├── New(script As VideoScript) [行253-285]
│   ├── InitializeComponent() [行31-231]
│   ├── CommandManager設定
│   └── GenericMenu構築
├── OnLoad() [行297-301]
│   └── Open(True)
├── Open(initSize As Boolean) [行303-346]
│   ├── PreviewScript.Synchronize()
│   ├── FrameServerFactory.Create()
│   ├── VideoRenderer作成
│   └── SetSize()
├── ナビゲーション処理
│   ├── SetPos() [行564-571]
│   │   └── Renderer.Position設定
│   ├── SetAbsolutePos() [行586-588]
│   └── SetRelativePos() [行591-596]
├── カット処理
│   ├── SetRangeStart() [行652-670]
│   ├── SetRangeEnd() [行673-691]
│   ├── DeleteRange() [行757-765]
│   └── MergeRanges() [行1037-1054]
├── 描画処理
│   ├── pnTrack_Paint() [行493-558]
│   └── pnVideo_Paint() [行1296-1304]
└── OnFormClosing() [行1183-1194]
    └── クリーンアップ処理
```

### 10.3 データフロー図

```
[VideoScript]
     │
     ▼
[FrameServerFactory.Create()]
     │
     ▼
[IFrameServer] ──► [VideoRenderer] ──► [pnVideo描画]
     │
     ▼
[フレーム情報]
     │
     ├──► [トラックバー描画]
     │
     └──► [タイトル更新]

[ユーザー操作]
     │
     ├──► [ナビゲーション] ──► SetPos() ──► Renderer更新
     │
     └──► [カット操作] ──► p.Ranges更新 ──► トラックバー更新
```

### 10.4 読み解きの推奨順序

1. **データ構造の理解**: `VideoScript`, `IFrameServer`, `VideoRenderer`の関係
2. **エントリーポイント**: コンストラクタ `New(script)` [行253]
3. **初期化処理**: `Open()` メソッド [行303]
4. **ナビゲーション処理**: `SetPos()`, `SetAbsolutePos()`, `SetRelativePos()`
5. **カット処理**: `SetRangeStart()`, `SetRangeEnd()`, `MergeRanges()`
6. **描画処理**: `pnTrack_Paint()`, `pnVideo_Paint()`
7. **メニュー構築**: `GetDefaultMenu()` [行978-1035]
