# 画面設計書 20-CommandLineAudioEncoderForm

## 概要

本ドキュメントはStaxRipアプリケーションにおけるコマンドライン音声エンコーダ設定画面（CommandLineAudioEncoderForm）の設計仕様を記載する。バッチ音声エンコーダ用のカスタムコマンドラインと音声プロファイル設定を行う画面である。

### 本画面の処理概要

CommandLineAudioEncoderFormは、カスタム音声エンコーダ（BatchAudioProfile）のコマンドラインと各種設定を行う画面である。入力ファイル形式、出力形式、ビットレート、遅延、言語、トラック名等の音声メタデータと、エンコードコマンドラインを設定できる。マクロ機能を使用したコマンドライン記述が可能。

**業務上の目的・背景**：StaxRipは多くの音声エンコーダをサポートしているが、ユーザーが独自のエンコーダを使用したい場合や、特殊な設定が必要な場合がある。本画面により、任意のコマンドラインベース音声エンコーダを統合し、マクロ展開による柔軟なコマンドライン生成とメタデータ設定が可能となる。

**画面へのアクセス方法**：メイン画面（MainForm）のAudioセクションで「Command Line」タイプの音声プロファイルを選択し、設定ボタンをクリックすると表示される。または音声プロファイルの新規作成時に表示。

**主要な操作・処理内容**：
1. 対応入力ファイル形式の設定
2. 出力ファイル形式の設定
3. 言語の選択
4. ビットレート、チャンネル数、遅延の設定
5. トラック名の設定
6. プロファイル名の設定
7. Default/Forced/Commentaryフラグの設定
8. エンコードコマンドラインの編集（マクロ対応）
9. プロファイルの保存

**画面遷移**：MainFormから遷移。HelpFormへF1キーまたはHelpメニューで遷移可能。

**権限による表示制御**：特になし。すべてのユーザーが同一の機能を使用可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | カスタム音声エンコード | 主機能 | カスタムコマンドライン音声エンコード |
| 31 | 音声プロファイル | 補助機能 | 音声プロファイル設定・保存 |

## 画面種別

設定画面 / コマンドライン編集

## URL/ルーティング

Windows Forms アプリケーションのため、該当なし（フォームクラス: `CommandLineAudioEncoderForm`）

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| BatchAudioProfile | 入力 | BatchAudioProfile | はい | バッチ音声プロファイル設定オブジェクト |
| SupportedInput | 入出力 | String[] | いいえ | 対応入力ファイル形式リスト |
| OutputFileType | 入出力 | String | はい | 出力ファイル拡張子 |
| CommandLines | 入出力 | String | はい | エンコードコマンドライン |
| Bitrate | 入出力 | Integer | はい | ビットレート（kbps） |
| Channels | 入出力 | Integer | はい | チャンネル数 |
| Delay | 入出力 | Integer | いいえ | 遅延（ミリ秒） |
| StreamName | 入出力 | String | いいえ | トラック名 |
| Language | 入出力 | Language | いいえ | 言語 |
| Name | 入出力 | String | いいえ | プロファイル名 |
| Default | 入出力 | Boolean | いいえ | デフォルトトラックフラグ |
| Forced | 入出力 | Boolean | いいえ | フォーストラックフラグ |
| Commentary | 入出力 | Boolean | いいえ | コメンタリーフラグ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 入力形式（tbInput） | TextEdit | 対応入力ファイル形式（スペース区切り） |
| 出力形式（tbType） | TextEdit | 出力ファイル拡張子 |
| 言語（mbLanguage） | MenuButton | 言語選択ドロップダウン |
| ビットレート（tbBitrate） | TextEdit | ビットレート（kbps） |
| チャンネル数（tbChannels） | TextEdit | チャンネル数 |
| 遅延（tbDelay） | TextEdit | 遅延（ミリ秒） |
| トラック名（tbStreamName） | TextEdit | トラック名 |
| プロファイル名（tbProfileName） | TextEdit | プロファイル名（空の場合自動生成） |
| デフォルト（cbDefault） | CheckBox | デフォルトトラック |
| フォース（cbForced） | CheckBox | フォーストラック |
| コメンタリー（cbCommentary） | CheckBox | コメンタリートラック |
| コマンドライン（EditControl） | MacroEditorControl | エンコードコマンドライン |
| メニューボタン（bnMenu） | ButtonEx | Copy/Show/Save/Helpメニュー |
| OK/Cancelボタン | Button | 確定/キャンセル |

## イベント仕様

### 1-フォーム初期化（New）

BatchAudioProfileオブジェクトを受け取り初期化。

1. InitializeComponent()でUI構築
2. RestoreClientSize(50, 30)でサイズ復元
3. Profileプロパティに参照を保存
4. TempProfile = ObjectHelp.GetCopyでディープコピー作成
5. tbType.Text = TempProfile.OutputFileType
6. tbInput.Text = TempProfile.SupportedInput.Join(" ")
7. tbProfileName設定（DefaultNameと異なる場合のみ表示）
8. EditControl.SetCommandLineDefaults()
9. EditControl.Value = TempProfile.CommandLines
10. EditControl.SpecialMacrosFunction設定
11. tbEditTextChangedハンドラ登録
12. 各テキストボックスに値を設定
13. チェックボックスに値を設定
14. TipProviderでツールチップ設定
15. コンテキストメニュー設定
16. テーマ適用

### 2-言語選択表示（Shown）

フォーム表示後に言語メニューを構築。

1. g.PopulateLanguages(mbLanguage)で言語リスト設定
2. mbLanguage.Value = TempProfile.Language

### 3-テキスト変更イベント群

各テキストボックス変更時にTempProfileを更新。

- tbInput_TextChanged: SupportedInput更新
- tbType_TextChanged: OutputFileType更新
- tbBitrate_TextChanged: Bitrate更新
- tbChannels_TextChanged: Channels更新
- tbDelay_TextChanged: Delay更新
- tbStreamName_TextChanged: StreamName更新
- tbProfileName_TextChanged: Name更新
- tbEditTextChanged: CommandLines更新

### 4-言語変更（mbLanguage_ValueChangedUser）

言語選択変更時にTempProfile.Languageを更新。

### 5-チェックボックス変更

- cbDefault_CheckedChanged: TempProfile.Default更新
- cbForced_CheckedChanged: TempProfile.Forced更新
- cbCommentary_CheckedChanged: TempProfile.Commentary更新

### 6-プロファイル保存（SaveProfile）

メニューから「Save Profile...」選択時。

1. InputBoxでプロファイル名入力
2. TempProfileをコピー
3. s.AudioProfiles.Add(gap)
4. g.SaveAudioProfiles()
5. MsgInfo("The profile was saved.")

### 7-ヘルプ表示（ShowHelp）

F1またはHelpメニュー選択時。

1. HelpFormを作成
2. ダイアログタイトル、概要を出力
3. TipProviderからツールチップ情報を出力
4. マクロ一覧（Macro.GetTips）を出力

### 8-フォームクローズ（FormClosed）

DialogResult.OKの場合、TempProfileからProfileに設定を反映。

## データベース更新仕様

本画面はデータベースを使用しない。プロファイル保存はs.AudioProfiles（アプリケーション設定）に保存。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-01 | 情報 | The profile was saved. | プロファイル保存成功時 |
| MSG-02 | 入力 | Enter the profile name | プロファイル保存時の名前入力 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 無効なビットレート | ValidationProviderで数値パターン検証（^[1-9]+\\d*$） |
| 無効な遅延値 | ValidationProviderで数値パターン検証（^(-?[1-9]+\\d*|-?0)$） |
| 無効なチャンネル数 | ValidationProviderで数値パターン検証（^[1-9]{1}$） |

## 備考

- SizeSavingDialogBaseを継承（サイズ保存対応）
- ValidationProviderで入力値検証（Bitrate、Delay、Channels）
- TempProfileを使用した一時編集（Cancel時に破棄）
- EditControl.SpecialMacrosFunctionでマクロプレビュー用展開関数を設定
- tbProfileNameが空の場合、DefaultNameがCue（プレースホルダ）として表示
- 利用可能マクロ: %channels%、%language_native%、%language_english%、%bitrate%、%delay%
- テーマ変更に対応（ThemeManager）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BatchAudioProfileクラスがカスタム音声プロファイルの設定を保持。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BatchAudioProfile.vb | `Source/Encoding/BatchAudioProfile.vb` | CommandLines、SupportedInput、OutputFileType等のプロパティ |
| 1-2 | AudioProfile.vb | `Source/Encoding/AudioProfile.vb` | 音声プロファイル基底クラス |

**読解のコツ**: BatchAudioProfileはAudioProfileを継承し、コマンドライン文字列でエンコードを実行。ExpandMacrosでマクロ展開。

#### Step 2: エントリーポイントを理解する

コンストラクタとShownがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineAudioEncoderForm.vb | `Source/Forms/CommandLineAudioEncoderForm.vb` | New()（行447-499）でフォーム初期化、Shown（行614-618）で言語設定 |

**主要処理フロー**:
1. **行448-452**: InitializeComponent、サイズ復元、Profile/TempProfile設定
2. **行453-460**: tbType、tbInput、tbProfileName設定
3. **行462-466**: EditControl設定、TextChangedハンドラ
4. **行468-474**: 各テキストボックス・チェックボックス設定
5. **行480-489**: TipProvider設定
6. **行490-493**: コンテキストメニュー設定
7. **行614-618**: Shownで言語メニュー構築

#### Step 3: 値更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineAudioEncoderForm.vb | `Source/Forms/CommandLineAudioEncoderForm.vb` | tb*_TextChangedハンドラ群（行552-594）でTempProfile更新を確認 |

**主要処理フロー**:
- 各tb*_TextChangedでTempProfile.プロパティ更新
- EditControl.UpdatePreview()でプレビュー更新

### プログラム呼び出し階層図

```
CommandLineAudioEncoderForm (Source/Forms/CommandLineAudioEncoderForm.vb)
    │
    ├─ New(profile) コンストラクタ
    │      ├─ InitializeComponent()
    │      ├─ ObjectHelp.GetCopy() ← TempProfile作成
    │      ├─ EditControl.SetCommandLineDefaults()
    │      ├─ TipProvider.SetTip()
    │      └─ cms.Add() ← メニュー設定
    │
    ├─ Shown()
    │      ├─ g.PopulateLanguages()
    │      └─ mbLanguage.Value設定
    │
    ├─ tb*_TextChanged()
    │      ├─ TempProfile.プロパティ更新
    │      └─ EditControl.UpdatePreview()
    │
    ├─ SaveProfile()
    │      ├─ InputBox.Show()
    │      ├─ s.AudioProfiles.Add()
    │      └─ g.SaveAudioProfiles()
    │
    ├─ ShowHelp()
    │      ├─ HelpForm.New()
    │      ├─ TipProvider.GetTips()
    │      └─ Macro.GetTips()
    │
    └─ FormClosed()
           └─ Profile.プロパティ ← TempProfile反映
```

### データフロー図

```
[入力]                     [処理]                      [出力]

BatchAudioProfile ───▶ ObjectHelp.GetCopy() ───▶ TempProfile
                              │
                              ▼
テキスト入力 ───▶ tb*_TextChanged ───▶ TempProfile更新
                              │
                              ▼
EditControl入力 ───▶ tbEditTextChanged ───▶ TempProfile.CommandLines更新
                              │
                              ▼
SpecialMacrosFunction ───▶ ExpandMacros() ───▶ プレビュー表示
                              │
                              ▼
OK押下 ───▶ FormClosed ───▶ Profile ← TempProfile

Save Profile ───▶ s.AudioProfiles.Add() ───▶ 設定ファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineAudioEncoderForm.vb | `Source/Forms/CommandLineAudioEncoderForm.vb` | ソース | 音声エンコーダフォーム本体 |
| CommandLineAudioEncoderForm.Designer.vb | `Source/Forms/CommandLineAudioEncoderForm.Designer.vb` | ソース | デザイナー生成コード |
| BatchAudioProfile.vb | `Source/Encoding/BatchAudioProfile.vb` | ソース | バッチ音声プロファイルクラス |
| AudioProfile.vb | `Source/Encoding/AudioProfile.vb` | ソース | 音声プロファイル基底クラス |
| MacroEditorControl.vb | `Source/Controls/MacroEditorControl.vb` | ソース | マクロ対応コマンドラインエディタ |
| Language.vb | `Source/General/Language.vb` | ソース | 言語データクラス |
| ValidationProvider.vb | `Source/UI/ValidationProvider.vb` | ソース | 入力値検証プロバイダ |
| TipProvider.vb | `Source/UI/TipProvider.vb` | ソース | ツールチップ管理 |
| Macro.vb | `Source/General/Macro.vb` | ソース | マクロ展開ユーティリティ |
