# 画面設計書 21-コマンドラインデマックス

## 概要

CommandLineDemuxFormは、コマンドラインベースのカスタムデマルチプレクサを設定するためのダイアログ画面です。外部ツールを使用した動画ファイルのデマックス（多重化解除）処理をカスタマイズできます。

### 本画面の処理概要

本画面は、ユーザーが独自のコマンドラインデマルチプレクサを定義・編集するための設定ダイアログを提供します。

**業務上の目的・背景**：動画エンコードワークフローにおいて、様々な形式のソースファイルから映像・音声・字幕などのストリームを分離（デマックス）する必要があります。StaxRipには標準でffmpeg、mkvextract、MP4Box等のデマクサが組み込まれていますが、ユーザーが独自のツール（DGIndex、D2V Witch等）を使用してカスタムデマックス処理を行いたい場合に、この画面で設定を行います。

**画面へのアクセス方法**：MainFormのメニューまたはPreprocessingControlから、デマクサ設定でコマンドラインデマクサを選択し、設定ボタンをクリックするとこの画面が表示されます。

**主要な操作・処理内容**：
1. デマクサ名の設定 - 使用するツール名を指定（DGIndex、D2V Witch等）
2. 入力ファイルタイプの設定 - 対応する入力ファイル拡張子を指定（mpg, vob, m2ts等）
3. 出力ファイルタイプの設定 - デマックス後の出力拡張子を指定（d2v等）
4. 入力フォーマットの設定 - 対応するビデオフォーマット（mpeg2, vc1, avc, hevc等）
5. ソースフィルタの設定 - AviSynth/VapourSynthのソースフィルタを指定
6. 実行コマンドの設定 - 実行する外部ツールのパスを指定
7. コマンドライン引数の設定 - ツールに渡す引数をマクロ付きで設定

**画面遷移**：
- 遷移元：MainForm（デマクサ設定）、PreprocessingControl
- 遷移先：MacrosForm（マクロ一覧参照）、HelpForm（ヘルプ表示）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コマンドラインデマックス設定 | 主機能 | カスタムデマクサの定義・編集 |
| 58 | マクロ機能 | 補助機能 | 引数設定でマクロ参照 |
| 72 | ヘルプ表示 | 遷移先機能 | ツールのヘルプ情報表示 |

## 画面種別

編集ダイアログ（モーダル）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`CommandLineDemuxForm`クラスとして実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| デマクサ名 | tbName | String | 入力 | Yes | デマクサの識別名（ツール名と一致させるとヘルプが利用可能） |
| 入力ファイルタイプ | tbInput | String | 入力 | Yes | 対応する入力拡張子（スペース区切り） |
| 出力ファイルタイプ | tbVideoOut | String | 入力 | Yes | 出力拡張子（単一） |
| 入力フォーマット | tbInputFormats | String | 入力 | No | 対応ビデオフォーマット（vc1 mpeg2 avc hevc等） |
| ソースフィルタ | tbSourceFilters | String | 入力 | No | AviSynth/VapourSynthソースフィルタ名 |
| コマンド | tbCommand | String | 入力 | Yes | 実行ファイルのパス |
| 引数 | tbArguments | String | 入力 | Yes | コマンドライン引数（マクロ使用可） |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| Demuxer Name: | ラベル + テキストボックス | デマクサ識別名 |
| Input File Types: | ラベル + テキストボックス | 入力拡張子一覧 |
| Output File Type: | ラベル + テキストボックス | 出力拡張子 |
| Input Formats: | ラベル + テキストボックス | 対応フォーマット |
| Source Filters: | ラベル + テキストボックス | ソースフィルタ |
| Command: | ラベル + テキストボックス + 参照ボタン | 実行コマンド |
| Arguments: | ラベル + テキストエリア + メニューボタン | コマンドライン引数 |

## イベント仕様

### 1-OKボタン押下

OKボタン（bnOK）をクリックすると、入力された設定がCommandLineDemuxerオブジェクトに保存され、ダイアログが閉じます。

**処理フロー**：
1. DialogResultをOKに設定
2. OnFormClosedで各テキストボックスの値をTargetオブジェクトに反映
3. 入力拡張子、フォーマット、ソースフィルタはスペース/カンマ/セミコロンで分割
4. フォーマット名は正規化（MPEG Video→mpeg2、VC-1→vc1）

### 2-Cancelボタン押下

Cancelボタン（bnCancel）をクリックすると、変更を保存せずにダイアログを閉じます。

### 3-参照ボタン押下

参照ボタン（bnBrowse）またはCommandテキストボックスのダブルクリックで、ファイル選択ダイアログを表示し、実行ファイルを選択できます。

### 4-Argumentsメニューボタン押下

Argumentsフィールド横のメニューボタンから以下の操作が可能：
- Macros: MacrosFormを表示してマクロ一覧を参照
- Help: デマクサ名に対応するパッケージのヘルプを表示

### 5-ヘルプリクエスト

F1キー押下またはヘルプリクエストで、TipProviderに設定されたツールチップ情報をHelpFormに表示します。

## データベース更新仕様

本画面はデータベースを使用しません。設定はメモリ上のCommandLineDemuxerオブジェクトに保存され、アプリケーション設定ファイルとして永続化されます。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 警告 | The demuxer name '{name}' does not match with the name of one of StaxRip's apps. StaxRip includes the following apps: {appList} | Helpメニューで該当パッケージが見つからない場合 |

## 例外処理

- **ファイル選択ダイアログのキャンセル**：参照ボタンでファイルを選択せずにキャンセルした場合、コマンドパスは変更されません
- **不正な入力値**：空の入力やスペースのみの入力は、SplitNoEmptyAndWhiteSpace関数で自動的にフィルタリングされます

## 備考

- デマクサ名をStaxRipに同梱されているパッケージ名と一致させると、Helpメニューからそのツールのヘルプを参照できます
- 引数にはマクロ（%source_file%、%temp_file%、%app_path:ToolName%等）が使用可能
- テーマ機能に対応しており、ThemeManagerの変更イベントを監視して背景色を更新します

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CommandLineDemuxFormが操作する対象データ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Demux.vb | `Source/General/Demux.vb` | CommandLineDemuxerクラス（111-179行目）の構造を理解する。Command、Arguments、各種Extensions等のプロパティ定義 |
| 1-2 | Demux.vb | `Source/General/Demux.vb` | 基底クラスDemuxer（7-108行目）のインターフェースを確認。ShowConfigDialog()がオーバーライドされる点に注目 |

**読解のコツ**: VB.NETのPropertyキーワードで定義されたプロパティがフォームの入力項目と対応しています。

#### Step 2: エントリーポイントを理解する

フォームの生成と初期化処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | コンストラクタ（329-350行目）でCommandLineDemuxerの値をフォームにマッピング |

**主要処理フロー**:
1. **334行目**: ObjectHelpでCommandLineDemuxerのコピーを作成（編集用）
2. **336-342行目**: 各テキストボックスにデマクサの現在値を設定
3. **343行目**: 引数テキストボックスを複数行モードに設定
4. **347行目**: テーマを適用

#### Step 3: UI定義を理解する

デザイナーコードでUIレイアウトを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | InitializeComponent（35-321行目）でTableLayoutPanelによるレイアウト構成を確認 |

**主要処理フロー**:
- **145-182行目**: TableLayoutPanelの8行3列構成
- **196-211行目**: ArgumentsのContextMenuStripにMacros/Helpメニューを設定

#### Step 4: 保存処理を理解する

フォームクローズ時の保存処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | OnFormClosed（386-398行目）でDialogResult.OKの場合のみTargetに値を反映 |

**主要処理フロー**:
- **388行目**: デマクサ名を設定
- **389行目**: 入力拡張子をスペース/カンマ/セミコロンで分割して配列化
- **390行目**: ConvertFormatで「MPEG Video」→「mpeg2」等の正規化

### プログラム呼び出し階層図

```
CommandLineDemuxer.ShowConfigDialog()
    │
    └─ CommandLineDemuxForm.New(demuxer)
           │
           ├─ InitializeComponent()
           │      └─ UI初期化（7つの入力フィールド）
           │
           ├─ ObjectHelp.GetCopy() - 編集用コピー作成
           │
           ├─ ApplyTheme() - テーマ適用
           │
           └─ ShowDialog()
                  │
                  ├─ bnBrowse_Click → OpenFileDialog
                  │
                  ├─ MacrosToolStripMenuItem_Click → MacrosForm.ShowDialogForm()
                  │
                  ├─ HelpToolStripMenuItem_Click → Package.Items.ShowHelp()
                  │
                  └─ OnFormClosed()
                         └─ Target への設定値反映
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CommandLineDemuxer ──▶ CommandLineDemuxForm ──▶ CommandLineDemuxer
（既存設定）              │                        （更新後設定）
                         ├─ tbName（名前）
                         ├─ tbInput（入力拡張子）
                         ├─ tbVideoOut（出力拡張子）
                         ├─ tbInputFormats（フォーマット）
                         ├─ tbSourceFilters（ソースフィルタ）
                         ├─ tbCommand（コマンドパス）
                         └─ tbArguments（引数）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | ソース | 本画面のメインファイル |
| Demux.vb | `Source/General/Demux.vb` | ソース | CommandLineDemuxerデータクラス定義 |
| MacrosForm.vb | `Source/Forms/MacrosForm.vb` | ソース | マクロ一覧表示画面 |
| HelpForm.vb | `Source/Forms/HelpForm.vb` | ソース | ヘルプ表示画面 |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ情報管理（ヘルプ表示用） |
| DialogBase.vb | `Source/UI/DialogBase.vb` | ソース | ダイアログ基底クラス |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
| TipProvider.vb | `Source/UI/TipProvider.vb` | ソース | ツールチップ情報提供 |
