# 画面設計書 22-ダウンロード

## 概要

DownloadFormは、ファイルダウンロードの進捗を表示するためのダイアログ画面です。主にツールの自動更新機能において、外部ツールのダウンロード状況をリアルタイムで表示します。

### 本画面の処理概要

本画面は、指定されたURLからファイルを非同期ダウンロードし、進捗状況をプログレスバーで表示するシンプルなダイアログを提供します。

**業務上の目的・背景**：StaxRipは多数の外部ツール（x264、x265、ffmpeg、mkvmerge等）を使用しており、これらのツールは頻繁に更新されます。ユーザーがツールを最新版に更新する際、ダウンロードの進捗状況を視覚的に確認できることで、長時間ダウンロードでも処理が進んでいることを把握でき、またダウンロードをキャンセルする手段も提供されます。

**画面へのアクセス方法**：AppsForm（アプリケーション設定画面）のツールダウンロード機能から呼び出されます。また、UpdateFormからのアプリケーション更新処理時にも使用されます。直接ユーザーがアクセスする画面ではなく、ダウンロード処理開始時に自動的に表示されます。

**主要な操作・処理内容**：
1. ダウンロード進捗の表示 - 受信バイト数/総バイト数をMB単位で表示
2. プログレスバーによる視覚的な進捗表示
3. ダウンロードのキャンセル操作

**画面遷移**：
- 遷移元：AppsForm（ツール自動ダウンロード）、UpdateForm（アプリケーション更新）、ToolUpdate処理
- 遷移先：なし（モーダルダイアログとして閉じて完了）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | ツール自動ダウンロード | 主機能 | プログレスバーでダウンロード進捗表示 |

## 画面種別

進捗表示ダイアログ（モーダル）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`DownloadForm`クラスとして実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| ダウンロードURL | url | String | 入力（コンストラクタ） | Yes | ダウンロード対象のURL |
| 保存先パス | path | String | 入力（コンストラクタ） | Yes | ダウンロードファイルの保存先パス |
| 保存先パス | Path | String | 出力（プロパティ） | Yes | ダウンロード後のファイルパス |
| ダイアログ結果 | DialogResult | DialogResult | 出力 | Yes | OK（成功）またはCancel |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| タイトルバー | テキスト | "Download - {受信MB} MB of {総MB} MB" |
| プログレスバー | ProgressBar | 0から総バイト数を最大値としたダウンロード進捗 |
| Cancelボタン | Button | ダウンロードをキャンセル |

## イベント仕様

### 1-ダウンロード開始（コンストラクタ）

フォーム生成時にWebClientを使用して非同期ダウンロードを開始します。

**処理フロー**：
1. URLとパスを設定
2. WebClientにUserAgentとRefererヘッダを設定
3. DownloadFileAsyncで非同期ダウンロード開始
4. ProgressChangedとCompletedイベントハンドラを設定

### 2-進捗更新（ProgressChanged）

ダウンロード進捗が更新されるたびに呼び出されます。

**処理フロー**：
1. 受信バイト数と総バイト数をMB単位に変換
2. タイトルバーに進捗情報を表示
3. プログレスバーのMaximumとValueを更新

### 3-ダウンロード完了（Completed）

ダウンロードが完了した際に呼び出されます。

**処理フロー**：
1. キャンセルされていなければDialogResultをOKに設定
2. フォームを閉じる

### 4-Cancelボタン押下

Cancelボタンをクリックするとダウンロードをキャンセルします。

**処理フロー**：
1. WebClient.CancelAsyncでダウンロードをキャンセル
2. フォームを閉じる

### 5-フォームクローズ

フォームが閉じられる際にWebClientを破棄します。

## データベース更新仕様

本画面はデータベースを使用しません。ダウンロードしたファイルはファイルシステムに保存されます。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | Download - {x.x} MB of {y.y} MB | ダウンロード進捗更新時（タイトルバー） |

## 例外処理

- **ダウンロードエラー**：WebClientの例外はProgressChangedでTry-Catchにより捕捉され、進捗更新が中断されてもクラッシュしません
- **キャンセル処理**：CancelAsyncによりダウンロードが中断され、Completedイベントでe.Cancelled=Trueが設定されます

## 備考

- FormBorderStyleはFixedDialogに設定されており、ウィンドウサイズは変更できません
- タスクバーには表示されず、親ウィンドウの中央に表示されます
- ダウンロード時にはブラウザを偽装するUserAgentヘッダが設定されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面はシンプルな構造のため、主要なプロパティを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | Pathプロパティ（8行目）がダウンロード先パスを保持 |
| 1-2 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | WebClientフィールド（6行目）がダウンロード処理を担当 |

**読解のコツ**: System.Net.WebClientクラスの非同期ダウンロード機能を使用しています。

#### Step 2: エントリーポイントを理解する

コンストラクタでダウンロードが開始されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | コンストラクタ（10-18行目）でURL・パス設定とダウンロード開始 |

**主要処理フロー**:
1. **12行目**: 保存先パスをPathプロパティに設定
2. **13-14行目**: イベントハンドラを登録
3. **15-17行目**: UserAgentとRefererヘッダを設定（Webサーバーの制限回避用）
4. **18行目**: DownloadFileAsyncで非同期ダウンロード開始

#### Step 3: 進捗表示処理を理解する

ダウンロード進捗の更新処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ProgressChanged（21-29行目）で進捗バー更新 |

**主要処理フロー**:
- **23-24行目**: PrefixedSize(2)でMB単位に変換
- **25行目**: タイトルバーに「Download - x MB of y MB」形式で表示
- **26-27行目**: プログレスバーのMaximumとValueを更新

#### Step 4: 完了・キャンセル処理を理解する

ダウンロード完了とキャンセル処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | Completed（32-38行目）で完了時にDialogResult設定 |
| 4-2 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | bnCancel_Click（40-43行目）でキャンセル処理 |

**主要処理フロー**:
- **33-35行目**: キャンセルされていなければDialogResult.OKを設定
- **41行目**: CancelAsyncでダウンロードを中断
- **45-47行目**: OnFormClosedでWebClientを破棄

### プログラム呼び出し階層図

```
ToolUpdate.Download() / UpdateForm.Update()
    │
    └─ DownloadForm.New(url, path)
           │
           ├─ InitializeComponent() - UI初期化
           │
           ├─ WebClient.DownloadFileAsync() - 非同期ダウンロード開始
           │      │
           │      ├─ ProgressChanged ──▶ プログレスバー更新
           │      │                      タイトルバー更新
           │      │
           │      └─ Completed ──▶ DialogResult設定
           │                       フォームクローズ
           │
           └─ bnCancel_Click
                  │
                  └─ WebClient.CancelAsync()
```

### データフロー図

```
[入力]                  [処理]                      [出力]

URL ─────────────────▶ WebClient ─────────────────▶ ファイル
                       .DownloadFileAsync()         (Pathプロパティで指定)
                             │
                             ▼
                       ProgressChanged ─────────▶ プログレスバー
                             │                    タイトルバー
                             ▼
                       Completed ───────────────▶ DialogResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | 本画面のロジック |
| DownloadForm.Designer.vb | `Source/Forms/DownloadForm.Designer.vb` | ソース | UI定義 |
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | ダウンロード呼び出し元（ツール更新） |
| UpdateForm.vb | `Source/Forms/UpdateForm.vb` | ソース | ダウンロード呼び出し元（アプリ更新） |
| FormBase.vb | `Source/UI/FormBase.vb` | ソース | フォーム基底クラス |
