# 画面設計書 23-アップデート

## 概要

UpdateFormは、StaxRipアプリケーション本体の更新を行うための画面です。新しいバージョンが利用可能な場合にダウンロードと更新処理を実行します。

### 本画面の処理概要

本画面は、アプリケーション起動時またはユーザー要求に応じて、StaxRipの新しいバージョンを確認・ダウンロードする機能を提供します。

**業務上の目的・背景**：動画エンコードツールは、コーデックの更新やバグ修正により頻繁にアップデートされます。ユーザーが手動でダウンロードサイトにアクセスして更新を行う代わりに、アプリケーション内から直接更新を実行できることで、利便性が向上します。また、最新の機能やバグ修正を迅速に適用できます。

**画面へのアクセス方法**：MainFormのメニューからアップデート確認を選択することで表示されます。自動更新チェック機能が有効な場合は、起動時に自動的にバージョンチェックを行い、新バージョンがあれば通知されます。

**主要な操作・処理内容**：
1. 現在のバージョンと新バージョンの比較
2. 新バージョンのダウンロード（DownloadFormを経由）
3. ダウンロード完了後のファイル展開と配置
4. 更新結果の通知

**画面遷移**：
- 遷移元：MainForm（メニュー）
- 遷移先：DownloadForm（ファイルダウンロード時）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 71 | アップデート確認 | 主機能 | 新バージョンのダウンロードと更新 |
| 61 | ツール自動ダウンロード | 補助機能 | DownloadFormを経由したファイルダウンロード |

## 画面種別

進捗表示ダイアログ（モーダル）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`UpdateForm`クラスとして実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| 現在バージョン | Version | String | 内部取得 | - | My.Application.Info.Versionから取得 |
| 次バージョン | NextVersion | String | 定数 | - | ハードコード（2.0.0.1） |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| タイトルバー | テキスト | "Update" |
| プログレスバー | ProgressBar | ダウンロード進捗（0-100%） |

## イベント仕様

### 1-フォーム読み込み（Load）

フォーム表示時に更新チェックを開始します。

**処理フロー**：
1. Update()メソッドを呼び出し
2. 例外発生時はメッセージ表示後にフォームをクローズ

### 2-更新処理（Update）

非同期でバージョンチェックとダウンロードを実行します。

**処理フロー**：
1. 現在バージョン（My.Application.Info.Version）を取得
2. NextVersion（ハードコード）と比較
3. 現在バージョン < NextVersionの場合：
   - GitHubからStaxRip.rarをダウンロード
   - DownloadFormを経由してダウンロード
   - ダウンロード完了メッセージ表示
   - エクスプローラーでファイルを選択して開く
4. 既に最新の場合：
   - 「Already Running the Latest Version」メッセージ表示
   - フォームをクローズ

### 3-進捗更新（DownloadProgressChanged）

ダウンロード中の進捗をプログレスバーに反映します。

**処理フロー**：
1. e.ProgressPercentageをプログレスバーのValueに設定

## データベース更新仕様

本画面はデータベースを使用しません。ダウンロードされた更新ファイルはスタートアップフォルダに保存されます。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | Download Complete | ダウンロード正常完了時 |
| 情報 | Already Running the Latest Version! | バージョンチェックで最新版の場合 |
| 情報 | Already Running the Latest Version | ダウンロード後（Finally句） |
| エラー | {例外メッセージ} | 更新処理中に例外発生時 |

## 例外処理

- **更新処理全体の例外**：Load時にTry-Catchで捕捉し、メッセージ表示後にフォームをクローズ
- **WebException**：ダウンロード中のネットワークエラーはTry-Catchで捕捉

## 備考

- NextVersionがハードコードされているため、バージョン更新時はソースコードの修正が必要
- ダウンロードURLはGitHubのリリースページ（Revan654/staxrip）を指定
- FormBorderStyleはFixedDialogに設定されており、サイズ変更不可
- Finally句でダウンロードしたファイルを削除するロジックがあるが、これは更新キャンセル時の処理と思われる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は外部依存が少なくシンプルな構造です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | WebClientフィールド（4行目）でダウンロードを管理 |
| 1-2 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | NextVersion定数（15行目）で更新対象バージョンを定義 |

**読解のコツ**: バージョン比較は文字列比較で行われているため、バージョン形式に注意が必要です。

#### Step 2: エントリーポイントを理解する

フォーム読み込み時の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | Update_Load（5-12行目）でUpdate()を呼び出し |

**主要処理フロー**:
1. **7行目**: Update()非同期メソッドを呼び出し
2. **8-10行目**: 例外時はMsgInfoでエラー表示してClose()

#### Step 3: 更新処理を理解する

非同期の更新チェックとダウンロード処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | Update()（14-36行目）でバージョン比較とダウンロード |

**主要処理フロー**:
- **15行目**: NextVersion = "2.0.0.1"（ハードコード）
- **16行目**: 現在バージョンを"Major.Minor.Build.Revision"形式で取得
- **18行目**: Version < NextVersionで比較
- **20行目**: DownloadFileTaskAsyncでGitHubからダウンロード
- **22行目**: g.OpenDirAndSelectFileでエクスプローラーを開く
- **27行目**: Finally句でダウンロードファイルを削除

#### Step 4: 進捗表示を理解する

ダウンロード進捗の更新処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | UpdateForm.vb | `Source/Forms/UpdateForm.vb` | ScrappyProgressBar_Report（38-43行目）で進捗更新 |

**主要処理フロー**:
- **40行目**: e.ProgressPercentageをプログレスバーに設定

### プログラム呼び出し階層図

```
MainForm (メニュー)
    │
    └─ UpdateForm.New()
           │
           └─ Update_Load
                  │
                  └─ Update() (Async)
                         │
                         ├─ My.Application.Info.Version - 現在バージョン取得
                         │
                         ├─ Version比較
                         │      │
                         │      ├─ [新バージョンあり]
                         │      │     │
                         │      │     ├─ Progress.DownloadFileTaskAsync()
                         │      │     │     │
                         │      │     │     └─ ScrappyProgressBar_Report ──▶ 進捗更新
                         │      │     │
                         │      │     └─ g.OpenDirAndSelectFile()
                         │      │
                         │      └─ [最新版]
                         │            └─ MsgInfo("Already Running the Latest Version")
                         │
                         └─ Close()
```

### データフロー図

```
[入力]                     [処理]                          [出力]

My.Application.Info   ──▶  Version比較   ──▶  [新バージョンあり]
.Version                                              │
                                                      ▼
                                               WebClient
                                               .DownloadFileTaskAsync()
                                                      │
                                                      ▼
                                               StaxRip.rar ──▶ Folder.Startup
                                                      │
                                                      ▼
                                               g.OpenDirAndSelectFile()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UpdateForm.vb | `Source/Forms/UpdateForm.vb` | ソース | 本画面のロジック |
| UpdateForm.Designer.vb | `Source/Forms/UpdateForm.Designer.vb` | ソース | UI定義 |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗表示（参考） |
| Folder.vb | `Source/General/Folder.vb` | ソース | Folder.Startup等のパス定義 |
| GlobalCommands.vb | `Source/General/GlobalCommands.vb` | ソース | g.OpenDirAndSelectFile()の実装 |
