# 画面設計書 24-コード編集

## 概要

CodeFormは、スクリプトコードを表示・閲覧するための画面です。主にAviSynth/VapourSynthスクリプトの内容を確認する際に使用され、構文ハイライトとテキスト検索機能を提供します。

### 本画面の処理概要

本画面は、生成されたスクリプトやログ等のテキストコンテンツを読み取り専用で表示し、ユーザーが内容を確認・検索できる機能を提供します。

**業務上の目的・背景**：動画エンコードにおいて、AviSynth/VapourSynthスクリプトは動画フィルタリングの中核を担います。ユーザーがスクリプトの内容を確認したり、特定の設定項目を検索したりする必要があります。この画面はスクリプト内容を視覚的に確認でき、指定した文字列にジャンプする検索機能も提供します。

**画面へのアクセス方法**：MainFormのフィルタースクリプト編集時や、スクリプト確認機能から呼び出されます。コード表示が必要な各種場面で汎用的に使用されます。

**主要な操作・処理内容**：
1. スクリプト/コード内容の表示（読み取り専用）
2. 指定文字列の検索とハイライト
3. 検索結果へのジャンプ（スクロール）
4. ESCキーでのウィンドウクローズ

**画面遷移**：
- 遷移元：MainForm（スクリプト表示）、各種フィルター設定画面
- 遷移先：なし（表示専用モードレスダイアログ）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | コードエディタ | 主機能 | AviSynth/VapourSynthスクリプト表示 |
| 35 | AviSynth+連携 | 補助機能 | AviSynthスクリプト内容表示 |
| 36 | VapourSynth連携 | 補助機能 | VapourSynthスクリプト内容表示 |

## 画面種別

表示ダイアログ（リサイズ可能）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`CodeForm`クラスとして実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| テキスト内容 | text | String | 入力（コンストラクタ） | Yes | 表示するコード/スクリプト内容 |
| 検索文字列 | find | String | 入力（コンストラクタ） | No | 初期検索対象文字列 |
| ワードラップ | wordwrap | Boolean | 入力（コンストラクタ） | No | 行折り返し設定（デフォルト: False） |
| 検索文字列 | Find | String | プロパティ | - | 検索対象文字列を保持 |
| コンテンツ | Content | String | プロパティ | - | 表示内容を保持 |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| タイトルバー | テキスト | "Code - {アプリケーション詳細}" |
| コード表示エリア | RichTextBox | コード/スクリプト内容（読み取り専用） |

## イベント仕様

### 1-初期化（コンストラクタ）

コード表示領域を初期化し、テキストと検索文字列を設定します。

**処理フロー**：
1. InitializeComponentでUI初期化
2. RestoreClientSizeでウィンドウサイズを復元（50x35ユニット）
3. RichTextBoxを読み取り専用に設定
4. ワードラップ設定を適用
5. FontManager.GetCodeFont()でコードフォントを適用
6. テキスト内容を設定
7. テーマを適用

### 2-フォーム表示時（Shown）

検索文字列が指定されている場合、最初のマッチ位置にジャンプします。

**処理フロー**：
1. FindプロパティがEmptyでなければFindByIndex(0)を呼び出し
2. 該当文字列を検索してハイライト

### 3-検索処理（FindByIndex）

指定インデックス以降で検索文字列を探し、該当位置にスクロールします。

**処理フロー**：
1. startIndexがContent.Length以上なら終了
2. rtb.Findで検索実行
3. ScrollToCaretでスクロール
4. マッチ位置が行頭から15文字以上離れている場合は次のマッチを検索（再帰呼び出し）

### 4-ESCキー押下

ESCキーでフォームを閉じます。

**処理フロー**：
1. KeyData = Keys.Escapeを検知
2. Close()を呼び出し

### 5-テーマ変更

ThemeManagerの変更イベントに応答してテーマを適用します。

**処理フロー**：
1. RichTextBoxのForeColor/BackColorを更新

## データベース更新仕様

本画面はデータベースを使用しません。表示専用の読み取りダイアログです。

## メッセージ仕様

本画面にはメッセージ表示機能はありません。

## 例外処理

本画面に特定の例外処理はありません。検索が失敗した場合は単にハイライトされないだけです。

## 備考

- RichTextBoxはBorderStyleがNoneに設定され、フォームいっぱいに表示されます
- 読み取り専用のため、ユーザーはコンテンツを編集できません
- コードフォント（FontManager.GetCodeFont()）が適用され、等幅フォントで表示されます
- ウィンドウサイズはRestoreClientSizeにより前回のサイズが復元されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面のプロパティ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CodeForm.vb | `Source/Forms/CodeForm.vb` | Find、Contentプロパティ（7-8行目）で検索文字列と内容を保持 |

**読解のコツ**: VB.NETのPropertyキーワードで自動実装プロパティとして定義されています。

#### Step 2: エントリーポイントを理解する

コンストラクタでの初期化処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeForm.vb | `Source/Forms/CodeForm.vb` | コンストラクタ（10-26行目）でテキスト設定と初期化 |

**主要処理フロー**:
1. **12行目**: InitializeComponent()でUI初期化
2. **14行目**: RestoreClientSize(50, 35)でウィンドウサイズ復元
3. **16行目**: rtb.ReadOnly = Trueで読み取り専用設定
4. **17行目**: rtb.WordWrapでワードラップ設定
5. **18行目**: FontManager.GetCodeFont()で等幅フォント設定
6. **19行目**: rtb.Textにテキスト内容を設定
7. **21-22行目**: FindとContentプロパティを設定

#### Step 3: 検索処理を理解する

テキスト検索とスクロール処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeForm.vb | `Source/Forms/CodeForm.vb` | TextHelpForm_Shown（51-55行目）で初期検索を実行 |
| 3-2 | CodeForm.vb | `Source/Forms/CodeForm.vb` | FindByIndex（57-86行目）で再帰的に検索実行 |

**主要処理フロー**:
- **62行目**: rtb.Findで検索文字列を探索
- **63行目**: ScrollToCaretで該当位置にスクロール
- **68-80行目**: 行頭近くにない場合は次のマッチを探索（行の途中を避ける）
- **82-84行目**: マッチ位置から15文字以上離れていたら次を検索

#### Step 4: テーマ対応を理解する

ダークモード等のテーマ対応を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CodeForm.vb | `Source/Forms/CodeForm.vb` | ApplyTheme（42-49行目）でRichTextBoxの色を設定 |

**主要処理フロー**:
- **47-48行目**: theme.General.Controls.RichTextBoxから色を取得して適用

### プログラム呼び出し階層図

```
呼び出し元（MainForm等）
    │
    └─ CodeForm.New(text, find, wordwrap)
           │
           ├─ InitializeComponent() - UI初期化
           │
           ├─ RestoreClientSize() - ウィンドウサイズ復元
           │
           ├─ FontManager.GetCodeFont() - 等幅フォント取得
           │
           ├─ ApplyTheme() - テーマ適用
           │
           └─ Show() → Shown イベント
                  │
                  └─ FindByIndex(0) ──▶ rtb.Find()
                         │              rtb.ScrollToCaret()
                         │
                         └─ [再帰] FindByIndex(nextIndex)
```

### データフロー図

```
[入力]                    [処理]                      [出力]

text ─────────────────▶ rtb.Text ─────────────────▶ 画面表示
(スクリプト内容)                                    (RichTextBox)

find ─────────────────▶ FindByIndex() ────────────▶ ハイライト
(検索文字列)                 │                      スクロール
                            ▼
                       rtb.Find()
                       rtb.ScrollToCaret()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeForm.vb | `Source/Forms/CodeForm.vb` | ソース | 本画面のロジック |
| CodeForm.Designer.vb | `Source/Forms/CodeForm.Designer.vb` | ソース | UI定義 |
| FormBase.vb | `Source/UI/FormBase.vb` | ソース | フォーム基底クラス（RestoreClientSize等） |
| FontManager.vb | `Source/UI/FontManager.vb` | ソース | フォント管理（GetCodeFont） |
| RichTextBoxEx.vb | `Source/UI/RichTextBoxEx.vb` | ソース | 拡張RichTextBox |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
