# 画面設計書 26-データ

## 概要

DataFormは、汎用的なデータ表示・編集ダイアログです。DataGridViewを使用して表形式データを表示・編集する際に再利用可能な共通コンポーネントとして機能します。

### 本画面の処理概要

本画面は、表形式データの表示・編集が必要な様々な場面で使用される再利用可能なダイアログを提供します。

**業務上の目的・背景**：アプリケーション内で複数の場所で表形式データを表示・編集する必要がある場合、共通のUIコンポーネントを使用することで、一貫したユーザー体験と開発効率の向上を実現できます。DataFormはDataGridViewをラップし、OK/Cancelボタンによる確定・キャンセル操作を標準化した再利用可能なダイアログです。

**画面へのアクセス方法**：直接アクセスされることは少なく、各種機能（AppsForm、eac3toForm、MuxerForm、SourceFilesForm、VideoComparisonForm等）からデータ表示・編集が必要な場面で呼び出されます。

**主要な操作・処理内容**：
1. DataGridViewによる表形式データの表示
2. 行・セルの編集（呼び出し元の設定による）
3. OKボタンで変更を確定
4. Cancelボタンで変更を破棄
5. F1キーでヘルプを表示（HelpActionが設定されている場合）

**画面遷移**：
- 遷移元：AppsForm、eac3toForm、MuxerForm、SourceFilesForm、VideoComparisonForm等
- 遷移先：なし（モーダルダイアログ）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 汎用データ表示 | 主機能 | DataGridViewによる表形式データ表示・編集 |

## 画面種別

編集ダイアログ（モーダル、再利用可能コンポーネント）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`DataForm`クラスとして実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| データグリッド | dgv | DataGridViewEx | 入出力 | Yes | 呼び出し元がデータバインド |
| ヘルプアクション | HelpAction | Action | 入力 | No | F1キー押下時のヘルプ表示処理 |
| ダイアログ結果 | DialogResult | DialogResult | 出力 | Yes | OKまたはCancel |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| データグリッド | DataGridView | 表形式データ表示エリア（全体にアンカー） |
| OKボタン | Button | 右下に配置、変更を確定 |
| Cancelボタン | Button | 右下に配置、変更を破棄 |

## イベント仕様

### 1-初期化（コンストラクタ）

DataGridViewとボタンを初期化し、テーマを適用します。

**処理フロー**：
1. InitializeComponentでUI初期化
2. ApplyThemeでテーマ適用
3. ThemeManager.CurrentThemeChangedイベントをハンドリング

### 2-OKボタン押下

OKボタンをクリックすると、DialogResult.OKを返してダイアログを閉じます。

**処理フロー**：
1. DialogResult = DialogResult.OK（デザイナーで設定済み）
2. フォームが閉じられる

### 3-Cancelボタン押下

Cancelボタンをクリックすると、DialogResult.Cancelを返してダイアログを閉じます。

**処理フロー**：
1. DialogResult = DialogResult.Cancel（デザイナーで設定済み）
2. フォームが閉じられる

### 4-ヘルプリクエスト（F1キー）

F1キー押下時、HelpActionが設定されていれば実行します。

**処理フロー**：
1. HelpActionがNothingでなければInvoke
2. 呼び出し元が定義したヘルプ処理を実行

### 5-テーマ変更

ThemeManagerの変更イベントに応答してテーマを適用します。

**処理フロー**：
1. BackColorをテーマの背景色に更新

## データベース更新仕様

本画面はデータベースを使用しません。表示・編集するデータは呼び出し元から提供されます。

## メッセージ仕様

本画面固有のメッセージはありません。

## 例外処理

本画面に特定の例外処理はありません。

## 備考

- DialogBaseを継承しており、ダイアログの基本機能が利用可能
- DataGridViewExは拡張されたDataGridViewで、追加機能が提供される可能性あり
- KeyPreview = Trueにより、フォームレベルでキー入力をハンドリング
- AcceptButton/CancelButtonが設定されており、EnterキーでOK、EscキーでCancelが動作

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面のプロパティ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DataForm.vb | `Source/UI/DataForm.vb` | HelpActionプロパティ（5行目）でカスタムヘルプ処理を保持 |

**読解のコツ**: PropertyとしてAction型を持ち、呼び出し元からヘルプ処理を注入可能な設計です。

#### Step 2: エントリーポイントを理解する

コンストラクタでの初期化処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DataForm.vb | `Source/UI/DataForm.vb` | コンストラクタ（7-11行目）でUI初期化とテーマ適用 |

**主要処理フロー**:
1. **8行目**: InitializeComponent()でUI初期化
2. **9行目**: ApplyTheme()でテーマ適用
3. **11行目**: ThemeManager.CurrentThemeChangedイベントハンドリング

#### Step 3: テーマ対応を理解する

テーマ変更時の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DataForm.vb | `Source/UI/DataForm.vb` | ApplyTheme（22-28行目）で背景色を更新 |

**主要処理フロー**:
- **27行目**: BackColor = theme.General.BackColorでテーマ色適用

#### Step 4: ヘルプ機能を理解する

F1キー押下時のヘルプ表示処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DataForm.vb | `Source/UI/DataForm.vb` | DataForm_HelpRequested（30-32行目）でヘルプ処理実行 |

**主要処理フロー**:
- **31行目**: HelpAction?.Invoke()でNullセーフに呼び出し

### プログラム呼び出し階層図

```
呼び出し元（AppsForm/MuxerForm等）
    │
    └─ DataForm.New()
           │
           ├─ InitializeComponent() - UI初期化
           │      ├─ dgv (DataGridViewEx)
           │      ├─ bnOK (ButtonEx)
           │      └─ bnCancel (ButtonEx)
           │
           ├─ ApplyTheme() - テーマ適用
           │
           └─ [呼び出し元が dgv にデータバインド]
                  │
                  └─ ShowDialog()
                         │
                         ├─ bnOK_Click → DialogResult.OK
                         │
                         ├─ bnCancel_Click → DialogResult.Cancel
                         │
                         └─ F1キー → HelpAction?.Invoke()
```

### データフロー図

```
[入力]                    [処理]                      [出力]

呼び出し元              DataForm                   呼び出し元
  │                        │                          │
  ├─ データ ───────────▶ dgv.DataSource ────────▶ 編集後データ
  │                        │                          │
  └─ HelpAction ────────▶ HelpRequested ──────────▶ ヘルプ表示
                           │
                           └─ DialogResult ────────▶ OK/Cancel
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DataForm.vb | `Source/UI/DataForm.vb` | ソース | 本画面のロジック |
| DataForm.Designer.vb | `Source/UI/DataForm.Designer.vb` | ソース | UI定義 |
| DialogBase.vb | `Source/UI/DialogBase.vb` | ソース | ダイアログ基底クラス |
| DataGridViewEx.vb | `Source/UI/Controls/DataGridViewEx.vb` | ソース | 拡張DataGridView |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | 呼び出し元の例 |
| MuxerForm.vb | `Source/Forms/MuxerForm.vb` | ソース | 呼び出し元の例 |
