# 画面設計書 27-文字列エディタ

## 概要

StringEditorFormは、複数行テキストを編集するための汎用ダイアログです。コマンドラインオプションやスクリプト等の長いテキストを編集する際に使用されます。

### 本画面の処理概要

本画面は、複数行テキストの入力・編集が必要な場面で使用される再利用可能なエディタダイアログを提供します。

**業務上の目的・背景**：動画エンコード設定において、コマンドラインオプションやカスタムスクリプト等、複数行にわたるテキストを入力する必要があります。通常の1行テキストボックスでは不便なため、ワードラップ機能付きの複数行エディタを提供することで、ユーザーが長いテキストを効率的に編集できるようになります。

**画面へのアクセス方法**：コマンドライン設定画面やスクリプト編集が必要な各種画面から呼び出されます。テキストボックスのダブルクリック等で起動されることが多いです。

**主要な操作・処理内容**：
1. RichTextBoxによる複数行テキスト編集
2. ワードラップ（行折り返し）のオン/オフ切り替え
3. OKボタンで編集内容を確定
4. Cancelボタンで編集をキャンセル
5. Ctrl+Enterでも確定可能

**画面遷移**：
- 遷移元：コマンドライン設定画面、スクリプト編集が必要な各種画面
- 遷移先：なし（モーダルダイアログ）

**権限による表示制御**：特になし（全ユーザー共通）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 複数行テキスト編集 | 主機能 | コマンドラインオプション等の編集 |

## 画面種別

編集ダイアログ（モーダル、リサイズ可能）

## URL/ルーティング

Windows Formsアプリケーションのため、URL/ルーティングは該当なし。`StringEditorForm`クラス（StaxRip.UI名前空間）として実装。

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|------|----------|------|------|
| テキスト内容 | rtb.Text | String | 入出力 | No | 編集対象のテキスト |
| ワードラップ | cbWrap.Checked | Boolean | 入力 | No | 行折り返し設定（デフォルト: True） |
| ダイアログ結果 | DialogResult | DialogResult | 出力 | Yes | OKまたはCancel |

## 表示項目

| 表示項目 | 表示形式 | 説明 |
|----------|----------|------|
| タイトルバー | テキスト | "String Editor - {アプリケーション詳細}" |
| テキスト編集エリア | RichTextBox | 複数行テキスト編集（Panelでラップ） |
| Wrapチェックボックス | CheckBox | 左下に配置、ワードラップ切り替え |
| OKボタン | Button | 右下に配置、編集を確定 |
| Cancelボタン | Button | 右下に配置、編集をキャンセル |

## イベント仕様

### 1-初期化（コンストラクタ）

RichTextBoxとボタンを初期化し、テーマを適用します。

**処理フロー**：
1. InitializeComponentでUI初期化
2. cbWrap.Checked = Trueでデフォルトでワードラップ有効
3. FontManager.GetCodeFont()でコードフォント適用
4. ScaleClientSize(41, 24)でウィンドウサイズ設定
5. ApplyTheme()でテーマ適用
6. ThemeManager.CurrentThemeChangedイベントをハンドリング

### 2-OKボタン押下

OKボタンをクリックすると、DialogResult.OKを返してダイアログを閉じます。

**処理フロー**：
1. DialogResult = DialogResult.OK（デザイナーで設定済み）
2. フォームが閉じられる

### 3-Cancelボタン押下

Cancelボタンをクリックすると、DialogResult.Cancelを返してダイアログを閉じます。

**処理フロー**：
1. DialogResult = DialogResult.Cancel（デザイナーで設定済み）
2. フォームが閉じられる

### 4-Ctrl+Enter押下

RichTextBox内でCtrl+Enterを押すとOKボタンと同じ動作をします。

**処理フロー**：
1. KeyData = (Keys.Enter Or Keys.Control)を検知
2. e.Handled = Trueでデフォルト動作を抑制
3. bnOK.PerformClick()でOKボタン押下をシミュレート

### 5-Wrapチェックボックス変更

ワードラップの切り替えを行います。

**処理フロー**：
1. cbWrap.CheckedChangedイベントを検知
2. rtb.WordWrap = cbWrap.Checkedで設定を反映

### 6-テーマ変更

ThemeManagerの変更イベントに応答してテーマを適用します。

**処理フロー**：
1. BackColorをテーマの背景色に更新

## データベース更新仕様

本画面はデータベースを使用しません。編集したテキストは呼び出し元で使用されます。

## メッセージ仕様

本画面固有のメッセージはありません。

## 例外処理

本画面に特定の例外処理はありません。

## 備考

- FormBaseを継承しており、フォームの基本機能が利用可能
- UI名前空間に定義されており、再利用可能なUIコンポーネント
- RichTextBoxExはBorderStyle.Noneで、PanelにDockFillで配置
- MinimumSizeが設定されており、極端に小さくはできない
- ShowInTaskbar = Falseでタスクバーには表示されない
- AcceptsTab = Trueでタブ文字の入力が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

名前空間とクラス定義を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StringEditorForm.vb | `Source/UI/StringEditorForm.vb` | Namespace UI内に定義（2行目）、FormBase継承（4行目） |

**読解のコツ**: UIコンポーネントとしてStaxRip.UI名前空間に配置されています。

#### Step 2: エントリーポイントを理解する

コンストラクタでの初期化処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StringEditorForm.vb | `Source/UI/StringEditorForm.vb` | コンストラクタ（106-115行目）でUI初期化 |

**主要処理フロー**:
1. **108行目**: InitializeComponent()でUI初期化
2. **109行目**: cbWrap.Checked = Trueでデフォルトワードラップ有効
3. **110行目**: FontManager.GetCodeFont()で等幅フォント設定
4. **111行目**: ScaleClientSize(41, 24)でウィンドウサイズ設定
5. **112行目**: ApplyTheme()でテーマ適用

#### Step 3: キーボードショートカットを理解する

Ctrl+Enterでの確定処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StringEditorForm.vb | `Source/UI/StringEditorForm.vb` | tb_KeyDown（139-144行目）でCtrl+Enter処理 |

**主要処理フロー**:
- **140行目**: Keys.Enter Or Keys.Controlの組み合わせを検知
- **141行目**: e.Handled = Trueでデフォルト動作抑制
- **142行目**: bnOK.PerformClick()でOK処理実行

#### Step 4: ワードラップ切り替えを理解する

チェックボックスによるワードラップ制御を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StringEditorForm.vb | `Source/UI/StringEditorForm.vb` | cbWrap_CheckedChanged（146-148行目）でワードラップ切り替え |

**主要処理フロー**:
- **147行目**: rtb.WordWrap = cbWrap.Checkedで即座に反映

### プログラム呼び出し階層図

```
呼び出し元（設定画面等）
    │
    └─ StringEditorForm.New()
           │
           ├─ InitializeComponent() - UI初期化
           │      ├─ rtb (RichTextBoxEx) - テキスト編集
           │      ├─ cbWrap (CheckBoxEx) - ワードラップ
           │      ├─ bnOK (ButtonEx) - 確定
           │      └─ bnCancel (ButtonEx) - キャンセル
           │
           ├─ FontManager.GetCodeFont() - 等幅フォント
           │
           ├─ ScaleClientSize() - サイズ設定
           │
           └─ ApplyTheme() - テーマ適用
                  │
                  └─ ShowDialog()
                         │
                         ├─ rtb.KeyDown
                         │     └─ Ctrl+Enter → bnOK.PerformClick()
                         │
                         ├─ cbWrap.CheckedChanged
                         │     └─ rtb.WordWrap = cbWrap.Checked
                         │
                         ├─ bnOK_Click → DialogResult.OK
                         │
                         └─ bnCancel_Click → DialogResult.Cancel
```

### データフロー図

```
[入力]                    [処理]                      [出力]

初期テキスト ─────────▶ rtb.Text ──────────────▶ 編集後テキスト
                           │
                           ▼
ワードラップ設定 ──────▶ cbWrap.Checked ────────▶ rtb.WordWrap
                           │
                           ▼
                       DialogResult ────────────▶ OK/Cancel
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StringEditorForm.vb | `Source/UI/StringEditorForm.vb` | ソース | 本画面のロジック（デザイナー統合） |
| FormBase.vb | `Source/UI/FormBase.vb` | ソース | フォーム基底クラス |
| RichTextBoxEx.vb | `Source/UI/RichTextBoxEx.vb` | ソース | 拡張RichTextBox |
| CheckBoxEx.vb | `Source/UI/CheckBoxEx.vb` | ソース | 拡張CheckBox |
| FontManager.vb | `Source/UI/FontManager.vb` | ソース | フォント管理 |
| ThemeManager.vb | `Source/UI/ThemeManager.vb` | ソース | テーマ管理 |
